#ifndef ASN1
#define ASN1

#include <stdio.h>


                            /* Class       */
#define ASN_UNI       0     /* Universal   */
#define ASN_APL       1     /* Application */
#define ASN_CTX       2     /* Context     */
#define ASN_PRV       3     /* Private     */

                            /* Tag                */
#define ASN_EOC       0     /* End Of Contents    */
#define ASN_BOL       1     /* Boolean            */
#define ASN_INT       2     /* Integer            */
#define ASN_BTS       3     /* Bit String         */
#define ASN_OTS       4     /* Octet String       */
#define ASN_NUL       5     /* Null               */
#define ASN_OJI       6     /* Object Identifier  */
#define ASN_OJD       7     /* Object Description */
#define ASN_EXT       8     /* External           */
#define ASN_SEQ       16    /* Sequence           */
#define ASN_SET       17    /* Set                */
#define ASN_NUMSTR    18    /* Numerical String   */
#define ASN_PRNSTR    19    /* Printable String   */
#define ASN_TEXSTR    20    /* Teletext String    */
#define ASN_VIDSTR    21    /* Video String       */
#define ASN_IA5STR    22    /* IA5 String         */
#define ASN_UNITIM    23    /* Universal Time     */
#define ASN_GENTIM    24    /* General Time       */
#define ASN_GRASTR    25    /* Graphical String   */
#define ASN_VISSTR    26    /* Visible String     */
#define ASN_GENSTR    27    /* General String     */

                            /* Primitie / Constructed */
#define ASN_PRI     0       /* Primitive              */
#define ASN_CON     1       /* Constructed            */

                            /* Mode to open ASN1 */
#define ASN_ENC     0       /* Encoding          */
#define ASN_DEC     1       /* Decoding          */


typedef struct
{                           /* ASN1 socket                         */
    char    *SckPtr;        /* Octet just encoded or to be decoded */
    char    *SckBeg;        /* First octet                         */
    char    *SckEnd;        /* Octet after last octet              */
}
    asn_sck;

void
    AsnOpn
    (
        asn_sck     *Asn,
        char        *Buf,
        unsigned    Len,
        unsigned    Mde
    );
void
    AsnCls
    (
        asn_sck     *Asn,
        char        **Buf,
        unsigned    *Len
    );
int
    AsnHdrEnc
    (
        asn_sck     *Asn,
        char        *Eoc,
        unsigned    Cls,
        unsigned    Con,
        unsigned    Tag
    );
int
    AsnHdrDec
    (
        asn_sck     *Asn,
        char        **Eoc,
        unsigned    *Cls,
        unsigned    *Con,
        unsigned    *Tag
    );
int
    AsnEoc
    (
        asn_sck *Asn,
        char    *Eoc
    );
int
    AsnEocEnc
    (
        asn_sck *Asn,
        char    **Eoc
    );
int
    AsnEocDec
    (
        asn_sck *Asn,
        char    *Eoc
    );
int
    AsnNulEnc
    (
        asn_sck *Asn,
        char    **Eoc
    );
int
    AsnNulDec
    (
        asn_sck *Asn,
        char    *Eoc
    );
int
    AsnBolEnc
    (
        asn_sck *Asn,
        char    **Eoc,
        int     Bol
    );
int
    AsnBolDec
    (
        asn_sck *Asn,
        char    *Eoc,
        int     *Bol
    );
int
    AsnIntEnc
    (
        asn_sck *Asn,
        char    **Eoc,
        int     Int
    );
int
    AsnIntDec
    (
        asn_sck *Asn,
        char    *Eoc,
        int     *Int
    );
int
    AsnIntEncLng
    (
        asn_sck *Asn,
        char    **Eoc,
        long    Int
    );
int
    AsnIntDecLng
    (
        asn_sck *Asn,
        char    *Eoc,
        long    *Int
    );
int
    AsnIntEncUns
    (
        asn_sck     *Asn,
        char        **Eoc,
        unsigned    Int
    );
int
    AsnIntDecUns
    (
        asn_sck     *Asn,
        char        *Eoc,
        unsigned    *Int
    );
int
    AsnIntEncLngUns
    (
        asn_sck         *Asn,
        char            **Eoc,
        unsigned long   Int
    );
int
    AsnIntDecLngUns
    (
        asn_sck         *Asn,
        char            *Eoc,
        unsigned long   *Int
    );
int
    AsnBtsEnc
    (
        asn_sck     	*Asn,
        char        	**Eoc,
        char        	*Bts,
        unsigned    	BtsLen,
        unsigned char   BtsUnu
    );
int
    AsnBtsDec
    (
        asn_sck     	*Asn,
        char        	*Eoc,
        char        	*Bts,
        unsigned    	BtsSze,
        unsigned    	*BtsLen,
        unsigned char   *BtsUnu
    );
int
    AsnOtsEnc
    (
        asn_sck     *Asn,
        char        **Eoc,
        char        *Ots,
        unsigned    OtsLen
    );
int
    AsnOtsDec
    (
        asn_sck     *Asn,
        char        *Eoc,
        char        *Ots,
        unsigned    OtsSze,
        unsigned    *OtsLen
    );
int
    AsnOjiEnc
    (
        asn_sck     *Asn,
        char        **Eoc,
        unsigned    *Oji,
        unsigned    OjiLen
    );
int
    AsnOjiDec
    (
        asn_sck     *Asn,
        char        *Eoc,
        unsigned    *Oji,
        unsigned    OjiSze,
        unsigned    *OjiLen
    );

#endif


