/* msg.c */

#define TCL_SNMP_INTERNAL 1

#include <tcl.h>
#include <tclExtend.h>

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <memory.h>
#include <sys/time.h>
#include "tcl_snmp.h"

int 
tcl_snmp_msg_send(Tcl_Interp *interp,t_cldat *cd,t_desc *t,pkt_msg *m)
    {
    pkt_ror *r;
    int z;

    r = &m->MsgPdu.PduRor;
    r->RorRid = cd->serial;
    r->RorErrSts = 0;
    r->RorErrInd = 0;
    t->RqsBeg = t->Rqs;
    t->RqsLen = MGT_SZEPKT;
    if (PktEnc (tcl_snmp_udp_addr(t->addr), m, &t->RqsBeg, (unsigned *)&t->RqsLen) < 0)
	{
        Tcl_AppendResult(interp,"failed: Cannot encode request.",0);
        return TCL_ERROR;
	}
    z = tcl_snmp_udp_send(cd->udp,t->addr,t->RqsBeg,t->RqsLen);
    if(z != TCL_OK)
	{
        Tcl_AppendResult(interp,"failed: Couldn't send request:",
	    Tcl_UnixError(interp),0);
        return TCL_ERROR;
	}
    return TCL_OK;
    }


int 
tcl_snmp_msg_resend(Tcl_Interp *interp,t_cldat *cd,t_desc *t)
    {
    int z;

    z = tcl_snmp_udp_next(t->addr);
    if(z != TCL_OK)
	{
        Tcl_AppendResult(interp,"tcl_snmp_udp_next:",
	    Tcl_UnixError(interp),0);
        return TCL_ERROR;
	}
    z = tcl_snmp_udp_send(cd->udp,t->addr,t->RqsBeg,t->RqsLen);
    if(z != TCL_OK)
	{
        Tcl_AppendResult(interp,"failed: Couldn't send request:",
	    Tcl_UnixError(interp),0);
        return TCL_ERROR;
	}
    return TCL_OK;
    }

int
tcl_snmp_msg_recv(Tcl_Interp *interp,t_cldat *cd,pkt_msg *m)
    {
    int z;
    char Rsp[MGT_SZEPKT];
    int RspLen = MGT_SZEPKT;

    z = tcl_snmp_udp_recv(cd->udp,Rsp,&RspLen);
    if(z != TCL_OK)
	{
        Tcl_AppendResult(interp,"failed: Couldn't recv request:",
	    Tcl_UnixError(interp),0);
        return TCL_ERROR;
	}
#ifdef DEBUG_RECV_DUMP
    printf("%d ",RspLen);
    for(z=0;z<RspLen;z++)
	printf("%02x",Rsp[z]);
    printf("\n");
#endif
    z = PktDec(0,m,Rsp,RspLen);
    if(z < 0)
	{
        Tcl_AppendResult(interp,"failed: Cannot decode request.",0);
        return TCL_ERROR;
	}
    return TCL_OK;
    }

int
tcl_snmp_msg_send_recv(Tcl_Interp *interp,t_cldat *cd,t_desc *t,int *stat)
    {
    int r,y,z;
    fd_set fdv;
    struct timeval to;


    *stat = 0;
    to.tv_sec = t->cur.timeout / 1000000L;
    to.tv_usec = t->cur.timeout % 1000000L;

    cd->serial++;
    
    for(r=0;r<t->cur.retry;r++)
	{
	if(!r)
	    z=tcl_snmp_msg_send(interp,cd,t,&t->m);
	else
	    z=tcl_snmp_msg_resend(interp,cd,t);
	if(z != TCL_OK) return z;
    again:
	for(;;)
	    {
	    FD_ZERO(&fdv);
	    y=tcl_snmp_udp_fd(cd->udp);
	    if(!y)
		{
		Tcl_AppendResult(interp,"tcl_snmp_udp_fd: ",
		    Tcl_UnixError(interp),0);
		return TCL_ERROR;
		}
	    FD_SET(y,&fdv);
	    z = select(y+1,(int*)&fdv,NULL,(int*)&fdv,&to);
	    if(z < 0)
		{
		Tcl_AppendResult(interp,"failed: select failed:",
		    Tcl_UnixError(interp),0);
		return TCL_ERROR;
		}
	    if(!z)
		break;
	    RET_IF_NOT_OK(tcl_snmp_msg_recv(interp,cd,&t->m));
	    if(t->m.MsgPdu.PduRor.RorRid == cd->serial)
		{
		*stat = 1;
		return TCL_OK;
		}
	    goto again;
	    }
	}
    return TCL_OK;
    }
