#ifdef TCL_SNMP_INTERNAL

#include "./snmp.h"
#include "./pkt.h"

#ifndef DEF_CBS
#define DEF_CBS 100
#endif

typedef struct {
    char        community[80];
    char        mib[80];
    char        Mib[80];
    unsigned long timeout;
    int         retry;
    char        prefix[BUFSIZ];
    } t_opt;

typedef struct {
    char	*desc;
    char	*cmd;
    char	*var1;
    char	*var2;
    t_opt	opt;
    int		opt_v;
    } t_callback;

typedef struct {
    char        host[80];
    char        desc[20];
    t_opt       def;
    t_opt       cur;
    pkt_msg     m;
    void_pt     addr;
    char        Rqs [MGT_SZEPKT], *RqsBeg;
    int         RqsLen;
    int		opt_v;
    int		opt_l;
    int		opt_P;
    t_callback	cb;
    } t_desc;

typedef struct {
    Tcl_Interp  *interp;
    void_pt     handles;
    void_pt     pdus;
    void_pt     udp;
    t_desc	tpdu;
    int         serial;
    int		ncbs;
    t_callback	*cbs;
    t_desc	*desc;
    } t_cldat;

typedef struct {
    pkt_msg	m;
    int		v_bit;
    } t_pdu;

/* From udp.c */
void_pt		tcl_snmp_udp_init();
int		tcl_snmp_udp_kill(void_pt pr);
void_pt		tcl_snmp_udp_open(void_pt pr,char *name,char *ptr);
int		tcl_snmp_udp_close(void_pt pr, void_pt ip);
int		tcl_snmp_udp_send(void_pt pr,void_pt ip,char* ptr,int len);
int		tcl_snmp_udp_recv(void_pt pr,char* ptr,int *len);
unsigned long	tcl_snmp_udp_addr(void_pt ip);
int		tcl_snmp_udp_fd(void_pt ip);
int		tcl_snmp_udp_next(void_pt ip);

/* from msg.c */
int tcl_snmp_msg_send(Tcl_Interp *interp,t_cldat *cd,t_desc *t,pkt_msg *m);
int tcl_snmp_msg_resend(Tcl_Interp *interp,t_cldat *cd,t_desc *t);
int tcl_snmp_msg_send_recv(Tcl_Interp *interp,t_cldat *cd,t_desc *t,int *stat);
int tcl_snmp_msg_recv(Tcl_Interp *interp,t_cldat *cd,pkt_msg *m);

#define RET_IF_NOT_OK(xx) {register int z1; if((z1=(xx)) != TCL_OK) return z1; }
#define RET_IF_ERROR(xx) {register int z1; if((z1=(xx)) == TCL_ERROR) return z1; }
#endif

int init_tcl_snmp(Tcl_Interp *interp);
