/* udp.c */

#define SNMP_PORT	161
#define DEFAULT_MNA 10 	/* can be anything > 0 */

#include <tcl.h>
#include <tclExtend.h>

#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#ifndef __386BSD__
#include <sys/socket.h>
#include <netinet/in.h>
#endif
#include <sys/time.h>
#include <netdb.h>
#include <sys/errno.h>

#define TCL_SNMP_INTERNAL 1
#include "tcl_snmp.h"

#define MAGICIP		0x92384239	/* No, they're just two numbers... */
#define MAGICPRIV	0x394028a8

typedef struct 
    {
    unsigned long magic;
    char	  *ptr;
    int		  idx;
    int		  n;
    unsigned long p[1];
    } t_ipaddr;

typedef struct
    {
    unsigned long magic;
    int		  s;
    int		  mna;
    int		  na;
    t_ipaddr	  **a;
    } t_priv;

extern int errno;

#define TOIP(dst,src,fail) { \
	errno = 0;  \
	dst = (t_ipaddr*)src; \
	if(!dst || dst->magic != MAGICIP) \
		{ errno=EBADF; return fail; } \
	}

#define TOPRIV(dst,src,fail) { \
	errno = 0;  \
	dst = (t_priv*)src; \
	if(!dst || dst->magic != MAGICPRIV) \
		{ errno=EBADF; return fail; } \
	}

int
tcl_snmp_udp_next(void_pt ip)
    {
    t_ipaddr *a;

    TOIP(a,ip,TCL_ERROR);
    a->idx = (a->idx+1) % a->n;
    return TCL_OK;
    }

unsigned long
tcl_snmp_udp_addr(void_pt ip)
    {
    t_ipaddr *t;

    TOIP(t,ip,0L);
    return t->p[0];
    }

int 
tcl_snmp_udp_fd(void_pt pr)
    {
    t_priv	*p;

    TOPRIV(p,pr,0L);
    return p->s;
    }

void_pt
tcl_snmp_udp_init()
    {
    t_priv	*p;
    int s;

    s = socket(AF_INET, SOCK_DGRAM, 0);
    if(s < 0) return 0;

    p=(t_priv *)ckalloc(sizeof *p);
    memset(p,0,sizeof *p);
    p->s = s;
    p->mna = DEFAULT_MNA;
    p->a = (t_ipaddr**)ckalloc(sizeof *p->a * p->mna);
    memset(p->a,0,p->mna * sizeof *p->a);
    p->na = 0;
    p->magic = MAGICPRIV;
    return (void_pt)p;
    }

int
tcl_snmp_udp_kill(void_pt pr)
    {
    t_priv	*p;
    int		i;

    TOPRIV(p,pr,TCL_ERROR);
    close(p->s);
    for(i=0;i<p->na;i++)
	ckfree(p->a[i]);
    ckfree(p->a);
    ckfree(p);
    return TCL_OK;
    }

void_pt
tcl_snmp_udp_open(void_pt pr,char *name,char *ptr)
    {
    struct hostent *he;
    int i;
    t_ipaddr *ip;
    unsigned long l;
    t_ipaddr **tmp;
    t_priv	*p;

    TOPRIV(p,pr,0);
    he = gethostbyname(name);
    if(!he) 
	{
	l = inet_addr(name);
	if(l == (unsigned long) -1) return 0;
	ip = (t_ipaddr *)ckalloc(sizeof *ip);
	ip->idx = 0;
	ip->n = 1;
	ip->p[0] = l;
	goto and_so_on;
	}
    if(he->h_addrtype != AF_INET) return 0;
    i = sizeof *ip + he->h_length; /* this is sizeof(long) too much ... */
    ip = (t_ipaddr *)ckalloc(i);
    ip->n = he->h_length / sizeof(long);
    ip->idx = 0;
    memcpy(ip->p,*he->h_addr_list,he->h_length);
and_so_on:
    ip->ptr = ptr;
    if(p->na == p->mna)
	{
	tmp = p->a;
	p->mna *= 2;
	p->a = (t_ipaddr**)ckalloc(p->mna * sizeof *p->a);
	memset(p->a,0,p->mna * sizeof *p->a);
	memcpy(p->a,tmp,p->na * sizeof *p->a);
	ckfree(tmp);
	}
    p->a[p->na++] = ip;
    ip->magic = MAGICIP;
    return (void_pt)ip;
    }

int
tcl_snmp_udp_close(void_pt pr, void_pt ip)
    {
    t_priv   *p;
    t_ipaddr *a;
    int i;

    TOPRIV(p,pr,TCL_ERROR);
    TOIP(a,ip,TCL_ERROR);
    for(i=0;i<p->na;i++)
	{
	if(p->a[i] == a)
	    {
	    ckfree(a);
	    p->a[i] = p->a[--p->na];
	    return TCL_OK;
	    }
	}
    return TCL_ERROR;
    }

int 
tcl_snmp_udp_send(void_pt pr,void_pt ip,char* ptr,int len)
    {
    t_priv    *p;
    t_ipaddr *a;
    struct sockaddr_in fm;
    int i;

    TOPRIV(p,pr,TCL_ERROR);
    TOIP(a,ip,TCL_ERROR);

    fm.sin_addr.s_addr = a->p[a->idx];
    fm.sin_family = AF_INET;
    fm.sin_port = htons(SNMP_PORT);
    i = sendto(p->s,ptr,len,0,&fm,sizeof fm);
    if(i<0) return TCL_ERROR;
    return TCL_OK;
    }

int
tcl_snmp_udp_recv(void_pt pr,char* ptr,int *len)
    {
    t_priv	*p;
    struct sockaddr_in fm;
    int i,j;
    unsigned long a;

    TOPRIV(p,pr,TCL_ERROR);
    j = sizeof fm;
    i = recvfrom(p->s,ptr,*len,0,&fm,&j);
    if(i<0) return TCL_ERROR;
    *len = i;
    a = fm.sin_addr.s_addr;
    for(i=0;i<p->na;i++)
	{
	for(j=0;j<p->a[i]->n;j++)
	    if(a == p->a[i]->p[j])
		{
		p->a[i]->idx = j;
		break;
		}
	}
    return TCL_OK;
    }
