#
# try to find out what's going on...

puts stdout "autoconfig probing system..."
set fo [open autoconfig.tmp w]

puts $fo {set libtk ""}
puts $fo {set libx11 ""}
puts $fo {set libdbm ""}
puts $fo {set libextra ""}
puts $fo {set optcurses ""}

proc SET {var val} {
    global fo $var
    set $var "$val"
    puts $fo "set $var \"$val\""
    }

if {[catch {exec gcc -v} a]} {
    puts stdout "Found no gcc in PATH"
    puts $fo "set cc cc"
} else {
    puts stdout "Found gcc"
    puts $fo "set cc {gcc -O}"
}

# SunOS
if {![catch {exec sun}]} {
    puts stdout "Found SunOS, defaults -lm -ldbm"
    SET libm -lm
    SET libdbm -ldbm
    if {[file exists /usr/5lib/libcurses.a]} {
	puts stdout "Found libcurses.a in /usr/5lib"
        SET libcurses /usr/5lib/libcurses.a
	SET optcurses -I/usr/5include
    }
} else { 
    if {[file exist /386bsd]} {
	puts stdout "Found 386BSD"
	puts stdout "fixing makefiles..."
	# We rely on make(1) to look for 'makefile' before 'Makefile' ...
	system {find . -name 'Makefile' -print |
		while read d
		do
			e=`echo $d | sed 's/Makefile/makefile/'`
			sed '/^include[ 	]*\(.*\)/s//.include "\1"/' $d > $e
		done
		}
	SET libextra -ltermlib
    } else {
    }
}

proc findlib {dir lib var} {
    global $var fo

    if {[catch "set $var"]} {
	if {[file exists ${dir}/lib${lib}.a]} {
	    puts stdout "Found lib${lib}.a in $dir"
	    SET $var $dir/lib${lib}.a
	}
    }
}
foreach i {
	/local/lib 
	/usr/local/lib 
	/lib 
	/usr/lib 
	/usr/openwin/lib
	} {
	findlib $i X11 libx11 
	findlib $i curses libcurses
	findlib $i tcl libtcl
	findlib $i tk libtk
	findlib $i ndbm libdbm
	findlib $i dbm libdbm
	findlib $i m libm
}

close $fo
