/* tcl_snmp.c 
 * used for tk_snmp.c too, see Makefile...
 */
#if ( defined(TK_SNMP) && TK_SNMP!=0 ) || !defined(TK_SNMP)
#include <tcl.h>
#include <tclExtend.h>
#ifdef TK_SNMP /* TK_SNMP */
#    include <tk.h>
#endif /* TK_SNMP */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <ctype.h>
#include <memory.h>
#include <sys/time.h>
#define TCL_SNMP_INTERNAL 1
#include "tcl_snmp.h"

#define IFW(st) if(**argv==*st && !strcmp(*argv,st))
#define ERR_N_ARG(syntax) { Tcl_AppendResult(interp, "bad # arg: ", \
	"\nSyntax is: ", syntax, 0) ; return TCL_ERROR; }
#define CHKNARG(min,max,syntax) if(argc<min || argc>max) ERR_N_ARG(syntax)

static void
SetCb(t_callback *cb,char *cmd, char *var1,char *var2, t_opt *opt, int opt_v)
    {

    if(cb->cmd)  ckfree(cb->cmd);  cb->cmd  = 0;
    if(cb->var1) ckfree(cb->var1); cb->var1 = 0;
    if(cb->var2) ckfree(cb->var2); cb->var2 = 0;

    if(cmd)  strcpy(cb->cmd  = ckalloc(strlen(cmd) +1),cmd );
    if(var1) strcpy(cb->var1 = ckalloc(strlen(var1)+1),var1);
    if(var2) strcpy(cb->var2 = ckalloc(strlen(var2)+1),var2);

    if(opt)
	cb->opt = *opt;
    else
	memset(&cb->opt,0,sizeof cb->opt);
    cb->opt_v = opt_v;
    }

static int
defaults(Tcl_Interp *interp, t_opt *o)
    {
    strcpy(o->community,"public");
    RET_IF_ERROR(Tcl_Eval(interp,"info commands mib",0,0));
    strcpy(o->mib,interp->result);
    strcpy(o->Mib,interp->result);
    Tcl_ResetResult(interp);
    strcpy(o->prefix,".1.3.6.1.2.1");
    o->timeout = 5*1000000L;
    o->retry = 3;
    return TCL_OK;
    }

static int
FormatOID(Tcl_Interp *interp,pkt_obj *o,char *p,int len)
    {
    int j;
    char *q = p+len-10;

    *p = '\0';
    for(j=0;j< o->ObjOjiLen;j++)
	{
	while(*p) p++;
	if(p > q) 
	    {
	    Tcl_AppendResult(interp,"FormatOID result too long.",0);
	    return TCL_ERROR;
	    }
        sprintf(p,".%u", o->ObjOji[j]);
	}
    return TCL_OK;
    }

static int
ConvOID(t_desc *td,char *oid,int *d,int *l)
    {
    int i=0;
    char *s=oid;

    if(*s++ != '.') return TCL_ERROR;
    for(;*s;s++)
	{
	if(*s == '.') 
	    d[++i]=0;
	else if(isdigit(*s))
	    {
	    d[i] *= 10;
	    d[i] += *s - '0';
	    }
	else return TCL_ERROR;
	}
    d[++i]=0;
    *l = i;
    return TCL_OK;
    }

int 
ParseOID(Tcl_Interp *interp,t_desc *td,char *oid,int *d, int *l)
    {
    char b[BUFSIZ],c[BUFSIZ],*p;

    if(*td->cur.mib)
	{
	sprintf(c,"%s parse_oid %s %s",td->cur.mib,oid,td->cur.prefix);
	RET_IF_NOT_OK(Tcl_Eval(interp,c,0,0));
	strcpy(b,interp->result);
	Tcl_ResetResult(interp);
	if(TCL_OK == ConvOID(td,b,d,l))
	    return TCL_OK;
	Tcl_AppendResult(interp,"ParseOID result from '",
		c,"' was bad: '",b,"'",0);
	return TCL_ERROR;
	}
    if(*oid != '.')
	{
	strcpy(b,td->cur.prefix);
	strcat(b,".");
	strcat(p=b,oid);
	}
    else
	p=oid;

    if(TCL_OK == ConvOID(td,p,d,l))
	return TCL_OK;
    Tcl_AppendResult(interp,"ParseOID couldn't parse '",
	    p,"' argument was: '",oid,"'",0);
    return TCL_ERROR;
    }



/*
 * Parse a (l)oid(v) into a pkt_msg.
 */
static int
ParseLOIDV(
	Tcl_Interp	*interp,
	t_cldat		*cd,
	t_desc		*td,
	char		*arg,
	pkt_msg		*m,
	int		v_bit		/* Parse values for 'set' */
	) 
    {
    int		i,j;
    char	*p;
    int		ac,bc;
    char	**av,**bv;
    t_pdu	*pdu;
    char	b[BUFSIZ];
    pkt_obj	*o;
    unsigned long l;

    if(td->opt_P)
	{
	if(!(pdu = (t_pdu*)Tcl_HandleXlate(interp,cd->pdus,arg)))
	    return TCL_ERROR;
	if(v_bit && !pdu->v_bit)
	    {
	    Tcl_AppendResult(interp, "failed: ",
		"This PDU has no values, can't use it for 'set'",0);
	    return TCL_ERROR;
	    }
	memcpy(m,&pdu->m,sizeof *m);
	return TCL_OK;
	}
    if(td->opt_l)
	{
	RET_IF_NOT_OK(Tcl_SplitList(interp,arg,&ac,&av));
	if(!ac)
	    {
	    Tcl_AppendResult(interp, "failed: ",
		"<[l]oid[v]> argument was empty",0);
	    return TCL_ERROR;
	    }
	}
    else
	{ ac = 1; av = &arg; }

    if(!ac)
	{
	Tcl_AppendResult(interp,"ParseLOIDV got empty list.",0);
	return TCL_ERROR;
	}
    memset(m,0,sizeof *m);
    m->MsgPdu.PduRor.RorLstLen=ac;
    o = m->MsgPdu.PduRor.RorLst;
    for(j=0;j<ac;j++,o++)
	{
	RET_IF_NOT_OK(Tcl_SplitList(interp,av[j],&bc,&bv));
	if(!bc)
	    {
	    Tcl_AppendResult(interp,"ParseLOIDV got empty sublist.",0);
	    return TCL_ERROR;
	    }

	RET_IF_NOT_OK(ParseOID(interp,td,*bv, o->ObjOji, &o->ObjOjiLen));
	if(v_bit) /* parse val & type for 'set' */
	    {
	    if(*td->cur.mib)
	        {
	        sprintf(b,"%s parse_value {%s}",td->cur.mib,bv[1]);
	        if(bc > 2)
	            sprintf(b+strlen(b)," {%s}",bv[2]);
		ckfree(bv);
		RET_IF_NOT_OK(Tcl_Eval(interp,b,0,0));
		RET_IF_NOT_OK(Tcl_SplitList(interp,interp->result,&bc,&bv));
		Tcl_ResetResult(interp);
	        }
	    else
	    	{
	    	bc--;
	    	bv[0]=bv[1];
	    	bv[1]=bv[2];
	    	}
	    if(bc != 2)
	        {
		Tcl_AppendResult(interp,
		    "ParseLOIDV got wrong arguments. <",bv[0],"> <",bv[1],">",0);
		return TCL_ERROR;
	        }
	    if(!strcmp(bv[0],"Integer"))
	    	{
	    	o->ObjTag = PKT_INTEGER;
	    	if(1 != sscanf(bv[1],"%i",&o->ObjSyn.SynLngInt)) goto syntax;
	    	}
	    else if(!strcmp(bv[0],"OID"))
	    	{
	    	o->ObjTag = PKT_OBJECTIDENTIFIER;
	    	if(TCL_OK != 
	    	    ParseOID(interp,td,bv[1],o->ObjSyn.SynBufInt,&o->ObjSynLen))
	    	    goto syntax;
	    	}
	    else if(!strcmp(bv[0],"IpAddress"))
	    	{
	    	l = inet_addr(bv[1]);
#ifdef INADDR_NONE
	    	if(l == INADDR_NONE) goto syntax;
#else
	    	if(l == (unsigned long) -1) goto syntax;
#endif
	    	l = ntohl(l);
	    	o->ObjTag = PKT_IPADDRESS;
	    	o->ObjSynLen = 4;
	    	o->ObjSyn.SynBufChr[0] = 0xff & (l >> 24);
	    	o->ObjSyn.SynBufChr[1] = 0xff & (l >> 16);
	    	o->ObjSyn.SynBufChr[2] = 0xff & (l >> 8);
	    	o->ObjSyn.SynBufChr[3] = 0xff & (l >> 0);
	    	}
	    else if(!strcmp(bv[0],"Counter"))
	    	{
	    	o->ObjTag = PKT_COUNTER;
	    	if(1 != sscanf(bv[1],"%i",&o->ObjSyn.SynLngInt)) goto syntax;
	    	}
	    else if(!strcmp(bv[0],"Gauge"))
	    	{
	    	o->ObjTag = PKT_GAUGE;
	    	if(1 != sscanf(bv[1],"%i",&o->ObjSyn.SynLngInt)) goto syntax;
	    	}
	    else if(!strcmp(bv[0],"TimeTicks"))
	    	{
	    	o->ObjTag = PKT_TIMETICKS;
	    	if(1 != sscanf(bv[1],"%i",&o->ObjSyn.SynLngInt)) goto syntax;
	    	}
	    else if(!strcmp(bv[0],"DisplayString"))
	    	{
	    	o->ObjTag = PKT_OCTETSTRING;
	    	o->ObjSynLen = strlen(bv[1]);
	    	strcpy(o->ObjSyn.SynBufChr,bv[1]);
	    	}
	    else if(!strcmp(bv[0],"OctetString"))
	    	{
	    	o->ObjTag = PKT_OCTETSTRING;
	    	goto decode;
	    	}
	    else if(!strcmp(bv[0],"Opaque"))
	    	{
	    	o->ObjTag = PKT_OPAQUE;
	    decode:
	    	for(i=0,j=0,p=bv[1];*p;p++)
	    	    {
	    	    if(isdigit(*p))
	    	        {
	    	        j *= 10;
	    	        j += *p - '0';
	    	        }
		    else if (*p == '-')
		        {
		        o->ObjSyn.SynBufChr[i++] = j;
		        j=0;
		        }
		    else
		    	goto syntax;
	    	    }
		o->ObjSyn.SynBufChr[i++] = j;
	    	o->ObjSynLen = i;
	    	}
	    else
	    	{
		Tcl_AppendResult(interp,"Illegal type: ",bv[0],0);
		return TCL_ERROR;
	    syntax:
		Tcl_AppendResult(interp,"Syntax error in ",bv[0]," '",bv[1],"'",0);
		return TCL_ERROR;
		}
	    }
	ckfree(bv);
	}
    if(td->opt_l)
	ckfree(av);
    return TCL_OK;
    }

static int
FormatLOIDV(
	Tcl_Interp	*interp,
	t_opt		*opt,
	char		*v,
	int		val_only,
	pkt_msg		*m
    ) {
    int i,n,j;
    char b[BUFSIZ],c[BUFSIZ],oi[BUFSIZ],r[BUFSIZ],*p,*tp,*vl;
    pkt_obj *o;
    unsigned u;
    int ac;
    char **av;


    /* Check for errors */
    if(m->MsgPdu.PduRor.RorErrSts != PKT_NOERROR)
	{
	switch(m->MsgPdu.PduRor.RorErrSts) 
	    {
	    case PKT_TOOBIG:		p = "tooBig"; break;
	    case PKT_NOSUCHNAME:	p = "noSuchName"; break;
	    case PKT_BADVALUE:		p = "badValue"; break;
	    case PKT_READONLY:		p = "readOnly"; break;
	    case PKT_GENERR:		p = "genErr"; break;
	    default:		
		sprintf(p=b,"0x%x",m->MsgPdu.PduRor.RorErrSts);
		break;
	    }
	sprintf(c,"SNMP error: error-status = %s  error-index= %d",
		p,m->MsgPdu.PduRor.RorErrInd);
	Tcl_AppendResult(interp,c,0);
	return TCL_ERROR;
	}

    *r = '\0';
    n=m->MsgPdu.PduRor.RorLstLen;
    for(i=0;i < n;i++)
	{
	o = m->MsgPdu.PduRor.RorLst+i;
	RET_IF_NOT_OK(FormatOID(interp,o,oi,sizeof oi));

	vl=b;
	switch(o->ObjTag)
	    {
	    case PKT_NULL:
		    tp="null";;
		    vl="null";
		break;
	    case PKT_INTEGER:
		    tp="Integer";
		    sprintf(b,"%ld",o->ObjSyn.SynLngInt);
		break;
	    case PKT_OCTETSTRING:
		    tp="OctetString";
		    goto codehex;
		break;
	    case PKT_OBJECTIDENTIFIER:
		    tp="OID";
		    p=b;
		    *p = '\0';
		    for(j=0;j< o->ObjSynLen;j++)
			{
			while(*p) p++;
			u=(unsigned int) o->ObjSyn.SynBufInt[j];
			sprintf(p,".%u", u);
			}
		break;
	    case PKT_IPADDRESS:
		    tp="IpAddress";
		    p=b;
		    *p = '\0';
		    for(j=0;j<4;j++)
			{
			while(*p) p++;
			u = (unsigned char) o->ObjSyn.SynBufChr[j];
			sprintf(p,".%u", u);
			}
		    vl=b+1;
		break;
	    case PKT_COUNTER:
		    tp="Counter";
		    sprintf(b,"%lu",o->ObjSyn.SynLngInt);
		break;
	    case PKT_GAUGE:
		    tp="Gauge";
		    sprintf(b,"%lu",o->ObjSyn.SynLngInt);
		break;
	    case PKT_TIMETICKS:
		    tp="TimeTicks";
		    sprintf(b,"%lu",o->ObjSyn.SynLngInt);
		break;
	    case PKT_OPAQUE:
		    tp="Opaque";
	    codehex:
		    p=b;
		    *p='\0';
		    p[1] = '\0';
		    for(j=0;j<o->ObjSynLen;j++)
			{
			while(*p) p++;
			u=(unsigned char) o->ObjSyn.SynBufChr[j];
			sprintf(p,"-%u", u);
			}
		    vl=b+1;
		break;
	    }
	if(*opt->Mib)
	    {
	    sprintf(c,"%s format %s %s %s",opt->Mib,oi,tp,vl);
	    RET_IF_ERROR(Tcl_Eval(interp,c,0,0));
	    RET_IF_NOT_OK(Tcl_SplitList(interp,interp->result,&ac,&av));
	    if(ac != 3)
		{
		ckfree(av);
		Tcl_AppendResult(interp, "return from '",c,
		    "' has wrong format, got '",interp->result,"'",0);
		return TCL_ERROR;
		}
	    if(val_only)
	        strcpy(p=b,av[2]);
	    else
		strcpy(p=b,interp->result);
	    Tcl_ResetResult(interp);
	    ckfree(av);
	    }
	else if(val_only)
	    {
	    p = vl;
	    }
	else
	    sprintf(p=c,"{%s %s %s}",oi,tp,vl);
	if(n > 1)
	    {
	    strcat(r,p);
	    strcat(r,"\n");
	    }
	else
	    {
	    if(v) Tcl_SetVar(interp,v, p,0);
	    else Tcl_AppendResult(interp, p, 0);
	    return TCL_OK;
	    }
	}
    if(v)
	Tcl_SetVar(interp,v,r,0);
    else
	Tcl_AppendResult(interp, r, 0);
    return TCL_OK;
    }

static int
DoOpt(Tcl_Interp *interp,int *argc,char ***argv,t_desc *td,int p)
    {
    int j,i=0;
    td->opt_l = td->opt_v = td->opt_P = 0;
    memcpy(&td->cur,&td->def,sizeof td->cur);

    /* ARGV = keyw handle [option value]* args  */
    /*        0    1       2+2*n  3+2*n   4+2*n */

    while(*argc > (p+1) && *((*argv))[p] == '-')
	{
	if(!strcmp((*argv)[p],"-l"))
	    { td->opt_l++; i=1; goto cut; }
	else if(!strcmp((*argv)[p],"-v"))
	    { td->opt_v++; i=1; goto cut; }
	else if(!strcmp((*argv)[p],"-P"))
	    { td->opt_P++; i=1; goto cut; }
	else if(*argc < (p+2))
	    {
	    Tcl_AppendResult(interp, "syntax:",
		"option",(*argv)[p],"needs argument.",0);
	    return TCL_ERROR;
	    }
	i = 2;
	if(!strcmp((*argv)[p],"-c"))
	    strcpy(td->cur.community,(*argv)[p+1]);
	if(!strcmp((*argv)[p],"-m"))
	    {
	    strcpy(td->cur.mib,(*argv)[p+1]);
	    strcpy(td->cur.Mib,(*argv)[p+1]);
	    }
	else if(!strcmp((*argv)[p],"-mp"))
	    strcpy(td->cur.mib,(*argv)[p+1]);
	else if(!strcmp((*argv)[p],"-mf"))
	    strcpy(td->cur.Mib,(*argv)[p+1]);
	else if(!strcmp((*argv)[p],"-p"))
	    strcpy(td->cur.prefix,(*argv)[p+1]);
	else if(!strcmp((*argv)[p],"-t"))
	    td->cur.timeout = atol((*argv)[p+1]);
	else if(!strcmp((*argv)[p],"-r"))
	    td->cur.retry = atoi((*argv)[p+1]);
	else
	    {
	    Tcl_AppendResult(interp, "syntax:",
		"unknown option:",(*argv)[p],0);
	    return TCL_ERROR;
	    }
    cut:
	for(j=0;j<i;j++)
	    (*argv)[p+j]=(*argv)[j];
	(*argv) +=i; *argc -=i;
	}
    return TCL_OK;
    }
/*
 * SnmpProc(cd,interp,argc,argv)
 * ============================
 *
 * Do the actual work.
 *
 */

static int
SnmpProc(cd,interp,argc,argv)
    t_cldat	*cd;
    Tcl_Interp	*interp;
    int		argc;
    char	**argv;
    {
    int i,z,type;
    char buf[BUFSIZ];
    char buf2[BUFSIZ];
    t_desc *td,**ttd;
    t_pdu *pdu;
    pkt_msg m;

    argv++; argc--;
    if(!argc)
	ERR_N_ARG("snmp <args>");

/*
!
! snmp open <host> <authentication>
!
*/
    IFW("open")
	{
	CHKNARG(2, 3, "snmp open <host> <authentication>");
        
	td = (t_desc*)ckalloc(sizeof *td);
	memset(td,0,sizeof *td);
	td->addr = tcl_snmp_udp_open(cd->udp,argv[1],(void_pt)td);
	if(!td->addr)
	    {
	    Tcl_AppendResult(interp, 
		"Failed to resolve address of ",argv[1], 0);
	    ckfree(td);
	    return TCL_ERROR;
	    }
	strcpy(td->host,argv[1]);
	RET_IF_NOT_OK(defaults(interp,&td->def));
	ttd = (t_desc **)Tcl_HandleAlloc(cd->handles,td->desc);
	*ttd = td;
	Tcl_AppendResult(interp,td->desc,0);
	return TCL_OK;
	}

    IFW("default")
	{
	CHKNARG(3, 5, "snmp default { <sess> | pdu } <param> [<val>]");
	if(!strcmp(argv[1],"pdu"))
	    td = &cd->tpdu;
	else
	    {
	    if(!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
		return TCL_ERROR;
	    td = *ttd;
	    }
	argc-=2;
	argv+=2;
/*
! snmp default { <sess> | pdu } prefix [ <oid> ]
*/
	IFW("prefix")
	    {
	    if(argc == 1) Tcl_SetResult(interp,td->def.prefix,TCL_STATIC);
	    else strcpy(td->def.prefix,argv[1]);
	    return TCL_OK;
	    }
/*
! snmp default { <sess> | pdu } mib [ <cmd> ]
*/
	IFW("mib")
	    {
	    if(argc == 1) Tcl_SetResult(interp,td->def.mib,TCL_STATIC);
	    else {
		strcpy(td->def.mib,argv[1]);
		strcpy(td->def.Mib,argv[1]);
		}
	    return TCL_OK;
	    }
/*
! snmp default { <sess> | pdu } mibp [ <cmd> ]
*/
	IFW("mibp")
	    {
	    if(argc == 1) Tcl_SetResult(interp,td->def.mib,TCL_STATIC);
	    else strcpy(td->def.mib,argv[1]);
	    return TCL_OK;
	    }
/*
! snmp default { <sess> | pdu } mibf [ <cmd> ]
*/
	IFW("mibf")
	    {
	    if(argc == 1) Tcl_SetResult(interp,td->def.Mib,TCL_STATIC);
	    else strcpy(td->def.Mib,argv[1]);
	    return TCL_OK;
	    }
/*
! snmp default { <sess> | pdu } community [ <string> ]
*/
	IFW("community")
	    {
	    if(argc == 1) Tcl_SetResult(interp,td->def.community,TCL_STATIC);
	    else strcpy(td->def.community,argv[1]);
	    return TCL_OK;
	    }
/*
! snmp default { <sess> | pdu } timeout [ <int> ]
*/
	IFW("timeout")
	    {
	    if(argc == 1) 
		{
		sprintf(buf,"%lu",td->def.timeout);
		Tcl_SetResult(interp,buf,TCL_STATIC);
		}
	    else td->def.timeout = atol(argv[1]);
	    return TCL_OK;
	    }
/*
! snmp default { <sess> | pdu } retry [ <int> ]
*/
	IFW("retry")
	    {
	    if(argc == 1) 
		{
		sprintf(buf,"%u",td->def.retry);
		Tcl_SetResult(interp,buf,TCL_STATIC);
		}
	    else td->def.retry = atol(argv[1]);
	    return TCL_OK;
	    }
	Tcl_AppendResult(interp,"syntax:","unknown <param>.",0);
	return TCL_ERROR;
	}

/*
! snmp rmpdu <pdu>
*/
    IFW("rmpdu")
	{
	if(!(pdu = (t_pdu*)Tcl_HandleXlate(interp,cd->pdus,argv[1])))
	    return TCL_ERROR;
	Tcl_HandleFree(cd->pdus,pdu);
	return TCL_OK;
	}

/*
! snmp mkpdu [ <opt> ] <(l)oid(v)>
*/
    IFW("mkpdu")
	{
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,&cd->tpdu,1));
	if(!(pdu = (t_pdu*)Tcl_HandleAlloc(cd->pdus,buf)))
	    return TCL_ERROR;
	/* TODO: free the pdu on error */
	RET_IF_NOT_OK(ParseLOIDV(interp,cd,&cd->tpdu,argv[1],&pdu->m,cd->tpdu.opt_v));
	pdu->v_bit = cd->tpdu.opt_v;
	Tcl_AppendResult(interp,buf,0);
	return TCL_OK;
	}
/*
!
! snmp set <sess> [<opt>] <[l]oidv> [<var>]
!
*/
    IFW("set")
	{
	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,td,2));
	CHKNARG(3, 4, "snmp set <sess> [<opt>] <[l]oidv> [<var>]");
	type = PKT_SETRQS;
	RET_IF_NOT_OK(ParseLOIDV(interp,cd,td,argv[2],&td->m,1));
        goto just_the_same;
	}

/*
!
! snmp getnext <sess> [<opt>] <[l]oid[v]> [<var>]
!
*/
    IFW("getnext")
	{
	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,td,2));
	CHKNARG(3, 4, "snmp getnext <sess> [<opt>] <[l]oid[v]> [<var>]");
	type = PKT_NXTRQS;
	RET_IF_NOT_OK(ParseLOIDV(interp,cd,td,argv[2],&td->m,0));
        goto just_the_same;
	}

/*
!
! snmp get <sess> [<opt>] <[l]oid[v]> [<var>]
!
*/
    IFW("get")
	{
	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,td,2));
	CHKNARG(3, 4, "snmp get <sess> [<opt>] <[l]oid[v]> [<var>]");
	type = PKT_GETRQS;
	RET_IF_NOT_OK(ParseLOIDV(interp,cd,td,argv[2],&td->m,0));
    just_the_same:
	strcpy(td->m.MsgCom, td->cur.community);
	td->m.MsgComLen=strlen(td->cur.community);
	td->m.MsgPdu.PduRor.RorTyp=type;
	td->m.MsgPdu.PduRor.RorRid=0;
	td->m.MsgPdu.PduRor.RorErrSts=PKT_NOERROR;
	td->m.MsgPdu.PduRor.RorErrInd=0;
	RET_IF_NOT_OK(tcl_snmp_msg_send_recv(interp,cd,td,&i));
	if(!i && argc > 3)
	    { Tcl_AppendResult(interp,"1",0); return TCL_OK; }
	else if(!i)
	    {
	    Tcl_AppendResult(interp, "snmp ",argv[0]," failed: no response",0);
	    return TCL_ERROR;
	    }

	if(argc > 3)
	    {
	    RET_IF_NOT_OK(FormatLOIDV(interp,&td->cur,argv[3],td->opt_v,&td->m));
	    Tcl_AppendResult(interp,"0",0);
	    }
	else
	    RET_IF_NOT_OK(FormatLOIDV(interp,&td->cur,0,td->opt_v,&td->m));
	return TCL_OK;
	}
/*
!
! snmp getbulk <sess> [<opt>] <[l]oid[v]> <var> [<var>] <proc>
!
*/
    IFW("getbulk")
	{
	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,td,2));
	CHKNARG(5, 6, "snmp getbulk <sess> [<opt>] <loid> <var> <proc>");
	RET_IF_NOT_OK(ParseLOIDV(interp,cd,td,argv[2],&td->m,0));
	RET_IF_NOT_OK(FormatOID(interp,td->m.MsgPdu.PduRor.RorLst,buf,sizeof buf));
	for(;;)
	    {
	    strcpy(td->m.MsgCom, td->cur.community);
	    td->m.MsgComLen=strlen(td->cur.community);
	    td->m.MsgPdu.PduRor.RorTyp=PKT_NXTRQS;
	    td->m.MsgPdu.PduRor.RorRid=0;
	    td->m.MsgPdu.PduRor.RorErrSts=PKT_NOERROR;
	    td->m.MsgPdu.PduRor.RorErrInd=0;
	    RET_IF_NOT_OK(tcl_snmp_msg_send_recv(interp,cd,td,&i));
	    if(!i)
		{
		Tcl_AppendResult(interp, "snmp getbulk failed: no response",0);
		return TCL_ERROR;
		}
	    if(td->m.MsgPdu.PduRor.RorErrSts == PKT_NOSUCHNAME)
		break;
	    RET_IF_NOT_OK(FormatOID(interp,td->m.MsgPdu.PduRor.RorLst,buf2,sizeof buf2));
	    if(strncmp(buf,buf2,strlen(buf)))
		break;
	    RET_IF_NOT_OK(FormatLOIDV(interp,&td->cur,argv[3],td->opt_v,&td->m));
	    if(argc == 5)
	        z = Tcl_VarEval(interp,argv[4],0);
	    else
 	        {
                Tcl_SetVar(interp,argv[4], argv[1],0);
	        z = Tcl_VarEval(interp,argv[5],0);
 	        }
	    if(z == TCL_BREAK) break;
	    else if(z != TCL_OK && z != TCL_CONTINUE) return z;
	    }
	return TCL_OK;
	}

/*
!
! snmp send <sess> [<opt>] <type> <[l]oid[v]> [<var> [<var>] <proc>]
!
*/
    IFW("send")
	{
	char *pv1,*pv2,*pc;

	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,td,2));
	if(argc != 4 && argc != 6 && argc != 7)
	    {
	    CHKNARG(1,0,
    "snmp send <sess> [<opt>] <type> <[l]oid[v]> [<var> [<var>] <proc>]");
	    }
	if(!strcmp(argv[2],"get"))		type=PKT_GETRQS;
	else if(!strcmp(argv[2],"getnext"))	type=PKT_NXTRQS;
	else if(!strcmp(argv[2],"set"))		type=PKT_SETRQS;
	else
	    {
	    Tcl_AppendResult(interp, 
		"snmp send failed: <type> must be 'get', 'set' or 'getnext'",0);
	    return TCL_ERROR;
	    }
	RET_IF_NOT_OK(ParseLOIDV(interp,cd,td,argv[3],&td->m,type==PKT_SETRQS));
	strcpy(td->m.MsgCom, td->cur.community);
	td->m.MsgComLen=strlen(td->cur.community);
	td->m.MsgPdu.PduRor.RorTyp=type;
	td->m.MsgPdu.PduRor.RorRid=0;
	td->m.MsgPdu.PduRor.RorErrSts=PKT_NOERROR;
	td->m.MsgPdu.PduRor.RorErrInd=0;
	cd->serial++;
	i = cd->serial % cd->ncbs;

	cd->cbs[i].desc = td->desc;
	if(argc == 4)
	    SetCb(cd->cbs+i,td->cb.cmd,td->cb.var1,td->cb.var2,
		&td->cb.opt,td->cb.opt_v);
	else if(argc == 6)
	    SetCb(cd->cbs+i,argv[5],argv[4],0,&td->cur,td->opt_v);
	else if(argc == 7)
	    SetCb(cd->cbs+i,argv[6],argv[4],argv[5],&td->cur,td->opt_v);

	RET_IF_NOT_OK(tcl_snmp_msg_send(interp,cd,td,&td->m));
	return TCL_OK;
	}

/*
!
! snmp resend <sess>
!
*/

    IFW("resend")
        {
	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	type = td->m.MsgPdu.PduRor.RorTyp;
	if(type != PKT_GETRQS && type != PKT_NXTRQS && type != PKT_SETRQS)
	    {
	    Tcl_AppendResult(interp, "Can't resend, invalid pdu.",0);
	    return TCL_ERROR;
	    }
	RET_IF_NOT_OK(tcl_snmp_msg_send(interp,cd,td,&td->m));
	return TCL_OK;
	}

/*
!
! snmp callback <sess> [<opt>] [<var> [<var>] <proc>]
!
*/

    IFW("callback")
	{
	char *pv,*pc;

	if(argc < 2 ||
		!(ttd = (t_desc**)Tcl_HandleXlate(interp,cd->handles,argv[1])))
	    return TCL_ERROR;
	td = *ttd;
	RET_IF_NOT_OK(DoOpt(interp,&argc,&argv,td,2));
	if(argc == 2)
	    SetCb(&td->cb,0,0,0,0,0);
	else if(argc == 4)
	    SetCb(&td->cb,argv[3],argv[2],0,&td->cur,td->opt_v);
	else if(argc == 5)
	    SetCb(&td->cb,argv[4],argv[2],argv[3],&td->cur,td->opt_v);
	else
	    {
	    CHKNARG(1,0,
		"snmp callback <sess> [<opt>] [<var> [<var>] <proc>]");
	    }
	return TCL_OK;
	}
#if 0
/*
!
! snmp wait [<opt>] <var> <var>
!
*/
    IFW("wait")
	{
	t_callback *cb;

	for(;;)
	    {
	    RET_IF_NOT_OK(tcl_snmp_msg_recv(interp,cd,&m));
	    i = m.MsgPdu.PduRor.RorRid % cd->ncbs;
	    cb = cd->cbs+i;
#if 0
	    printf("seq=%d var=<%s> cmd=<%s>\n",i,cb->var,cb->cmd);
#endif
	    if(!cb->var)
		break;
	    RET_IF_NOT_OK(FormatLOIDV( interp,&cb->opt,cb->var,cb->opt_v,&m));
	    RET_IF_NOT_OK(Tcl_Eval(interp,cb->cmd,0,0));
	    }
	return TCL_ERROR;
	}
#endif
    Tcl_AppendResult(interp, "snmp couldn't grok this:",0);
    return TCL_ERROR;
    }

#ifdef TK_SNMP
void
tk_snmp_event(t_cldat *cd, int mask)
    {
    Tcl_Interp	*interp = cd->interp;
    t_callback *cb;
    pkt_msg m;
    int i,z,type;
    char buf[BUFSIZ];
    char buf2[BUFSIZ];
    t_desc *td,**ttd;
    t_pdu *pdu;

    RET_IF_NOT_OK(tcl_snmp_msg_recv(interp,cd,&m));
    i = m.MsgPdu.PduRor.RorRid % cd->ncbs;
    cb = cd->cbs+i;
#if 0
    printf("seq=%d var1=<%s> var2=<%s> cmd=<%s>\n",i,cb->var1,cb->var2,cb->cmd);
#endif

    if(!cb->var1)
	return;

    RET_IF_NOT_OK(FormatLOIDV( interp,&cb->opt,cb->var1,cb->opt_v,&m));

    if(cb->var2) Tcl_SetVar(interp,cb->var2, cb->desc,0);
    if (TCL_OK != Tcl_Eval(interp,cb->cmd,0,0))
	Tk_BackgroundError(interp);
    }
#endif /* TK_SNMP */

/*
 * init_tcl_snmp(interp)  and init_tk_snmp(interp)
 * ===============================================
 *
 * Initialize the SNMP interface for the interpreter 'interp'
 *
 */

int
#ifdef TK_SNMP
init_tk_snmp(interp)
#else /* TK_SNMP */
init_tcl_snmp(interp)
#endif /* TK_SNMP */
    Tcl_Interp	*interp;
    {
    t_cldat *cd;
    void_pt *p;

    p = tcl_snmp_udp_init();
    if(!p) return TCL_ERROR;
    cd = (t_cldat *)ckalloc(sizeof *cd);
    memset((void*)cd,0,sizeof *cd);
    cd->handles = Tcl_HandleTblInit("snmp",sizeof(t_desc*),10);
    cd->pdus = Tcl_HandleTblInit("pdu",sizeof(t_pdu),10);
    cd->udp = p;
    cd->interp = interp;
    cd->ncbs = DEF_CBS;
    cd->cbs = ckalloc(sizeof *cd->cbs * cd->ncbs);
    memset((void*)cd->cbs,0,sizeof *cd->cbs * cd->ncbs);
    RET_IF_NOT_OK(defaults(interp,&cd->tpdu.def));
    Tcl_CreateCommand(interp,"snmp",SnmpProc,(ClientData)cd,0);
#ifdef TK_SNMP
    Tk_CreateFileHandler(tcl_snmp_udp_fd(p),
	TK_READABLE,tk_snmp_event,(ClientData)cd);
#endif
    return TCL_OK;
    }
#endif
