/*
 * misc.c
 *
 * Some utility functions that are used in other places.
 *
 * Copyright (c) 1993, 1994
 *                    J. Schoenwaelder
 *                    TU Braunschweig, Germany
 *                    Institute for Operating Systems and Computer Networks
 *
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <pwd.h>

#ifdef DBMALLOC
#include <dbmalloc.h>
#endif

#include "tkined.h"

/*
 * A general purpose sprintf buffer.
 */
static char buffer[1024];

/*
 * A fail-save malloc.
 */

char*
xmalloc (size)
    unsigned size;
{
    char *mem;

    for (;;) 
    {
	mem = (char*) malloc(size);
	if (mem) break;
	sleep (1);
    }
    
    return mem;
}

/*
 * Define out own strdup. At least our ultrix machine does not have
 * it. We generally use xstrudp and xmalloc.
 */

char* 
xstrdup(s) 
    char *s;
{
    return strcpy(xmalloc(strlen(s)+1), s);
}

/* 
 * Find a file searching in some likely places. Return the
 * absolute filename or NULL if not found.
 */

char * 
findfile(name)
    char *name;
{
    char *tmp;

    /* substitue ~ - we do it by hand to avoid the need for an interpreter */

    if (name[0] == '~') {

	if ((name[1] == '/') || (name[1] == '\0')) {
	    tmp = getenv("HOME");
	    if (tmp == NULL) return (char *) NULL;
	    strcpy (buffer, tmp);
	    strcat (buffer, name);
	    if (access(buffer, R_OK) == 0) {
		return buffer;
	    } else {
		return (char *) NULL;
	    }
	} else {
	    struct passwd *pwPtr;
	    for (tmp = &name[1]; (*tmp != 0) && (*tmp != '/'); tmp++);
	    strncpy (buffer, name+1, tmp - (name+1));
	    buffer[tmp - (name+1)] = '\0';
	    pwPtr = getpwnam (buffer);
	    if (pwPtr == NULL) {
		endpwent();
		return (char *) NULL;
	    } else {
		strcpy (buffer, pwPtr->pw_dir);
		strcat (buffer, tmp);
		endpwent();
		return buffer;
	    }
	}
    }

    if (access(name, R_OK) == 0) return name;

    strcpy (buffer, "Bitmaps/");
    strcat (buffer, name);
    if (access(buffer, R_OK) == 0) return buffer;

    if ((tmp = getenv("TKINEDLIB")) != NULL) {
      strcpy (buffer, tmp);
      strcat (buffer, "/");
      strcat (buffer, name);
      if (access(buffer, R_OK) == 0) return buffer;
    }

    if ((tmp = getenv("HOME")) != NULL) {
      strcpy (buffer, tmp);
      strcat (buffer, "/.tkined/");
      strcat (buffer, name);
      if (access(buffer, R_OK) == 0) return buffer;
    }

    strcpy (buffer, TKINEDLIB);
    strcat (buffer, "/");
    strcat (buffer, name);
    if (access(buffer, R_OK) == 0) return buffer;

    return (char *) NULL;
}

/*
 * Convert a type id to the appropriate string.
 */

char* 
type_to_string (type)
    int type;
{
    char *result;

    switch (type) {
        case TKINED_NODE:        result = "NODE"; break;
	case TKINED_GROUP:       result = "GROUP"; break;
	case TKINED_NETWORK:     result = "NETWORK"; break;
	case TKINED_LINK:        result = "LINK"; break;
	case TKINED_TEXT:        result = "TEXT"; break;
	case TKINED_IMAGE:       result = "IMAGE"; break;
	case TKINED_INTERPRETER: result = "INTERPRETER"; break;
	case TKINED_TOOL:        result = "TOOL"; break;
	case TKINED_LOG:         result = "LOG"; break;
	default:                 result = "";
    }

    return result;
}

int 
string_to_type (str)
    char *str;
{
    int type = TKINED_NONE;

    if (str != NULL) {
	if (strcmp(str, "NODE") == 0)             type = TKINED_NODE;
	else if (strcmp(str, "GROUP") == 0)       type = TKINED_GROUP;
	else if (strcmp(str, "NETWORK") == 0)     type = TKINED_NETWORK;
	else if (strcmp(str, "LINK") == 0)        type = TKINED_LINK;
	else if (strcmp(str, "TEXT") == 0)        type = TKINED_TEXT;
	else if (strcmp(str, "IMAGE") == 0)       type = TKINED_IMAGE;
	else if (strcmp(str, "INTERPRETER") == 0) type = TKINED_INTERPRETER;
	else if (strcmp(str, "TOOL") == 0)        type = TKINED_TOOL;
	else if (strcmp(str, "LOG") == 0)         type = TKINED_LOG;
    }

    return type;
}

