#! /usr/local/bin/wish -f 

canvas .c -width 100 -height 100
pack .c

.c create rectangle 25 25 75 75 -stipple gray50 -fill black -tags panner

# bind .c <1> "mark_panner %W %x %y"
# bind .c <B1-Motion> "move_panner %W %x %y"

.c bind panner <1>                "mark_panner %W %x %y any"
.c bind panner <Shift-1>          "mark_panner %W %x %y constr"
.c bind panner <B1-Motion>        "move_panner %W %x %y any"
.c bind panner <Shift-B1-Motion>  "move_panner %W %x %y constr"
.c bind panner <ButtonRelease-1>  "release_panner %W %x %y any"
.c bind panner <Shift-ButtonRelease-1>  "release_panner %W %x %y constr"

bind .c <1> "daneben %W %x %y"
bind .c <ButtonRelease-1> "release_panner %W %x %y foo"

proc daneben {c x y} {
    set co [$c coords panner]
    if {$x < [lindex $co 0]} { 
	$c move panner -5 0
	return
    }
    if {$x > [lindex $co 2]} { 
	$c move panner  5 0 
	return
    }
    if {$y < [lindex $co 1]} { 
	$c move panner 0 -5
        return
    }
    if {$y > [lindex $co 3]} { 
	$c move panner 0  5
        return
    }
}

proc mark_panner {c x y type} {
    global panner_x
    global panner_y
    global panner_type

    set panner_x $x
    set panner_y $y
}

proc move_panner {c x y type} {

    global panner_x
    global panner_y
    global panner_const_x

    set dx [expr {-($panner_x-$x)}]
    set dy [expr {-($panner_y-$y)}]

    if {$type == "constr"} {
	
	if {![info exists panner_const_x]} {
	    set panner_const_x [expr {(abs($dx) > abs($dy))}]
	}

	set dx [expr {$panner_const_x ? $dx :   0}]
	set dy [expr {$panner_const_x ? 0   : $dy}]
    }

    $c move panner $dx $dy

    set panner_x $x
    set panner_y $y
}

proc release_panner {c x y type} {
    
    global panner_const_x

    catch {unset panner_const_x}

    puts "now at $x $y"
}

