/* 
 * This contains the common deklarations for "tkined".
 *
 * Copyright (c) 1993, 1994
 *                    J. Schoenwaelder
 *                    TU Braunschweig, Germany
 *                    Institute for Operating Systems and Computer Networks
 *
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <tk.h>
#include <tkInt.h>
#include <tkCanvas.h>

#define TKINED_VERSION "0.7"

/*
 * The external declaration of the canvas extensions stripchart 
 * and barchart. The definition of Tk_CreateItemType belongs to
 * tkCanvas.h, but it is missing (at least in tk3.6).
 */

extern void Tk_CreateItemType _ANSI_ARGS_((Tk_ItemType *typePtr));

extern Tk_ItemType TkStripchartType;
extern Tk_ItemType TkBarchartType;

/*
 * The following structure is used to represent objects. I decided
 * to uses a flat structure since most tkined objects are very similar.
 */

typedef struct {
    unsigned type;      /* Type of the object. See below for object types    */
    char *id;           /* The unique identifier for this object             */
    char *name;         /* The name of the object (if any)                   */
    char *address;      /* The address of the object (if any)                */
    unsigned oid;       /* The external object identifier (if any)           */
    double x,y;         /* The position of the object (if any)               */
    char *icon;         /* The icon of the object (if any)                   */
    char *font;         /* The font of the object (if any)                   */
    char *color;        /* The color of the object (if any)                  */
    char *label;        /* The label of the object (if any)                  */
    char *text;         /* The text of a label or a text object              */
    char *canvas;       /* The widget name of the canvas we belong to        */
    char *items;        /* The item on the canvas that belong to this object */
    char *parent;       /* The parent group id of an object                  */
    char *size;         /* The size occupied by an object                    */
    char *member;       /* The elements of a group object                    */
    char *links;        /* The list of links of the object (if any)          */
    char *ida;          /* The first object connected by a link object       */
    char *idb;          /* The second object connected by a link object      */
    int queue;          /* The queue as reported by the interpreter          */
    int xv[2];          /* Socket pair of interpreter objects                */
    int pid;            /* The pid of this process                           */
    Tcl_DString buffer; /* The Command Buffer used by an interpreter         */
    int done:1;         /* Flag indicating if the Buffer is empty            */
    int trace:1;        /* Flag indicating if the interpreter needs a trace  */
    int selected:1;     /* Not zero if object currently selected             */
    int collapsed:1;    /* Not zero if group object currently collapsed      */
    int stripchart:1;   /* Not zero if node object shown as stripchart       */
    int barchart:1;     /* Not zero if node object shown as barchart         */
} tkined_object;

/*
 * Legal values for the type field of a TKINED_object. See tkined.1
 * for more details on tkined objects.
 */

#define TKINED_NONE         0
#define TKINED_ALL          1
#define TKINED_NODE         2
#define TKINED_GROUP        3
#define TKINED_NETWORK      4
#define TKINED_LINK         5
#define TKINED_TEXT         6
#define TKINED_IMAGE        7
#define TKINED_INTERPRETER  8
#define TKINED_TOOL         9
#define TKINED_LOG         10

/*
 * Declaration of all functions that implement methods for tkined
 * objects. See the dispatch table for more information about which
 * method can be executed for a given object type.
 */

int m_node_create      _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_group_create     _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_network_create   _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_link_create      _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_text_create      _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_image_create     _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_interpreter_create _ANSI_ARGS_((Tcl_Interp* interp, 
				      tkined_object *object,
				    int argc, char** argv));
int m_tool_create      _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_log_create       _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));

int m_node_retrieve    _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_group_retrieve   _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_network_retrieve _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_link_retrieve    _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_text_retrieve    _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_image_retrieve   _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_interpreter_retrieve _ANSI_ARGS_((Tcl_Interp* interp, 
					tkined_object *object,
					int argc, char** argv));
int m_tool_retrieve    _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_log_retrieve     _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));

int m_type             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_id               _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_name             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_canvas           _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_items            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_address          _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_oid              _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_select           _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_unselect         _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_selected         _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_icon             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
		 		    int argc, char** argv));
int m_label            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_font             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_color            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_move             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_link_move        _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_group_move       _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_raise            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_lower            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_size             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));

int m_node_dump        _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_group_dump       _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_network_dump     _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_link_dump        _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_text_dump        _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_image_dump       _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));

int m_ida              _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_idb              _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_text             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_append           _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_clear            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_stripchart       _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_barchart         _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_member           _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_collapse         _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_expand           _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_collapsed        _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_links            _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_network_labelxy  _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_interpreter      _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_send             _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));

int m_linked_delete    _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_link_delete      _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_group_delete     _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));
int m_interpreter_delete _ANSI_ARGS_((Tcl_Interp* interp, 
				      tkined_object *object,
				      int argc, char** argv));
int m_delete           _ANSI_ARGS_((Tcl_Interp* interp, tkined_object *object,
				    int argc, char** argv));

/*
 * More utility functions.
 */

extern void receive           _ANSI_ARGS_((ClientData clientData, int mask));
extern void trace             _ANSI_ARGS_((char *result, char *cmd));

extern int Tkined_Init        _ANSI_ARGS_((Tcl_Interp* interp));
extern char* findfile         _ANSI_ARGS_((char* name));
extern char* type_to_string   _ANSI_ARGS_((int type));
extern int string_to_type     _ANSI_ARGS_((char* str));

/*
 * Our hashtable that maps object ids to the object structure.
 */

extern Tcl_HashTable ht_object;
extern tkined_object* id_to_object _ANSI_ARGS_((char *str));

/*
 * This variable gives the number of registered trace callbacks.
 */

extern int traceNum;

/*
 * This variable shows if we run in debug mode. It corresponds to
 * the tcl variable tkined_debug which contains a boolean to
 * indicate debug mode.
 */

extern int debug;

/*
 * Copy a string from b to a. This macro makes sure that
 * the copy operation is only done when a and b are not
 * the same string.
 */

#define STRCOPY(A,B) if (A != B) { free (A); A = xstrdup(B); }

/*
 * Here comes some portability stuff. There is not strdup in
 * ultrix C library. So here we fake one. And we like to use
 * a somewhat fail-safe version.
 */

extern char* xstrdup _ANSI_ARGS_((char*));
extern char* xmalloc _ANSI_ARGS_((unsigned));

#ifdef NCCICON
extern void ncc_bitmap _ANSI_ARGS_((Tcl_Interp * interp));
#endif

