##
## tkined_graph.tcl
##
## This file contains some graphic subroutines to display status
## information. It currently contains a simple stripchart
## and a barchart representation.
##
## Copyright (c) 1993, 1994
##                    J. Schoenwaelder
##                    TU Braunschweig, Germany
##                    Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##


##
## Exchange the bitmap with a stripchart that can show some nice
## status information. This is just a hack. It will get cleaned up
## if it proves to be too fat to be written in tcl.
##

proc tkined_stripchart_create {id} {
    set c [$id canvas]
    set type [$id type]
    foreach item [$id items] {
	set tags [$c gettags $item]
	if {[lsearch $tags $type]>=0} {
	    $c delete $item
	    break
	}
    }
    set color [option get $c background tkined]
    if {$color==""} { set color white }
    set strip [$c create stripchart -31 -21 31 21 \
	       -outline black -background $color \
		   -tags [list $type "stripchart" "id $id"]]
    eval $c move $strip [$id move]
    $id items "[$id items] $strip"
}

proc tkined_stripchart_delete {id} {
    eval [$id canvas] delete [$id items]
    $id items ""
    $id canvas [$id canvas]
    $id icon  [$id icon]
    $id color [$id color]
    $id label [$id label]
}

proc tkined_stripchart_values {id args} {
    set c [$id canvas]
    set position [$id move]
    set args [join $args]
    set value [lindex $args 0]

    if {$c == ""} return
    foreach item [$id items] {
	if {[lsearch [$c gettags $item] "stripchart"]>=0} {
	    eval $c coords $item -31 -21 31 21 $value
	    eval $c move $item $position
	    break
	}
    }
}


##
## Exchange the bitmap with a barchart that can show some nice
## status information. This is just a hack. It will get cleaned up
## if it proves to be too fat to be written in tcl.
##

proc tkined_barchart_create {id} {
    set c [$id canvas]
    set type [$id type]
    foreach item [$id items] {
	set tags [$c gettags $item]
	if {[lsearch $tags $type] >= 0} {
	    $c delete $item
	    break
	}
    }    
    set color [option get $c background tkined]
    if {$color==""} { set color white }
    if {[tk colormodel .]=="color"} {
	set bar [$c create barchart -31 -21 31 21 -autocolor on \
		 -background $color -tags [list $type "barchart" "id $id"]]
    } else {
	set bar [$c create barchart -31 -21 31 21 -autocolor off \
		 -background $color -tags [list $type "barchart" "id $id"]]
    }
    eval $c move $bar [$id move]
    $id items "[$id items] $bar"
}

proc tkined_barchart_delete {id} {
    eval [$id canvas] delete [$id items]
    $id items ""
    $id canvas [$id canvas]
    $id icon  [$id icon]
    $id color [$id color]
    $id label [$id label]
}

proc tkined_barchart_values {id args} {
    set c [$id canvas]
    set position [$id move]
    set args [join $args]

    if {$c == ""} return
    foreach item [$id items] {
	if {[lsearch [$c gettags $item] "barchart"]>=0} {
	    eval $c coords $item -31 -21 31 21 $args
	    eval $c move $item $position
	    break
	}
    }
}




