##
## tkined_help.tcl
##
## This file contains the help commands of the ined editor.
##
## Copyright (c) 1993, 1994
##                    J. Schoenwaelder
##                    TU Braunschweig, Germany
##                    Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##

proc tkined_help_general {w} {
    tkined_acknowledge $w.canvas \
	"This is the tk version of INED -- an interactive network editor." \
	"" \
	"This version has been written based on the original INED version" \
	"that was build on top of the Unidraw/Interviews framework. Many" \
	"thanks to the developers of the original version, Thomas Birke" \
	"and Hinnerk Ruemenapf."\
	"" \
	"Also many thanks to Guntram Hueske (hueske@ibr.cs.tu-bs.de) who" \
	"wrote the stripchart and barchart code in C to make them faster." \
	"The simple job scheduler found in ined.tcl has been written by" \
	"StefanSchoek Schoek (schoek@ibr.cs.tu-bs.de). It is used by" \
	"monitoring scripts to handle multiple jobs in one interpreter." \
	"" \
	"Also many thanks to Erik Schoenfelder for his support and ideas" \
	"that improved tkined (and scotty) a lot." \
	"" \
	"There is a mailing list you might join to report bugs or suggestions"\
	"or to get the latest news about tkined. To join, send a message to:" \
	"" \
	"          tkined-request@ibr.cs.tu-bs.de" \
	"" \
	"Juergen Schoenwaelder (schoenw@ibr.cs.tu-bs.de)"
}

proc tkined_help_status {w} {
    global tkined_version
    global tkined_debug
    global tkined_path
    global auto_path

    set text ""
    set total 0
    set cmds [info commands]

    foreach id [tkined_retrieve] {
	set type [$id type]
	if {![info exists count($type)]} { set count($type) 0}
	incr count($type)
	incr total
    }
    if {[info exists count]} {
        foreach t [array names count] {
	    append text "\n# of $t objects: $count($t)"
        }
    }
    if {$tkined_debug} {
	append text "\n\ndebugging mode is switched on.\n"
	append text "\ntkined_path: $tkined_path"
	append text "\nauto_path: $auto_path"
    }
    tkined_acknowledge $w.canvas \
	"tkined version $tkined_version status information" \
	"" \
	"file: [tkined_editor_attribute $w filename]" \
	"directory: [tkined_editor_attribute $w dirname]" \
	"" \
	"total # of open views: [llength [winfo children .]]" \
	"total # of objects: $total" \
	$text
}

proc tkined_help_key_bindings {w} {
    tkined_browse $w.canvas \
	"Inside of the canvas, the following key bindings apply:" { 
	"middle mouse button : move selected objects"  
	"shift middle mouse button : move the whole canvas"  
	"right mouse button : select objects (deletes current selection)"  
	"shift right mouse button : add objects to the current selection"  
	""  
	"The following tool specific bindings apply exist:"  
	""  
	"Select"  
	""  
	"left mouse button : select nearest object (deletes current selection)"  
	"shift left mouse button : add nearest object to the current selection"  
	""  
	"Move"  
	""  
	"left mouse button : move selected objects"  
	""  
	"Text"  
	""  
	"left mouse button : place the input cursor on the canvas"  
	""  
	"Label"  
	""  
	"left mouse button : popup a menu to select the label type"  
	"left mouse button : put the input cursor in the label area"  
	""  
	"Node"  
	""  
	"left mouse button : put a new node object on the canvas"  
	""  
	"Network"  
	""  
	"left mouse button : define startpoint and endpoint of a network object"  
	"shift left mouse button : mark intermediate points of a network object"  
	""  
	"Link"  
	""  
	"left mouse button : define startpoint and endpoint of a link object"  
	"shift left mouse button : mark intermediate points of a link object"  
	""  
	"Group"  
	""  
	"left mouse button : put a new group object on the canvas"
    }
}
