#==============================================================================
#                                 Config.mk
#------------------------------------------------------------------------------
# Configuration file for Tcl sipp.  Edit the following variables to specify
# the location of required packages and other attribbutes.   
#
# IMPORTANT NOTE:
#     All paths to include files must include the -I options.  All paths 
# should either be absoulte or relative to the src directory below the
# directory containing this file.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# C compiler, ar and lex commands to use.
#
CC=cc
AR=ar
LEX=lex

#------------------------------------------------------------------------------
# Compiler options (-g, -O).  Be sure and set set STRIP=touch below if
# -g is used.
#
#CCOPT=-g
CCOPT=-O

#------------------------------------------------------------------------------
# If your system requires the use or ranlib set RANLIB to "ranlib", otherwise
# set it to "touch".
#
#RANLIB=ranlib
RANLIB=touch

#------------------------------------------------------------------------------
# Stripping - Set to the command `strip' to strip, `touch' to not strip.
#
#STRIP=touch
STRIP=strip

#------------------------------------------------------------------------------
# Other libraries that might be needed (-lm almost always is).
#
LDFLAGS=-lm -lmalloc -lPW -lc_s

#------------------------------------------------------------------------------
# If you don't have memcpy() and friends in your C library, or 
# if you don't have memory.h in /usr/include, uncomment the
# following line:
#NOMEMCPY = -DNOMEMCPY

#------------------------------------------------------------------------------
# If you don't have alloca(), specify -DHAVE_NO_ALLOCA.  If you have alloca(),
# but don't have alloca.h, specify -DHAVE_NO_ALLOCA_H
# (NOTE: Sun users MUST include alloca.h!!!!)
#
#ALLOCA = -DHAVE_NO_ALLOCA
ALLOCA = -DHAVE_NO_ALLOCA_H

#------------------------------------------------------------------------------
# Location of your standard include files.  This is needed because the Tcl
# source directory has its own copy of files like string.h.
#
STDINCL=-I/usr/include

#------------------------------------------------------------------------------
# Location of your Tcl include files (tcl.h and tclInt.h).
#
TCLINCL=-I/u/markd/tcl/new/tcl6.5

#------------------------------------------------------------------------------
# Location of your Extended Tcl (TclX) include file (tclExtend.h) and the path
# to your Extended Tcl library (libtcl.a - includes Tcl library).
#
TCLXINCL=-I/u/markd/tcl/new/extended/src
TCLXLIB=/u/markd/tcl/new/extended/libtcl.a

#------------------------------------------------------------------------------
# Location of Utah Raster Toolkit (URT) include files and library.  If you
# do not have the URT, don't define URTINCL and URTLIB, instead define URTDEF
# as -DTSIPP_NO_RLE
#
#URTDEF=-DTSIPP_NO_RLE
URTINCL=-I/u/markd/graphics/include
URTLIB=/u/markd/graphics/lib/librle.a

#------------------------------------------------------------------------------
# Options indicating if a version of the Tk shell, wish, is to be build.  You
# must have compiled Extended Tcl with the TCL_TK_SHELL option set in its
# configuration file.  Remove comments from  TK_SIPP_SHELL and TK_SIPP_OBJS to
# compile the Tcl-SIPP commands into the library and generate a Tk shell with
# these commands and the photo widget.
#
# TKINCL is the location of your Tk include files. TKLIB is the Tk library
# which was built with Extended Tcl.  XLIBS are the X11 libraries to link with.
# 
TK_SIPP_SHELL=tksipp
TKINCL=-I/u/markd/tcl/new/tk3.0
TKLIB=/u/markd/tcl/new/extended/libtk.a
XLIBS=-lX11_s -lsocket

#------------------------------------------------------------------------------
# Arguments to use in when generating the demo pictures.  The following
# arguments may be specified for this flag:
#
#     o -mode rmode - The rendering mode.  The value of rmode is one of PHONG,
#        GOURAUD, FLAT or LINE.  Default is PHONG.
#     o -oversample factor - The oversampling factor.  The default is 2 for
#        most images, a couple are 3.  You might want to set this to 1 to speed
#        up the rendering.
#     o -size isize - The size of the image to render.  The result will be an
#        image isize X isize pixels.  The default is 256 pixels.
#     o -ppm - Force PPM (or PBM for LINE mode) format images to be rendered.
#        The default is to render RLE images if Tcl-SIPP was built with the 
#        Utah Raster Toolkit RLE library and a PPM images if RLE is not
#        available.
#        
DEMOARGS=
