#==============================================================================
#                                conetest.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program conetest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: conetest.tcl,v 3.0 1993/01/20 06:39:56 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {source util.tcl}
ParseArgs

set RESOLUTION 20

SippLightSourceCreate { 1.0  1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION

#
# light salmon
#
set shader [SippShaderBasic 0.5 0.6 0.2 {1.0000 0.6275 0.4784}]

#
# The ordinary cone
#
set cone [SippCone 1.0 0.0 4.0 $RESOLUTION $shader WORLD]

SippObjectMove $cone {-3.0 0.0 0.0}
SippObjectAddSubobj WORLD $cone

#
# The truncated cone
#
set trunc_cone [SippCone 1.0 0.4 5.0 $RESOLUTION $shader WORLD]
SippObjectMove $trunc_cone {3.0 0.0 0.0}
SippObjectAddSubobj WORLD $trunc_cone

#
# The cylinder (a trucated cone with equal top and bottom radii
#
set cylinder [SippCylinder 1.0 3.0 $RESOLUTION $shader WORLD]
SippObjectAddSubobj WORLD $cylinder

SippCameraParams STDCAMERA {5.0 -10.0 6.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.4

DoRendering "cone"
