#==============================================================================
#                               ellipsoid.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program ellipsoid.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: ellipsoid.tcl,v 3.0 1993/01/20 06:40:04 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {source util.tcl}
ParseArgs

set RESOLUTION 15

SippLightSourceCreate { 1.0  1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION

set shader [SippShaderBasic 0.5 0.6 0.2 {0.6 0.3 0.5}]
    
SippObjectAddSubobj WORLD [SippEllipsoid {1.0 2.0 3.0} $RESOLUTION $shader \
                                         WORLD]

SippCameraParams STDCAMERA {10.0 0.0 0.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.4

DoRendering "ellipsoid"
