#==============================================================================
#                               prismtest.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program prismtest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: prismtest.tcl,v 3.0 1993/01/20 06:40:13 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {source util.tcl}
ParseArgs

#
# Note, there appear to be missing commas in the declarations of these arrays
# in the SIPP demo, the values are been adjusted here so that the resulting
# pictures are the same.
#

# The XY coordinats for a 3-sided prism.

set prism3 {{ 0.0  0.0}
            {-1.0  2.0} 
            {-2.0 -1.0}}

# The XY coordinats for a 5-sided prism.

set prism5 {{-0.5  0.0}
            {-1.0  0.5} 
            { 1.0  1.0} 
            {-1.0  2.0} 
            {-2.0  0.5}}

SippLightSourceCreate { 1.0  1.0  1.0} {0.9  0.9  0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0  0.5} {0.4  0.4  0.4} DIRECTION

# light salmon

set shader [SippShaderBasic 0.5 0.6 0.2 {1.0000 0.6275 0.4784}]

# The 3-sided prism.

set prism3_obj [SippPrism $prism3 4.0 $shader WORLD]
SippObjectMove $prism3_obj {-3.0 0.0 0.0}
SippObjectAddSubobj WORLD $prism3_obj

# The 5-sided prism

set prism5_obj [SippPrism $prism5 5.0 $shader WORLD]
SippObjectMove $prism5_obj {3.0 0.0 0.0}
SippObjectAddSubobj WORLD $prism5_obj

# The block (a 4 sided prism)

SippObjectAddSubobj WORLD [SippBlock {1.0 2.0 3.0} $shader WORLD]

SippCameraParams STDCAMERA {5.0 -10.0 6.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.4

DoRendering "prism"
 
