#==============================================================================
#                               torustest.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program torustest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: torustest.tcl,v 3.0 1993/01/20 06:40:19 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {source util.tcl}
ParseArgs

set SMALLRES 15
set BIGRES   40


SippLightSourceCreate { 1.0  1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION

set shader [SippShaderBasic 0.5 0.6 0.2 {0.6 0.3 0.5}]

SippObjectAddSubobj WORLD [SippTorus 1.0 0.4 $BIGRES $SMALLRES $shader WORLD]

SippCameraParams STDCAMERA {4.0 0.0 4.5}  {0.5 0.0 0.0} {0.0 0.0 1.0} 0.4

DoRendering "torus"
