#==============================================================================
#                                   vw.tcl
#------------------------------------------------------------------------------
# Generate a demo picture of the Evans & Sutherland VW.
#------------------------------------------------------------------------------
# $Id: vw.tcl,v 3.0 1993/01/20 06:40:24 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {source util.tcl}
ParseArgs

loadlibindex ../tclsrc/tsipp.tlib

set shader [SippShaderBasic 0.4 0.8 0.1 {0.1 0.3 0.8}]

set vw [SippVW $shader]
SippObjectRotateX $vw D-90
SippObjectRotateY $vw D-90
SippObjectMove $vw {0 -20 0}
SippObjectAddSubobj WORLD $vw

SippLightSourceCreate {1.0 1.0 1.0} {1.0 1.0 1.0} DIRECTION

set camera [SippCameraCreate {-200.0 150.0 140.0} {0.0 0.0 0.0} {0.0 1.0 0.0}]
SippCameraUse $camera

DoRendering "vw"

