/*
 * photo.h --
 *	Definitions for clients of the photo widget
 *
 * Copyright 1992 The Australian National University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, provided that the above copyright
 * notice appears in all copies.  This software is provided without any
 * warranty, express or implied. The Australian National University
 * makes no representations about the suitability of this software for
 * any purpose.
 *
 * Author: Paul Mackerras (paulus@cs.anu.edu.au)
 *
 * SCCS info: @(#)photo.h	1.2	last modified: 5/5/92
 */

typedef void *PhotoHandle;

typedef struct image_block {
    unsigned char *ptr;		/* points to image data */
    int		width;		/* horiz # pixels in block */
    int		height;		/* vert # pixels in block */
    int		pitch;		/* # bytes stored per line */
    int		pixel_size;	/* # bytes per pixel */
    int		comp_off[3];	/* address offset to R,G,B components */
} PhotoImage;

PhotoHandle FindPhoto(/*char *window_path*/);

void PhotoPutBlock(/*PhotoHandle handle, PhotoImage *block,
		     int dest_x, int dest_y,
		     int dest_width, int dest_height*/);

void PhotoBlank(/*PhotoHandle handle*/);

void PhotoExpand(/*PhotoHandle handle, int width, int height */);

void PhotoGetSize(/*PhotoHandle handle, int *widthp, int *heightp*/);

void PhotoSetSize(/*PhotoHandle handle, int width, int height*/);
