/*
 *=============================================================================
 *                                tSippTk.c
 *-----------------------------------------------------------------------------
 * Tcl-SIPP Tk utilities.
 *-----------------------------------------------------------------------------
 * Copyright 1992-1993 Mark Diekhans
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Mark Diekhans makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tSippTk.c,v 3.0 1993/01/20 06:43:56 markd Rel $
 *=============================================================================
 */

#include "tSippInt.h"

extern int
Tk_PhotoCmd _ANSI_ARGS_((ClientData   clientData,
                         Tcl_Interp  *interp,
                         int          argc,
                         char       **argv));


/*=============================================================================
 * TkSippUpdate -- 
 *   Allow Tk to handle pending events, also checks for signals.
 *
 * Parameters:
 *   o tSippGlobPtr (I) - A pointer to the Tcl SIPP global structure.
 *-----------------------------------------------------------------------------
 */
void
TkSippUpdate (tSippGlobPtr)
    tSippGlob_pt  tSippGlobPtr;
{
    static char *argv [2] = {"update", NULL};

    if (tclReceivedSignal) {
        if (Tcl_CheckForSignal (tSippGlobPtr->interp, TCL_OK) != TCL_OK)
            Tk_BackgroundError (tSippGlobPtr->interp);
        Tcl_ResetResult (tSippGlobPtr->interp);
    }
    Tk_UpdateCmd (tSippGlobPtr->tkMainWindow, tSippGlobPtr->interp,
                  1, argv);

}

/*=============================================================================
 * TkSippInitialize -- 
 *   Initialize the Tcl/Sipp environment including Tk commands.  This is called
 * in place of TSippInitialize in a Tk application.
 *
 * Parameters:
 *   o interp (I) - Pointer to the Tcl interpreter.
 * Returns:
 *   A generic pointer to the tSipp globals.  Used to cleanup.
 *-----------------------------------------------------------------------------
 */
void *
TkSippInitialize (interp, mainWindow)
    Tcl_Interp *interp;
    void_pt     mainWindow;
{
    tSippGlob_pt tSippGlobPtr;

    tSippGlobPtr = TSippInitialize (interp);

    tSippGlobPtr->tkMainWindow = mainWindow;
    tSippGlobPtr->updateProc   = TkSippUpdate;

    TSippPhotoInit (tSippGlobPtr);

    Tcl_CreateCommand (interp, "photo", Tk_PhotoCmd,
                       (ClientData) mainWindow, (void (*)()) NULL);

    return tSippGlobPtr;
}
