#==============================================================================
#                                  util.tcl
#------------------------------------------------------------------------------
# Utility procs for Tcl-SIPP.
#------------------------------------------------------------------------------
# Copyright 1992-1993 Mark Diekhans
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Mark Diekhans makes
# no representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.
#------------------------------------------------------------------------------
# $Id: util.tcl,v 3.0 1993/01/20 06:39:53 markd Rel $
#==============================================================================

#@package: TSIPP-UTIL SippReset

#
# Reset Tcl-SIPP, releasing all resources that we can and setting the global
# state to the initial defaults.
#
proc SippReset {} {
    SippPolygonClear
    SippSurfaceUnref ALL
    SippShaderUnref ALL
    SippObjectUnref ALL
    SippObjectSubSubobj WORLD ALL
    SippLightDestruct ALL
    SippCameraDestruct ALL
    SippCameraParams STDCAMERA {0 0 10} {0 0 0} {0 1 0} 0.25
    SippBackground {0 0 0}
    SippLineColor {1 1 1}
    SippShowBackFaces 0
    SippShadows 0
    SippObjectClearTransf WORLD
}
