#==============================================================================
#                                   vw.tcl
#------------------------------------------------------------------------------
# Utility proc used by all VW surface creation routines.  Proc to create
# a VW object.  Also VW package definition, all other VW files must follow this
# one
#------------------------------------------------------------------------------
# $Id: vw.tcl,v 3.0 1993/01/20 06:39:32 markd Rel $
#==============================================================================

#@package: TSIPP-VW SippVW SippVWBackFender SippVWBack SippVWBackSide SippVWFrontDoor SippVWFrontFender SippVWFrontSide SippVWHood SippVWFrontPanel SippVWRunningBoard SippVWRoof

#
# Define a VW polygon.  Side is either LEFT or RIGHT, pointTblVar is the
# name of the vertex table.  Points is a list of indices into the vertex
# table.
#
proc SippVW:DefPoly {side pointTblVar points} {
    upvar $pointTblVar pointTbl

    case $side {
      {LEFT} {
        foreach pnt $points {
            lappend vertList $pointTbl($pnt)
        }
        SippPolygonPush $vertList
      }
      {RIGHT} {
        foreach pnt $points {
            set leftPnt $pointTbl($pnt)
            set x [expr -1*[lindex $leftPnt 0]]
            lappend vertList [lreplace $leftPnt 0 0 $x]
        }
        SippPolygonPush -clock $vertList
      }
      default {
        error "expected one of \"LEFT\" or \"RIGHT\", got \"$side\""
      }
    }
}

#
# Define an the VW as an object.
#
proc SippVW {shader} {
    set obj [SippObjectCreate]
    SippObjectAddSurface $obj [SippVWBackFender   LEFT  $shader]
    SippObjectAddSurface $obj [SippVWBackFender   RIGHT $shader]
    SippObjectAddSurface $obj [SippVWBack         LEFT  $shader]
    SippObjectAddSurface $obj [SippVWBack         RIGHT $shader]
    SippObjectAddSurface $obj [SippVWBackSide     LEFT  $shader]
    SippObjectAddSurface $obj [SippVWBackSide     RIGHT $shader]
    SippObjectAddSurface $obj [SippVWFrontDoor    LEFT  $shader]
    SippObjectAddSurface $obj [SippVWFrontDoor    RIGHT $shader]
    SippObjectAddSurface $obj [SippVWFrontFender  LEFT  $shader]
    SippObjectAddSurface $obj [SippVWFrontFender  RIGHT $shader]
    SippObjectAddSurface $obj [SippVWFrontSide    LEFT  $shader]
    SippObjectAddSurface $obj [SippVWFrontSide    RIGHT $shader]
    SippObjectAddSurface $obj [SippVWHood         LEFT  $shader]
    SippObjectAddSurface $obj [SippVWHood         RIGHT $shader]
    SippObjectAddSurface $obj [SippVWFrontPanel   LEFT  $shader]
    SippObjectAddSurface $obj [SippVWFrontPanel   RIGHT $shader]
    SippObjectAddSurface $obj [SippVWRunningBoard LEFT  $shader]
    SippObjectAddSurface $obj [SippVWRunningBoard RIGHT $shader]
    SippObjectAddSurface $obj [SippVWRoof         LEFT  $shader]
    SippObjectAddSurface $obj [SippVWRoof         RIGHT $shader]
    return $obj
}
