#==============================================================================
#                                  vwpl.tcl
#------------------------------------------------------------------------------
# Defines the VW front (below windshield) panel surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwpl.tcl,v 3.0 1993/01/20 06:39:46 markd Rel $
#==============================================================================

proc SippVWFrontPanel {side shader} {

    set pnt(1)  { 0.000 -24.370  40.750}
    set pnt(2)  { 0.000 -25.250  40.250}
    set pnt(3)  { 4.000 -25.500  40.000}
    set pnt(4)  { 3.860 -24.370  40.630}
    set pnt(5)  { 0.000 -27.370  40.630}
    set pnt(6)  { 4.500 -27.250  40.370}
    set pnt(7)  { 0.000 -28.750  40.630}
    set pnt(8)  { 4.500 -28.500  40.370}
    set pnt(9)  {10.250 -24.400  40.120}
    set pnt(10) {10.250 -25.250  40.250}
    set pnt(11) {10.250 -26.740  39.870}
    set pnt(12) {10.250 -27.630  39.870}
    set pnt(13) {20.000 -23.750  39.000}
    set pnt(14) {20.000 -25.000  38.500}
    set pnt(15) {19.750 -26.000  38.370}
    set pnt(16) {21.500 -23.370  40.000}
    set pnt(17) {22.250 -24.500  38.750}
    set pnt(18) {22.250 -26.000  37.500}
    set pnt(19) {23.000 -28.500  36.500}
    set pnt(20) {23.750 -24.500  35.500}
    set pnt(21) {23.500 -23.500  37.670}
    set pnt(22) {22.670 -23.130  39.670}
    set pnt(23) {23.500 -22.500  39.500}
    set pnt(24) {20.750 -21.000  45.375}
    set pnt(25) {22.300 -20.000  44.620}
    set pnt(26) {22.810 -20.125  44.200}
    set pnt(27) {20.250 -20.800  44.750}

    SippVW:DefPoly $side pnt {1  2  3  4}
    SippVW:DefPoly $side pnt {2  5  6  3}
    SippVW:DefPoly $side pnt {5  7  8  6}
    SippVW:DefPoly $side pnt {9  4  3 10}
    SippVW:DefPoly $side pnt {10  3  6 11}
    SippVW:DefPoly $side pnt {11  6  8 12}
    SippVW:DefPoly $side pnt {13  9 10 14}
    SippVW:DefPoly $side pnt {14 10 11}
    SippVW:DefPoly $side pnt {14 11 12 15}
    SippVW:DefPoly $side pnt {16 13 14 17}
    SippVW:DefPoly $side pnt {14 15 18 17}
    SippVW:DefPoly $side pnt {17 18 21}
    SippVW:DefPoly $side pnt {21 18 19 20}
    SippVW:DefPoly $side pnt {16 17 22}
    SippVW:DefPoly $side pnt {22 17 21 23}
    SippVW:DefPoly $side pnt {24 16 22}
    SippVW:DefPoly $side pnt {24 22 23 25}
    SippVW:DefPoly $side pnt {24 27 16}
    SippVW:DefPoly $side pnt {25 23 26}

    SippSurfaceCreate $shader
}
