#==============================================================================
#                                  vwrb.tcl
#------------------------------------------------------------------------------
# Defines the VW running board surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwrb.tcl,v 3.0 1993/01/20 06:39:47 markd Rel $
#==============================================================================

proc SippVWRunningBoard {side shader} {

    set pnt(1)  {26.750    27.000  11.500}
    set pnt(2)  {27.000    12.500  11.500}
    set pnt(3)  {26.750     0.750  11.500}
    set pnt(4)  {26.250   -5.7500  11.500}
    set pnt(5)  {25.500   -12.250  11.500}
    set pnt(6)  {25.000   -18.250  11.500}
    set pnt(7)  {24.250   -24.500  11.500}
    set pnt(8)  {24.375   -26.125  10.750}
    set pnt(9)  {26.875   -26.625  10.750}
    set pnt(10) {27.500   -27.000  10.250}
    set pnt(11) {28.250   -27.750   8.750}
    set pnt(12) {28.750    28.250   8.500}
    set pnt(13) {28.250    27.500  11.000}

    SippVW:DefPoly $side pnt {12 10 11}
    SippVW:DefPoly $side pnt {10 12 13}
    SippVW:DefPoly $side pnt {9 10 13}
    SippVW:DefPoly $side pnt {1  2 13}
    SippVW:DefPoly $side pnt {13  2  9}
    SippVW:DefPoly $side pnt {2  3  9}
    SippVW:DefPoly $side pnt {3  4  9}
    SippVW:DefPoly $side pnt {4  5  9}
    SippVW:DefPoly $side pnt {5  6  9}
    SippVW:DefPoly $side pnt {6  7  8  9}

    SippSurfaceCreate $shader
}
