/* 
 * main.c --
 *
 * Modified version of TclX main.c that initializes the Tcl-SIPP commands.
 *-----------------------------------------------------------------------------
 * $Id: main.c,v 3.0 1993/01/20 06:43:23 markd Rel $
 *-----------------------------------------------------------------------------
 * Main to run the Tcl shell.  This file is a useful template for custom
 * applications that wish to have Tcl as the top level command language.
 *-----------------------------------------------------------------------------
 * Copyright 1992-1993 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#include "tSippInt.h"

int
main (argc, argv)
    int     argc;
    char  **argv;
{
    Tcl_Interp *interp;
    void       *tSippGlobPtr;

    /*
     * If history is to be used, then set the eval procedure pointer that
     * Tcl_CommandLoop so that history will be recorded.  This reference
     * also brings in history from libtcl.a.
     */
#ifndef TCL_NOHISTORY
     tclShellCmdEvalProc = Tcl_RecordAndEval;
#endif

    /* 
     * Create a Tcl interpreter for the session, with all extended commands
     * initialized.  This can be replaced with Tcl_CreateInterp followed
     * by a subset of the extended command initializaton procedures if 
     * desired.
     */
    interp = Tcl_CreateExtendedInterp();

    /*
     * Initialize SIPP and the Tcl-SIPP commands.
     */
    tSippGlobPtr = TSippInitialize (interp);

    /*
     * Load the tcl startup code, this should pull in all of the tcl
     * procs, paths, command line processing, autoloads, packages, etc.
     * If Tcl was invoked interactively, Tcl_Startup will give it
     * a command loop.
     */

    Tcl_Startup (interp, argc, argv, NULL, 0);

    /* 
     * Delete the interpreter (not neccessary under Unix, but we do
     * it if TSIPP_MEM_CLEANUP is set to detect memory problems).
     */

#ifdef TSIPP_MEM_CLEANUP
    TSippCleanUp (tSippGlobPtr);
    Tcl_DeleteInterp(interp);
#endif

    exit(0);
}

