#==============================================================================
#                                  vwff.tcl
#------------------------------------------------------------------------------
# Defines the VW front fender surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwff.tcl,v 3.0 1993/01/20 06:39:41 markd Rel $
#==============================================================================

proc SippVWFrontFender {side shader} {

    set pnt(1)   {12.000  -70.500   12.000}
    set pnt(2)   {21.000  -69.500   12.375}
    set pnt(3)   {25.250  -68.500   13.500}
    set pnt(4)   {27.500  -66.000   14.500}
    set pnt(5)   {12.000  -68.600   18.000}
    set pnt(6)   {21.000  -68.100   18.750}
    set pnt(7)   {24.750  -67.400   19.375}
    set pnt(8)   {26.500  -67.100   18.500}
    set pnt(9)   {28.500  -65.500   15.750}
    set pnt(10)  {29.000  -64.500   16.500}
    set pnt(11)  {18.500  -68.300   18.750}
    set pnt(12)  {16.250  -66.800   21.000}
    set pnt(13)  {16.000  -65.700   22.875}
    set pnt(14)  {16.000  -65.000   25.000}
    set pnt(15)  {12.250  -66.500   21.250}
    set pnt(16)  {14.750  -64.700   24.375}
    set pnt(17)  {16.750  -65.500   26.875}
    set pnt(18)  {18.500  -65.100   28.000}
    set pnt(19)  {20.500  -64.800   28.375}
    set pnt(20)  {22.500  -64.900   28.125}
    set pnt(21)  {24.000  -65.000   26.750}
    set pnt(22)  {25.250  -65.250   24.875}
    set pnt(23)  {25.500  -65.500   22.750}
    set pnt(24)  {24.750  -66.400   20.875}
    set pnt(25)  {23.250  -67.000   19.500}
    set pnt(26)  {20.750  -67.400   19.000}
    set pnt(27)  {18.500  -67.200   19.500}
    set pnt(28)  {16.500  -67.000   21.000}
    set pnt(29)  {13.750  -68.500   18.250}
    set pnt(30)  {14.000  -68.100   19.000}
    set pnt(31)  {14.500  -67.900   19.125}
    set pnt(32)  {15.250  -67.900   19.250}
    set pnt(33)  {16.000  -68.000   19.125}
    set pnt(34)  {16.750  -68.200   19.000}
    set pnt(35)  {17.250  -68.800   18.250}
    set pnt(36)  {17.000  -69.300   17.500}
    set pnt(37)  {16.250  -69.000   17.375}
    set pnt(38)  {15.500  -69.300   17.000}
    set pnt(39)  {14.750  -69.100   17.375}
    set pnt(40)  {14.000  -68.800   17.500}
    set pnt(41)  {23.000  -66.600   19.625}
    set pnt(42)  {20.500  -66.500   19.000}
    set pnt(43)  {18.750  -66.300   19.500}
    set pnt(44)  {17.250  -66.500   21.000}
    set pnt(45)  {20.250  -64.900   28.250}
    set pnt(46)  {22.250  -64.900   27.750}
    set pnt(47)  {24.000  -65.300   26.750}
    set pnt(48)  {24.875  -65.500   25.000}
    set pnt(49)  {25.125  -65.750   23.000}
    set pnt(50)  {24.500  -66.000   21.375}
    set pnt(51)  {23.000  -66.300   19.875}
    set pnt(52)  {20.500  -66.250   19.125}
    set pnt(53)  {18.750  -66.000   19.750}
    set pnt(54)  {17.250  -66.500   20.875}
    set pnt(55)  {16.000  -65.700   23.000}
    set pnt(56)  {16.625  -65.000   25.000}
    set pnt(57)  {17.250  -66.700   26.500}
    set pnt(58)  {18.500  -65.400   27.750}
    set pnt(59)  {20.500  -67.300   27.750}
    set pnt(60)  {22.000  -66.700   27.250}
    set pnt(61)  {23.250  -66.750   26.500}
    set pnt(62)  {24.250  -66.800   24.875}
    set pnt(63)  {24.500  -66.700   22.875}
    set pnt(64)  {24.000  -67.300   21.250}
    set pnt(65)  {23.000  -67.000   20.000}
    set pnt(66)  {20.750  -67.300   19.000}
    set pnt(67)  {19.000  -67.000   20.000}
    set pnt(68)  {17.500  -67.300   21.375}
    set pnt(69)  {17.000  -66.700   23.375}
    set pnt(70)  {16.875  -66.800   25.000}
    set pnt(71)  {17.500  -66.250   26.500}
    set pnt(72)  {18.750  -66.700   27.500}
    set pnt(73)  {14.500  -63.250   25.750}
    set pnt(74)  {16.250  -62.500   27.500}
    set pnt(75)  {17.750  -62.250   29.000}
    set pnt(76)  {20.250  -62.125   29.500}
    set pnt(77)  {22.750  -62.125   29.000}
    set pnt(78)  {26.000  -62.400   27.625}
    set pnt(79)  {26.250  -63.250   25.750}
    set pnt(80)  {27.250  -64.125   23.000}
    set pnt(81)  {27.500  -65.250   20.125}
    set pnt(82)  {29.500  -63.000   18.250}
    set pnt(83)  {30.000  -60.500   21.500}
    set pnt(84)  {15.500  -60.300   28.500}
    set pnt(85)  {16.500  -58.500   30.000}
    set pnt(86)  {18.000  -58.750   30.250}
    set pnt(87)  {20.250  -58.750   30.625}
    set pnt(88)  {23.375  -58.750   30.375}
    set pnt(89)  {26.000  -59.250   28.750}
    set pnt(90)  {27.750  -59.500   27.250}
    set pnt(91)  {29.125  -59.750   25.375}
    set pnt(92)  {30.125  -59.000   23.625}
    set pnt(93)  {17.250  -56.000   30.625}
    set pnt(94)  {18.250  -56.000   30.750}
    set pnt(95)  {23.500  -56.000   30.750}
    set pnt(96)  {25.875  -55.750   29.750}
    set pnt(97)  {28.500  -55.250   28.375}
    set pnt(98)  {29.875  -55.000   27.000}
    set pnt(99)  {30.000  -54.750   25.625}
    set pnt(100) {17.875  -53.500   31.375}
    set pnt(101) {23.125  -53.500   31.375}
    set pnt(102) {25.875  -53.625   30.750}
    set pnt(103) {28.250  -53.500   29.500}
    set pnt(104) {29.750  -53.375   28.000}
    set pnt(105) {29.875  -53.250   26.500}
    set pnt(106) {19.750  -48.500   31.875}
    set pnt(107) {20.500  -48.500   31.750}
    set pnt(108) {22.500  -48.375   31.625}
    set pnt(109) {25.625  -48.250   30.875}
    set pnt(110) {28.125  -48.125   30.000}
    set pnt(111) {29.500  -48.000   28.625}
    set pnt(112) {29.250  -47.875   27.125}
    set pnt(113) {21.250  -43.250   31.375}
    set pnt(114) {24.625  -43.250   30.750}
    set pnt(115) {26.500  -43.250   30.125}
    set pnt(116) {28.375  -43.250   29.125}
    set pnt(117) {29.875  -43.500   28.000}
    set pnt(118) {30.000  -43.750   26.375}
    set pnt(119) {22.500  -38.750   29.375}
    set pnt(120) {26.125  -38.750   28.625}
    set pnt(121) {28.250  -39.000   27.500}
    set pnt(132) {29.000  -39.500   26.000}
    set pnt(133) {30.000  -40.500   24.500}
    set pnt(134) {23.500  -34.625   26.250}
    set pnt(135) {25.875  -34.500   25.625}
    set pnt(136) {28.000  -35.000   24.250}
    set pnt(137) {29.250  -36.260   23.250}
    set pnt(138) {30.000  -37.500   21.750}
    set pnt(139) {24.125  -30.750   22.250}
    set pnt(140) {26.375  -30.750   21.625}
    set pnt(141) {28.250  -32.000   20.500}
    set pnt(142) {29.000  -33.500   19.500}
    set pnt(143) {29.500  -35.500   18.000}
    set pnt(144) {24.500  -28.250   17.375}
    set pnt(145) {26.625  -28.625   17.250}
    set pnt(146) {28.000  -30.000   16.750}
    set pnt(147) {29.750  -31.750   15.750}
    set pnt(148) {30.250  -34.250   14.000}
    set pnt(149) {24.750  -26.750   12.750}
    set pnt(150) {26.500  -27.250   13.125}
    set pnt(151) {28.250  -28.500   13.000}
    set pnt(152) {29.250  -30.500   12.000}
    set pnt(153) {29.500  -34.000   10.500}
    set pnt(154) {24.375  -26.125   10.750}
    set pnt(155) {26.875  -26.625   10.750}
    set pnt(156) {27.500  -27.000   10.250}
    set pnt(157) {28.750  -28.000   10.250}
    set pnt(158) {28.250  -27.750   8.750}
    set pnt(159) {29.750  -32.000   9.000}
    set pnt(160) {20.500  -56.500   31.000}
    set pnt(161) {19.125  -56.125   31.000}
    set pnt(162) {19.000  -53.750   31.500}
    set pnt(163) {20.125  -50.500   31.500}
    set pnt(164) {20.750  -50.125   31.500}
    set pnt(165) {21.375  -50.500   31.625}
    set pnt(166) {22.375  -52.500   31.375}
    set pnt(167) {22.750  -54.750   30.875}
    set pnt(168) {21.750  -55.500   30.750}
    set pnt(169) {19.125  -54.750   32.750}
    set pnt(170) {21.750  -54.750   32.750}
    set pnt(171) {20.750  -50.750   32.000}
    set pnt(172) {20.500  -67.500   23.000}
    set pnt(173) {19.000  -55.000   31.250}
    set pnt(174) { 8.250  -71.000   15.750}
    set pnt(175) { 5.000  -71.500   12.500}

    SippVW:DefPoly $side pnt {1  12  15}
    SippVW:DefPoly $side pnt {1   2   6  11}
    SippVW:DefPoly $side pnt {1  11  12}
    SippVW:DefPoly $side pnt {2   3   8 6}
    SippVW:DefPoly $side pnt {3   4   9 8}
    SippVW:DefPoly $side pnt {8   9  10}
    SippVW:DefPoly $side pnt {8  10  81}
    SippVW:DefPoly $side pnt {81  10  82}
    SippVW:DefPoly $side pnt {81  82  80}
    SippVW:DefPoly $side pnt {80  83  91}
    SippVW:DefPoly $side pnt {80  82  83}
    SippVW:DefPoly $side pnt {83  92  91}
    SippVW:DefPoly $side pnt {79  80  91}
    SippVW:DefPoly $side pnt {79  91  90}
    SippVW:DefPoly $side pnt {78  79  90}
    SippVW:DefPoly $side pnt {78  90  89}
    SippVW:DefPoly $side pnt {77  78  89  88}
    SippVW:DefPoly $side pnt {76  77  88  87}
    SippVW:DefPoly $side pnt {75  76  87  86}
    SippVW:DefPoly $side pnt {84  74  75  86 85}
    SippVW:DefPoly $side pnt {73  74  84}
    SippVW:DefPoly $side pnt {15  12  13}
    SippVW:DefPoly $side pnt {12  11  27  28}
    SippVW:DefPoly $side pnt {13  12  28  44}
    SippVW:DefPoly $side pnt {28  27  43  44}
    SippVW:DefPoly $side pnt {44  43  53  54}
#   SippVW:DefPoly $side pnt {44  54  55  13}  ;#Zero length normal???
    SippVW:DefPoly $side pnt {11   6  26  27}
    SippVW:DefPoly $side pnt {26  42  43  27}
    SippVW:DefPoly $side pnt {42  52  53  43}
    SippVW:DefPoly $side pnt {6   8   7}
    SippVW:DefPoly $side pnt {7   8  24}
    SippVW:DefPoly $side pnt {6   7  25  26}
    SippVW:DefPoly $side pnt {26  25  41  42}
    SippVW:DefPoly $side pnt {42  41  51  52}
    SippVW:DefPoly $side pnt {7  24  25}
    SippVW:DefPoly $side pnt {25  24  41}
    SippVW:DefPoly $side pnt {41  24  50  51}
    SippVW:DefPoly $side pnt {8  81  23  24}
    SippVW:DefPoly $side pnt {24  23  49  50}
    SippVW:DefPoly $side pnt {22  23  81  80 79}
    SippVW:DefPoly $side pnt {48  49  23  22}
    SippVW:DefPoly $side pnt {21  22  79  78}
    SippVW:DefPoly $side pnt {48  22  21  47}
    SippVW:DefPoly $side pnt {47  21  20  46}
    SippVW:DefPoly $side pnt {20  21  78  77}
    SippVW:DefPoly $side pnt {19  20  77  76}
    SippVW:DefPoly $side pnt {45  46  20  19}
    SippVW:DefPoly $side pnt {18  19  76  75}
    SippVW:DefPoly $side pnt {58  45  19  18}
    SippVW:DefPoly $side pnt {57  58  18  17}
    SippVW:DefPoly $side pnt {18  75  74  17}
    SippVW:DefPoly $side pnt {17  74  73  14}
    SippVW:DefPoly $side pnt {56  57  17  14}
    SippVW:DefPoly $side pnt {16  14  73}
    SippVW:DefPoly $side pnt {14  13  55  56}
    SippVW:DefPoly $side pnt {16  13  14}
    SippVW:DefPoly $side pnt {15  13  16  73}
    SippVW:DefPoly $side pnt {91  92  99}
    SippVW:DefPoly $side pnt {91  99  98}
    SippVW:DefPoly $side pnt {90  91  98}
    SippVW:DefPoly $side pnt {90  98  97}
    SippVW:DefPoly $side pnt {89  90  97  96}
    SippVW:DefPoly $side pnt {98  99 105 104}
    SippVW:DefPoly $side pnt {97  98 104 103}
    SippVW:DefPoly $side pnt {96  97 103 102}
    SippVW:DefPoly $side pnt {88  89  96  95}
    SippVW:DefPoly $side pnt {87  88  95 168 160}
    SippVW:DefPoly $side pnt {86  87 160 161 94}
    SippVW:DefPoly $side pnt {100  93  94 173}
    SippVW:DefPoly $side pnt {100 170 162}
    SippVW:DefPoly $side pnt {85  86  94  93}
    SippVW:DefPoly $side pnt {94 161 173}
    SippVW:DefPoly $side pnt {100 162 163 106}
    SippVW:DefPoly $side pnt {163 164 107 106}
    SippVW:DefPoly $side pnt {168  95 101 166 167}
    SippVW:DefPoly $side pnt {95  96 102 101}
    SippVW:DefPoly $side pnt {166 101 108 107 164 165}
    SippVW:DefPoly $side pnt {101 102 109 108}
    SippVW:DefPoly $side pnt {102 103 110 109}
    SippVW:DefPoly $side pnt {103 104 111 110}
    SippVW:DefPoly $side pnt {104 105 112 111}
    SippVW:DefPoly $side pnt {106 107 113}
    SippVW:DefPoly $side pnt {107 108 113}
    SippVW:DefPoly $side pnt {109 114 113 108}
    SippVW:DefPoly $side pnt {109 110 115 114}
    SippVW:DefPoly $side pnt {110 111 116 115}
    SippVW:DefPoly $side pnt {111 117 116}
    SippVW:DefPoly $side pnt {111 112 118 117}
    SippVW:DefPoly $side pnt {113 114 119}
    SippVW:DefPoly $side pnt {114 115 120 119}
    SippVW:DefPoly $side pnt {115 116 121 120}
    SippVW:DefPoly $side pnt {117 132 121 116}
    SippVW:DefPoly $side pnt {117 118 133 132}
    SippVW:DefPoly $side pnt {119 120 134}
    SippVW:DefPoly $side pnt {120 135 134}
    SippVW:DefPoly $side pnt {120 121 136 135}
    SippVW:DefPoly $side pnt {121 132 137 136}
    SippVW:DefPoly $side pnt {132 133 138 137}
    SippVW:DefPoly $side pnt {134 135 140 139}
    SippVW:DefPoly $side pnt {135 136 141 140}
    SippVW:DefPoly $side pnt {136 137 142 141}
    SippVW:DefPoly $side pnt {137 138 143 142}
    SippVW:DefPoly $side pnt {139 140 145 144}
    SippVW:DefPoly $side pnt {140 141 146 145}
    SippVW:DefPoly $side pnt {141 142 147 146}
    SippVW:DefPoly $side pnt {142 143 148 147}
    SippVW:DefPoly $side pnt {144 145 150 149}
    SippVW:DefPoly $side pnt {145 146 151 150}
    SippVW:DefPoly $side pnt {146 147 152 151}
    SippVW:DefPoly $side pnt {147 148 153 152}
    SippVW:DefPoly $side pnt {149 150 155 154}
    SippVW:DefPoly $side pnt {150 151 156 155}
    SippVW:DefPoly $side pnt {156 157 158}
    SippVW:DefPoly $side pnt {151 152 157 156}
    SippVW:DefPoly $side pnt {152 153 159 158 157}
    SippVW:DefPoly $side pnt {45  59  60  46}
    SippVW:DefPoly $side pnt {46  60  61  47}
    SippVW:DefPoly $side pnt {47  61  62  48}
    SippVW:DefPoly $side pnt {48  62  63  49}
    SippVW:DefPoly $side pnt {49  63  64  50}
    SippVW:DefPoly $side pnt {50  64  65  51}
    SippVW:DefPoly $side pnt {51  65  66  52}
    SippVW:DefPoly $side pnt {52  66  67  53}
    SippVW:DefPoly $side pnt {53  67  68  54}
    SippVW:DefPoly $side pnt {54  68  69  55}
    SippVW:DefPoly $side pnt {55  69  70  56}
    SippVW:DefPoly $side pnt {56  70  71  57}
    SippVW:DefPoly $side pnt {57  71  72  58}
    SippVW:DefPoly $side pnt {58  72  59  45}
    SippVW:DefPoly $side pnt {168 170 169 161 160}
    SippVW:DefPoly $side pnt {168 167 170}
    SippVW:DefPoly $side pnt {170 167 171}
    SippVW:DefPoly $side pnt {171 167 166 165}
    SippVW:DefPoly $side pnt {171 165 164}
    SippVW:DefPoly $side pnt {173 161 169}
    SippVW:DefPoly $side pnt {173 169 171 162}
    SippVW:DefPoly $side pnt {162 171 164 163}
    SippVW:DefPoly $side pnt {169 170 171}
    SippVW:DefPoly $side pnt {1  15 174}
    SippVW:DefPoly $side pnt {1 174 175}

    SippSurfaceCreate $shader
}
