#==============================================================================
#                                  vwrf.tcl
#------------------------------------------------------------------------------
# Defines the VW roof surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwrf.tcl,v 3.0 1993/01/20 06:39:49 markd Rel $
#==============================================================================

proc SippVWRoof {side shader} {

    set pnt(1)  {22.350    0.000   52.750}
    set pnt(2)  {22.300    0.000   52.800}
    set pnt(3)  {21.700    0.000   52.900}
    set pnt(4)  {20.500    0.000   54.750}
    set pnt(5)  {19.375    0.000   55.625}
    set pnt(6)  {19.250    0.000   55.750}
    set pnt(7)  {13.000    0.000   58.250}
    set pnt(8)  { 0.000    0.000   59.000}
    set pnt(9)  {22.750   13.500   52.900}
    set pnt(10) {22.800   13.500   53.400}
    set pnt(11) {22.700   13.500   52.950}
    set pnt(12) {22.200   13.500   53.000}
    set pnt(13) {20.750   13.500   54.500}
    set pnt(14) {19.625   13.500   55.250}
    set pnt(15) {19.500   13.500   55.375}
    set pnt(16) {13.000   13.500   58.500}
    set pnt(17) { 0.000   13.500   59.375}
    set pnt(18) {22.625   25.750   51.500}
    set pnt(19) {22.550   25.750   51.550}
    set pnt(20) {20.125   25.750   53.625}
    set pnt(21) {19.000   25.750   54.250}
    set pnt(22) {13.000   25.750   57.375}
    set pnt(23) { 0.000   25.750   58.500}
    set pnt(24) {22.550   36.500   48.500}
    set pnt(25) {20.375   36.500   50.875}
    set pnt(26) {19.250   36.500   51.500}
    set pnt(27) {12.000   36.500   54.625}
    set pnt(28) { 0.000   36.500   55.625}
    set pnt(29) {22.300   45.500   42.800}
    set pnt(30) {19.875   46.375   45.875}
    set pnt(31) {18.750   46.750   46.750}
    set pnt(32) {17.000   46.875   48.000}
    set pnt(33) {16.375   47.000   47.750}
    set pnt(34) {15.750   45.375   49.250}
    set pnt(35) {15.500   46.000   48.875}
    set pnt(36) {11.000   44.750   51.250}
    set pnt(37) {11.000   45.375   51.000}
    set pnt(38) { 0.000   44.750   52.000}
    set pnt(39) { 0.000   45.375   51.375}
    set pnt(40) {22.050   49.750   40.000}
    set pnt(41) {18.750   50.250   41.250}
    set pnt(42) {17.375   50.750   41.750}
    set pnt(43) {16.625   51.000   42.250}
    set pnt(44) {16.000   51.500   41.375}
    set pnt(45) {16.000   53.625   39.125}
    set pnt(46) {15.500   53.000   39.625}
    set pnt(47) {18.500   57.600   33.200}
    set pnt(48) {17.000   58.000   34.000}
    set pnt(49) {19.600   58.000   30.800}
    set pnt(50) {12.000   60.000   36.500}
    set pnt(51) { 6.300   60.500   37.700}
    set pnt(52) { 0.000   60.700   38.000}
    set pnt(53) {13.750   55.750   39.375}
    set pnt(54) {10.500   56.625   40.125}
    set pnt(55) { 0.000   57.875   40.375}
    set pnt(56) { 0.000   56.875   41.375}
    set pnt(57) {10.500   55.625   40.625}
    set pnt(58) {13.500   54.625   39.750}
    set pnt(59) {22.750   12.000   53.000}
    set pnt(60) {21.250   52.750   37.250}
    set pnt(61) {22.100   -8.500   51.750}
    set pnt(62) {22.050   -8.500   51.800}
    set pnt(63) {21.200   -8.500   53.750}
    set pnt(64) {20.000   -8.500   53.875}
    set pnt(65) {19.875   -8.500   54.000}
    set pnt(66) {12.000   -8.500   56.875}
    set pnt(67) { 0.000   -8.500   57.875}
    set pnt(68) {19.875  -14.250   52.125}
    set pnt(69) {19.875  -14.250   52.125}
    set pnt(70) {20.500  -17.250   50.750}
    set pnt(71) {18.750  -17.750   51.125}
    set pnt(72) {18.250  -17.500   50.000}
    set pnt(73) {16.125  -16.000   52.750}
    set pnt(74) {15.750  -16.125   51.750}
    set pnt(75) {12.000  -16.250   54.750}
    set pnt(76) {12.000  -16.375   53.500}
    set pnt(77) { 0.000  -16.000   55.250}
    set pnt(78) { 0.000  -16.125   54.250}
    set pnt(79) {19.500  -19.375   47.875}
    set pnt(80) {20.000  -19.500   48.250}
    set pnt(81) {21.900  -17.500   47.900}
    set pnt(82) {22.100  -17.100   47.800}
    set pnt(83) {22.810  -20.125   44.200}
    set pnt(84) {22.300  -20.000   44.620}
    set pnt(85) {20.750  -21.000   45.375}
    set pnt(86) {20.250  -20.800   44.750}
    set pnt(87) {21.750  -14.250   50.500}

    SippVW:DefPoly $side pnt {28 23 22 27}
    SippVW:DefPoly $side pnt {23 17 16 22}
    SippVW:DefPoly $side pnt {17  8  7 16}
    SippVW:DefPoly $side pnt {8 67 66 7}
    SippVW:DefPoly $side pnt {26 27 22 21}
    SippVW:DefPoly $side pnt {21 22 16 15}
    SippVW:DefPoly $side pnt {15 16  7 6}
    SippVW:DefPoly $side pnt {55 56 57 54}
    SippVW:DefPoly $side pnt {54 57 58 53}
    SippVW:DefPoly $side pnt {38 28 27 36}
    SippVW:DefPoly $side pnt {36 27 26 34}
    SippVW:DefPoly $side pnt {6  7 66 65}
    SippVW:DefPoly $side pnt {52 55 54 51}
    SippVW:DefPoly $side pnt {51 54 53 50}
    SippVW:DefPoly $side pnt {53 58 46 45}
    SippVW:DefPoly $side pnt {39 38 36 37}
    SippVW:DefPoly $side pnt {37 36 34 35}
    SippVW:DefPoly $side pnt {35 34 32 33}
    SippVW:DefPoly $side pnt {33 32 43 44}
    SippVW:DefPoly $side pnt {44 43 45 46}
    SippVW:DefPoly $side pnt {50 53 45 48}
    SippVW:DefPoly $side pnt {45 43 42 48}
    SippVW:DefPoly $side pnt {43 32 31 42}
    SippVW:DefPoly $side pnt {48 42 41 47}
    SippVW:DefPoly $side pnt {42 31 30 41}
    SippVW:DefPoly $side pnt {31 32 34 26}
    SippVW:DefPoly $side pnt {30 31 26 25}
    SippVW:DefPoly $side pnt {25 26 21 20}
    SippVW:DefPoly $side pnt {20 21 15 13}
    SippVW:DefPoly $side pnt {13 15  6  4}
    SippVW:DefPoly $side pnt {4  6 65 63}
    SippVW:DefPoly $side pnt {47 41 40 60}
    SippVW:DefPoly $side pnt {47 60 49}
    SippVW:DefPoly $side pnt {41 30 29 40}
    SippVW:DefPoly $side pnt {30 25 24}
    SippVW:DefPoly $side pnt {30 24 29}
    SippVW:DefPoly $side pnt {24 25 20 18}
    SippVW:DefPoly $side pnt {18 20 13  9}
    SippVW:DefPoly $side pnt {9 13  4  1}
    SippVW:DefPoly $side pnt {1  4 63 61}
    SippVW:DefPoly $side pnt {67 77 75 66}
    SippVW:DefPoly $side pnt {77 78 76 75}
    SippVW:DefPoly $side pnt {65 66 75 73}
    SippVW:DefPoly $side pnt {75 76 74 73}
    SippVW:DefPoly $side pnt {73 74 72 71}
    SippVW:DefPoly $side pnt {71 72 79 80}
    SippVW:DefPoly $side pnt {80 79 86 85}
    SippVW:DefPoly $side pnt {65 73 71}
    SippVW:DefPoly $side pnt {63 65 71}
    SippVW:DefPoly $side pnt {63 71 70}
    SippVW:DefPoly $side pnt {81 80 85 84}
    SippVW:DefPoly $side pnt {81 84 83 82}
    SippVW:DefPoly $side pnt {61 63 70 87}
    SippVW:DefPoly $side pnt {87 70 81}
    SippVW:DefPoly $side pnt {87 81 82}
    SippVW:DefPoly $side pnt {70 71 80}
    SippVW:DefPoly $side pnt {70 80 81}

    SippSurfaceCreate $shader
}
