# OpenVerse Text Chat Module
# 
# This module contains all the functions needed for the
# text chat window.
#
# Module Name		- Text Chat Module
# Current Revision No.	- 0.3
# Current Maintainter 	- Cruise <cruise@drunkenbastards.org>
# Last update 		- Mon Sep 20 22:07:28 EDT 1999
# Sourced By		- InitMainWindow
#
# Copyright (C) 1999 David Gale <cruise@drunkenbastards.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# Images we will use in this module.
image create photo SCRLK -file "$MV(icondir)/locked.gif"
image create photo SCRULK -file "$MV(icondir)/unlocked.gif"
image create photo LOG -file "$MV(icondir)/log.gif"

#
# Turns the text chat window on or off.
# When turning on, it fills it with the last bunch of lines.
#
proc ToggleText {} {
	global MV

	if $MV(textwindow) {
		destroy .chat
		set MV(textwindow) 0
	} else {
		set MV(textwindow) 1
		toplevel .chat
		wm title .chat "OpenVerse Text Chat"
		wm geometry .chat 589x110
		#wm resizable .chat 0 1

		frame .chat.chat
		frame .chat.bottom -relief sunken -borderwidth 2
		text .chat.chat.text -height 1 -width 0  -relief raised \
			-borderwidth 2 -yscrollcommand ".chat.chat.scrolly set" \
			-spacing1 1 -wrap word
		scrollbar .chat.chat.scrolly -command ".chat.chat.text yview"
		button .chat.bottom.send -text "Send" -command SendFromWindow
		entry .chat.bottom.chat
		if $MV(log) {
			button .chat.bottom.log -image LOG -command LogTog \
				-bg red
		} else {
			button .chat.bottom.log -image LOG -command LogTog \
				-bg white
		}
		if $MV(textwindow.lock) {
			button .chat.bottom.scrlk -image SCRLK -command ToggleChatLock
		} else {
			button .chat.bottom.scrlk -image SCRULK -command ToggleChatLock
		}
		pack .chat.chat -fill both -expand y
		pack .chat.chat.text -side left -fill both -expand y
		pack .chat.chat.scrolly -side left -fill y 
		pack .chat.bottom -fill x -expand n
		pack .chat.bottom.send -side left -expand n
		pack .chat.bottom.chat -side left -fill x -expand y
		pack .chat.bottom.log .chat.bottom.scrlk -side left

		focus .chat.bottom.chat
		bind .chat <Return> SendFromWindow
		bind .chat <Destroy> "set MV(textwindow) 0"
		bind .chat <Pause> "ToggleChatLock"
		bind .chat <Up> "ShowPrev .chat.bottom.chat"
		bind .chat <Down> "ShowNext .chat.bottom.chat"
		set hp [llength $MV(chats)]
		for {set c 0} {$c < $hp} {incr c} {
			.chat.chat.text insert end "[lindex $MV(chats) $c]"
			.chat.chat.text see end
		}
	}
}

proc LogTog {} {
	global MV

	if $MV(log) {
		.chat.bottom.log configure -bg white
		StopLog
	} else {
		.chat.bottom.log configure -bg red
		StartLog
	}
}



#
# Sends text from the chat window.
# TODO: Use a more generic base function for this.
#       make this a wrapper to it.
#
proc SendFromWindow {} {
	global MV
	
	set stuff [.chat.bottom.chat get]
	.chat.bottom.chat delete 0 end
	lappend MV(prev) $stuff
	if {[llength $MV(prev)] > $MV(prevsave)} {
		set MV(prev) [lreplace $MV(prev) 0 0]
	}
	set MV(curprev) -1

        #
        # Process Plugins!
        #
        foreach plugin $MV(plugin.traps.SendText) {
                if ![$MV(plugin.traps.SendText.$plugin) $stuff] {return}
        }
	
	if {[string range $stuff 0 0] == "/"} {
		ProcessCommand $stuff
	} else {
		SendToServer "CHAT $stuff"
	}
}

#
# Toggles the scroll lock on the text chat window
#
proc ToggleChatLock {} {
	global MV

	if $MV(textwindow.lock) {
		set MV(textwindow.lock) 0
		.chat.bottom.scrlk configure -image SCRULK
	} else {
		set MV(textwindow.lock) 1
		.chat.bottom.scrlk configure -image SCRLK
	}
}

proc InsertIntoChat {log what} {
	global MV

	if [winfo exists .chat.chat.text] {
		.chat.chat.text insert end $what
		if !$MV(textwindow.lock) {.chat.chat.text see end}
	}
	if $log {
		lappend MV(chats) "$what"
		if {[llength $MV(chats)] > $MV(chatsave)} {
			set MV(chats) [lreplace $MV(chats) 0 0]
		}
	}
	if {$MV(log)} {
		LogThis "$what"
	}
}
