#!/usr/bin/tclsh
# OpenVerse Server Program
# 
# This is the server code! :)
#
# Module Name		- Server Program
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Command Line
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

global MV
global waiter

set MV(socks) {}
set MV(port) "7000"
set MV(timeout) 120
set app "$argv0"
catch { set app [file readlink $app] }
set MV(homedir) "[file dirname $app]"
set MV(avatars) "$MV(homedir)/images"
set MV(icons) "$MV(homedir)/icons"
set MV(maxheight) "200"
set MV(maxwidth) "320"
set MV(objects) "$MV(homedir)/objects"
set MV(roomdir) "$MV(homedir)/rooms"
set MV(configfile) "$MV(homedir)/$argv"
set MV(roomfile) "hippos.gif"
set MV(sendbuffer) 4096
set MV(exits) {}
set MV(locations) {}
set MV(captains) {}
set MV(maxpushdistance) 100
set MV(maxpushvelocity) 100

if {$argv == ""} {
	puts "Usage: server.tcl <Config File>"
	exit
}
if [file exists $MV(configfile)] {source $MV(configfile)}

set MV(server_socket) [socket -server NewConnect $MV(port)]
puts "(!) -- SOCKET_OPEN $MV(server_socket)"

proc NewConnect {sck address port} {
	global MV
	puts "($sck)<- New Connection! $address:$port"
	fconfigure $sck -blocking 0 -buffering line
	fileevent $sck readable "ReadFrom $sck"
	if {[lsearch $MV(socks) $sck] == -1} {
		lappend MV(socks) $sck
	}
	set MV($sck.name) "*"
	set MV($sck.address) "$address"
	set MV($sck.port) "$port"
	set MV($sck.ping) 0
	set MV($sck.ping_response) [clock seconds]
	set MV($sck.x) -1
	set MV($sck.y) -1
	set MV($sck.avatar) "*connecting*"
	set MV($sck.av_head_x) "-1"
	set MV($sck.av_head_y) "-1"
}

proc SanityCheck {what} {
	if {[string first "../" $what] != -1} { return 0} else { return 1}
}

proc TestNum {what} {
	global MV

	set bad 0
	for {set c 0} {$c < [string length $what] && !$bad} {incr c} {
		switch -exact -- [string range $what $c $c] {
			1 {
			}
			2 {
			}
			3 {
			}
			4 {
			}
			5 {
			}
			6 {
			}
			7 {
			}
			8 {
			}
			9 {
			}
			0 {
			}
			- {
			}
			default {
				set bad 1
			}
		}
	}
	return $bad
}

proc CheckName {name} {
	
	if {[string trim $name] == "" || \
		[string trim $name] == "*" || \
		[string trim $name] == "." || \
		[string range $name 0 0] == "-"} {
		return 0
	} else {return 1}
}
proc ReadFrom {what} {
	global MV
	
	set input ""
	catch {gets $what input}
	if {[eof $what] == 1} {
		if {$MV($what.name) == "*"} {
			DisconnectUser $what 0
		} else {
			DisconnectUser $what 1
		}
		return
	}

	if {$MV($what.name) == "*"} {
		if {[string range $input 0 3] != "AUTH"} {
			if {$input == "USERS"} {
				SendToUser $what "USERS [expr [llength $MV(socks)] -1]"
				DisconnectUser $what 0
			} else {
				SendToUser $what "AUTH REQD"
				DisconnectUser $what 0
			}
		} else {
			set parms [split [string range $input 5 end] " "]
			if {[TestNum [lindex $parms 1]] || \
			  [TestNum [lindex $parms 2]] || \
			  [TestNum [lindex $parms 4]] || \
			  [TestNum [lindex $parms 5]] || \
			  [TestNum [lindex $parms 6]] || \
			  [TestNum [lindex $parms 7]] || \
			  [TestNum [lindex $parms 8]] } {
				SendToUser $what "AUTH FAILED"
				DisconnectUser $what 0
				return
			}
			if {[string length [lindex $parms 1]] > 3 || \
				[string length [lindex $parms 2]] > 3 || \
				[string length [lindex $parms 4]] > 4 || \
				[string length [lindex $parms 5]] > 4 || \
				[string length [lindex $parms 6]] > 6 || \
				[string length [lindex $parms 7]] > 4 || \
				[string length [lindex $parms 8]] > 4 || \
				[lindex $parms 1] < 0 || \
				[lindex $parms 2] < 0 || \
				[lindex $parms 6] < 0} {
				SendToUser $what "AUTH FAILED"
				DisconnectUser $what 0
				return
			}
			set MV($what.downloads) {}
			set MV($what.name) [string range [lindex $parms 0] 0 12]
			set MV($what.x) [lindex $parms 1]
			set MV($what.y) [lindex $parms 2]
			set MV($what.avatar) [lindex $parms 3]
			set MV($what.av_head_x) [lindex $parms 4]
			set MV($what.av_head_y) [lindex $parms 5]
			set MV($what.av_baloon_x) [lindex $parms 7]
			set MV($what.av_baloon_y) [lindex $parms 8]
			
			set size [lindex $parms 6]
			update idletasks
			if ![CheckName $MV($what.name)] {
					SendToUser $what "BADNAME"
					DisconnectUser $what 0
					return
			}
			foreach sckt $MV(socks) {
				if {$MV($sckt.name) == $MV($what.name) && $sckt != $what} {
					SendToUser $what "NAMEINUSE"
					DisconnectUser $what 0
					return
				}
			}
			SendToUser $what "ROOMNAME $MV(roomname)"
			SendToUser $what "ROOM $MV(roomfile) [file size $MV(roomdir)/$MV(roomfile)]"
			if ![file exists $MV(avatars)/$MV($what.avatar)] {
				SendToAllUsers "NEW $MV($what.name) $MV($what.x) $MV($what.y) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
				puts "($what) $MV($what.avatar) does not exist"
				GetBinaryFile $what $MV($what.avatar) $size
			} else {
				if {[file size $MV(avatars)/$MV($what.avatar)] != $size} {
					SendToAllUsers "NEW $MV($what.name) $MV($what.x) $MV($what.y) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
					puts "($what) $MV($what.avatar) $size != [file size $MV(avatars)/$MV($what.avatar)]"
					GetBinaryFile $what $MV($what.avatar) $size
				} else {
					if [CheckGif "$MV(avatars)/$MV($what.avatar)"] {
						SendToAllUsers "NEW $MV($what.name) $MV($what.x) $MV($what.y) $MV($what.avatar) $MV($what.av_head_x) $MV($what.av_head_y) [file size $MV(avatars)/$MV($what.avatar)] $MV($what.av_baloon_x) $MV($what.av_baloon_y)"
					} else {
						SendToAllUsers "NEW $MV($what.name) $MV($what.x) $MV($what.y) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
						SendToUser $what "TOOBIG"
						set MV($what.avatar) "default.gif"
					}
				}
			}
			foreach sckt $MV(socks) {
				if [file exists $MV(avatars)/$MV($sckt.avatar)] {
					SendToUser $what "NEW $MV($sckt.name) $MV($sckt.x) $MV($sckt.y) $MV($sckt.avatar) $MV($sckt.av_head_x) $MV($sckt.av_head_y) [file size $MV(avatars)/$MV($sckt.avatar)] $MV($sckt.av_baloon_x) $MV($sckt.av_baloon_y)"
				} else {
					SendToUser $what "NEW $MV($sckt.name) $MV($sckt.x) $MV($sckt.y) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
				}
			}
			return
		}
	}
	ProcessInput $what $input
}

proc DisconnectUser {who announce} {
	global MV
	
	puts "($who)<- Disconnected! $MV($who.address):$MV($who.port)"
	catch {close $who}
	puts "(!) -- SOCKET_CLOSE $who"
	set which [lsearch -exact $MV(socks) $who]
	if {$which == -1} {return}
	set MV(socks) [lreplace $MV(socks) $which $which]
	if $announce {
		foreach sckt $MV(socks) {
			SendToUser $sckt "NOMORE $MV($who.name)"
		}
	}
}

proc SendToUser {who what} {
	puts "($who)-> $what"
	catch {puts $who "$what"}
	#flush $who
}

proc SendToAllUsers {what} {
	global MV
	
	foreach sckt $MV(socks) {
		if {$MV($sckt.name) != "*"} {
			puts "($sckt)-> $what"
			catch {puts $sckt "$what"}
			#flush $sckt
		}
	}
}

proc ProcessInput {who what} {
	global MV

	puts "($who)<- $what"
	set cmd [string range $what 0 [expr [string first " " $what] -1]]
	set rest [string range $what [expr [string first " " $what] +1] end]
	set parms [split $rest " "]
	if {$cmd == ""} {set cmd $what}
	switch -exact -- $cmd {
		"MOVE" {
				#fixes a bug that MbM found.
			  if {[TestNum [lindex $parms 1]] || \
			  [TestNum [lindex $parms 2]] || \
			  [TestNum [lindex $parms 3]]} {return}
			if {[string length [lindex $parms 1]] > 4} {return}
			if {[string length [lindex $parms 2]] > 4} {return}
			if {[string length [lindex $parms 3]] > 2} {return}
			if {[lindex $parms 1] < 0} {return}
			if {[lindex $parms 2] < 0} {return}
			if {[lindex $parms 3] < 0} {return}
			set MV($who.x) [lindex $parms 1]
			set MV($who.y) [lindex $parms 2]
			set is_exiting 0
			set idx 0
			foreach exit $MV(exits) {
				set exl [split $exit " "]
				set x1 	[lindex $exl 0]
				set y1 	[lindex $exl 1]
				set x2 	[lindex $exl 2]
				set y2 	[lindex $exl 3]
				if {$MV($who.x) > $x1 && \
					$MV($who.x) < $x2 && \
					$MV($who.y) > $y1 && \
					$MV($who.y) < $y2} {
						set is_exiting 1
						set eidx $idx
				}
				incr idx
			}
			if $is_exiting {				
				SendToAllUsers "MOVE $MV($who.name) [lindex $parms 1] [lindex $parms 2] [lindex $parms 3]"
				SendToUser $who "EXIT [lindex $MV(locations) $eidx]"
			} else {
				SendToAllUsers "MOVE $MV($who.name) [lindex $parms 1] [lindex $parms 2] [lindex $parms 3]"
			}
		}
		"OBJECT" {
			if {[lindex $parms 0] == ""} {return}
			switch -- [lindex $parms 0] {
				"CREATE" {
					# x y - Coords for this object. 
					# move style 
					# Stick Type
					# Push effect.
					# Delay between frames.
					# Final delay.
					# image list
				}
			}
		}
		"PUSH" {
			if {[lindex $parms 0] == ""} {return}
			set velocity [lindex $parms 0]
			if {[TestNum $velocity]} {return}
			if { $velocity > $MV(maxpushvelocity)} {set velocity $MV(maxpushvelocity)}
			if { $velocity < 0} {set velocity 1}
			foreach s $MV(socks) {
				if {$who == $s} {continue}
				if {$MV($who.x) >= $MV($s.x)} {
					set xdistance [expr $MV($who.x) - $MV($s.x)]
					set xpush "-"
				} else {
					set xdistance [expr $MV($s.x) - $MV($who.x)]
					set xpush "+"
				}
				if {$MV($who.y) >= $MV($s.y)} {
					set ydistance [expr $MV($who.y) - $MV($s.y)]
					set ypush "-"
				} else {
					set ydistance [expr $MV($s.y) - $MV($who.y)]
					set ypush "+"
				}
				if {$xdistance <= $MV(maxpushdistance) && $ydistance <= $MV(maxpushdistance)} {
					puts "(PUSH) $xdistance $ydistance $xpush $ypush $velocity"
					set MV($s.x) [expr $MV($s.x) $xpush ($velocity - $ydistance)]
					set MV($s.y) [expr $MV($s.y) $ypush ($velocity - $xdistance)]
					if {$MV($s.x) <= 0 } {set MV($s.x) 10}
					if {$MV($s.y) <= 0 } {set MV($s.y) 10}
					if {$MV($s.x) >= 640 } {set MV($s.x) 630}
					if {$MV($s.y) >= 480 } {set MV($s.y) 470}
					set is_exiting 0
					set idx 0
					foreach exit $MV(exits) {
						set exl [split $exit " "]
						set x1 	[lindex $exl 0]
						set y1 	[lindex $exl 1]
						set x2 	[lindex $exl 2]
						set y2 	[lindex $exl 3]
						if {$MV($s.x) > $x1 && \
							$MV($s.x) < $x2 && \
							$MV($s.y) > $y1 && \
							$MV($s.y) < $y2} {
							set is_exiting 1
							set eidx $idx
						}
						incr idx
					}
					if $is_exiting {
						SendToUser $s "PUSH $MV($s.x) $MV($s.y) 20"
						SendToAllUsers "MOVE $MV($s.name) $MV($s.x) $MV($s.y) 20"
						SendToUser $s "EXIT [lindex $MV(locations) $eidx]"
					} else {
						SendToUser $s "PUSH $MV($s.x) $MV($s.y) 20"
						SendToAllUsers "MOVE $MV($s.name) $MV($s.x) $MV($s.y) 20"
					}
				}
			}
		}
		"SEND" {
			if ![SanityCheck [lindex $parms 0]] {return}
			SendBinaryFile $who [lindex $parms 0]
		}
		"DCCSENDAV" {
			if ![SanityCheck [lindex $parms 0]] {return}
			DCCSend $who [lindex $parms 0] AVATAR
		}
		"DCCSENDROOM" {
			if ![SanityCheck [lindex $parms 0]] {return}
			DCCSend $who [lindex $parms 0] ROOM
		}
		"EFFECT" {
			SendToAllUsers "EFFECT $MV($who.name) [lindex $parms 0]"
		}
		"USERS" {
			SendToUser $what "USERS [llength $MV(socks)]"
		}
		"SUB" {
			if {[lindex $parms 0] == ""} {return}
			set stuff [string range $rest [expr [string first " " $rest] +1] end]
			if {[string length $stuff] > 256} {
				set stuff [string range $stuff 0 256]
			}
			foreach s $MV(socks) {
				if {$MV($s.name) == [lindex $parms 0] || [lindex $parms 0] == "*"} {
					SendToUser $s "SUB $MV($who.name) $stuff"
				}
			}
		}
		"URL" {
			if {[lindex $parms 0] == ""} {return}
			set stuff [string range $rest [expr [string first " " $rest] +1] end]
			if {[string length $stuff] > 256} {
				set stuff [string range $stuff 0 256]
			}
			foreach s $MV(socks) {
				if {$MV($s.name) == [lindex $parms 0] || [lindex $parms 0] == "*"} {
					SendToUser $s "URL $MV($who.name) $stuff"
				}
			}
		}
		"PONG" {
			set MV($who.ping_response) [clock seconds]
		}
		"RSEND" {
			if ![SanityCheck [lindex $parms 0]] {return}
			SendRoomFile $who [lindex $parms 0]
		}
		"CHAT" {
			if {$rest != ""} {
				SendToAllUsers "CHAT $MV($who.name) [string range $rest 0 256]"
			}
		}
		"SCHAT" {
			set parms [split $rest " "]
			set rest [string range $rest [expr [string first " " $rest] +1] end]
			if {$rest != ""} {
				SendToAllUsers "SCHAT [lindex $parms 0] $MV($who.name) [string range $rest 0 256]"
			}
		}
		"AVATAR" {
			  if {[TestNum [lindex $parms 1]] || \
			  [TestNum [lindex $parms 2]] || \
			  [TestNum [lindex $parms 3]] || \
			  [TestNum [lindex $parms 4]] || \
			  [TestNum [lindex $parms 5]]} {
				SendToUser $who "BAD AVATAR"
				return
			}
			if {[string length [lindex $parms 1]] > 4} {return}
			if {[string length [lindex $parms 2]] > 4} {return}
			if {[string length [lindex $parms 3]] > 6} {return}
			if {[string length [lindex $parms 4]] > 4} {return}
			if {[string length [lindex $parms 5]] > 4} {return}
			if {[lindex $parms 3] < 0} {return}
			ChangeAvatar $who [lindex $parms 0] [lindex $parms 1] [lindex $parms 2] [lindex $parms 3] [lindex $parms 4] [lindex $parms 5]
		}
		"WHOIS" {
			if {[lindex $parms 0] == ""} {return}
			foreach s $MV(socks) {
				if {$MV($s.name) == [lindex $parms 0] || [lindex $parms 0] == "*"} {
					SendToUser $who "WHOIS $MV($s.name) $MV($s.name)@$MV($s.address)"
				}
			}
		}
		"PRIVMSG" {
			if {[lindex $parms 0] == ""} {return}
			set stuff [string range $rest [expr [string first " " $rest] +1] end]
			if {[string length $stuff] > 256} {
				set stuff [string range $stuff 0 256]
			}
			foreach s $MV(socks) {
				if {$MV($s.name) == [lindex $parms 0] || [lindex $parms 0] == "*"} {
					SendToUser $s "PRIVMSG $MV($who.name) $stuff"
				}
			}
		}
		"NICK" {
			if {$MV($who.name) == [lindex $parms 0] || $MV($who.name) == "*"} {
				return
			}
			if ![CheckName [lindex $parms 0]] {
					SendToUser $who "NAMEINUSE"
					return
			}
			foreach sckt $MV(socks) {
				if {$MV($sckt.name) == [lindex $parms 0]} {
					SendToUser $who "NAMEINUSE"
					DisconnectUser $what 0
					return
				}
			}
			SendToAllUsers "NOMORE $MV($who.name)"
			set MV($who.name) [string range 0 12 [lindex $parms 0]]
			SendToAllUsers "NEW $MV($who.name) $MV($who.x) $MV($who.y) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
 			SendToAllUsers "AVATAR $MV($who.name) $MV($who.avatar) $MV($who.av_head_x) $MV($who.av_head_y) [file size $MV(avatars)/$MV($who.avatar)] $MV($who.av_baloon_x) $MV($who.av_baloon_y)"
		}
	}
}

proc ChangeAvatar {who what x y size bx by} {
	global MV

	set MV($who.avatar) $what
	set MV($who.av_head_x) $x
	set MV($who.av_head_y) $y
	set MV($who.av_baloon_x) $bx
	set MV($who.av_baloon_y) $by
	update idletasks
	if {$what == "default.gif"} {
		SendToAllUsers "AVATAR $MV($who.name) $what $MV($who.av_head_x) $MV($who.av_head_y) [file size $MV(icons)/$what] $bx $by"
		return
	}
	if ![file exists $MV(avatars)/$what] {
		puts "-> $what does not exist"
		GetBinaryFile $who $MV($who.avatar) $size
	} else {
		if {[file size $MV(avatars)/$what] != $size} {
			puts "-> $what $size != [file size $MV(avatars)/$what]"
			GetBinaryFile $who $MV($who.avatar) $size
		} else {
			if [CheckGif "$MV(avatars)/$what"] {
				SendToAllUsers "AVATAR $MV($who.name) $what $MV($who.av_head_x) $MV($who.av_head_y) [file size $MV(avatars)/$what] $bx $by"
			} else {
				SendToAllUsers "AVATAR $MV($who.name) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
				SendToUser $who "TOOBIG"
				set MV($who.avatar) "default.gif"
			}
		}
	}
}

proc CheckTimeouts {} {
	global MV

	catch {
		set tme [clock seconds]
		foreach port $MV(ports) {
			puts "-> Checking TimeOuts ($port)"
			if $MV($port.time) {
				if {[expr $tme - $MV($port.time)] > $MV(timeout)} {
					catch {close $MV($port.server)}
					puts "(!) -- SOCKET_CLOSE $MV($port.server)"
					puts "-> Connection Timed Out $MV($port.file)"
					set idx [lsearch -exact $MV(ports) $port]
					set MV(ports) [lreplace $MV(ports) $idx $idx]
				}
			} else {
				if {[expr $tme - $MV($port.idletime)] > $MV(timeout)} {
					catch {close $MV($port.socket)}
					puts "(!) -- SOCKET_CLOSE $MV($port.socket)"
					puts "-> File Transfer Timed Out $MV($port.file)"
					set idx [lsearch -exact $MV(ports) $port]
					set MV(ports) [lreplace $MV(ports) $idx $idx]
					if {$MV($port.fileopen)} {
						catch {close $MV($port.fd)}
						puts "(!) -- FILE_CLOSE $MV($port.fd)"
						set MV($port.fileopen) 0
					}
					file remove $MV(avatars)/$MV($port.file)
				}
			}
		}
	}
	set disco {}
	foreach who $MV(socks) {
		if {[expr $tme - $MV($who.ping_response)] > 320} {
			puts "($who) - Ping Timeout!"
			lappend disco $who
		} else {
			if {[expr $tme - $MV($who.ping)] > 150} {
				set MV($who.ping) [clock seconds]
				SendToUser $who "PING"
			}
		}
	}
	foreach who $disco {
		DisconnectUser $who 1
	}
	
	# For new download style.
	set tme [clock seconds]
	foreach idx $MV(dcc_list) {
		if {[expr $tme - $MV(DCC.$idx.time)] > $MV(timeout)} {
			if {$MV(DCC.$idx.server) > 0} {
				catch {close $MV(DCC.$idx.server)}
			}
			endDCC Timer $idx 0 "Connection Timed Out $MV(DCC.$idx.file)"
		}
	}
	after 5000 CheckTimeouts
}

#
# Will print out information on errors
# and continue running (we hope)
#
proc bgerror {stuff} {
	global errorInfo
	global errorCode
	
	puts "-------------------------------------"
	puts "BGERROR Begin"
	puts "-------------------------------------"
	puts "Error Code: $stuff"
	puts "-------------------------------------"
	puts $errorInfo
	puts "-------------------------------------"
	puts "BGERROR End"
	puts "-------------------------------------"
}

#--------------------------------------------
# --           NEW DOWNLOAD CODE!          --
#--------------------------------------------
set MV(dcc_list) {}
set MV(dcc_num) 0

#
# This function will check to see if the
# user is already getting the file.
#
proc VerifyAvailable {who what} {
	global MV

	foreach idx $MV(dcc_list) {
		if {$MV(DCC.$idx.sender) == $who && "[file tail $MV(DCC.$idx.file)]" == $what} {
			return 0
		}
	}
	return 1
}

proc DCCSend {who what type} {
	global MV

	if ![VerifyAvailable $who $what] {
		puts "($who) -- Already Getting $what"
		return
	}

	switch -exact -- $type {
		"AVATAR" {
			if {$what == "default.gif"} {
				set file "$MV(icons)/default.gif"
			} else {
				set file "$MV(avatars)/$what"
			}
			set GETCMD "DCCGETAV"
		}
		"ROOM" {
			set file "$MV(roomdir)/$what"
			set GETCMD "DCCGETROOM"
		}
		default {return}
	}

	if {[file exists $file]} {
		if {![file readable $file]} {
            		puts "($who) (DCCSend) Cannot read file $file."
			return
		}

		set size [file size $file]
		set idx [incr MV(dcc_num)]
		set sock [socket -server "acceptSend $idx" 0]

		if {[catch {fconfigure $sock -sockname} port]} {
			puts "($who) (DCCSend) Cannot get port for server - $port"
		}

		lappend MV(dcc_list) $idx
		set MV(DCC.$idx.sender) $who
		set MV(DCC.$idx.file) "$file"
		set MV(DCC.$idx.size) $size
		set MV(DCC.$idx.posn) 0
		set MV(DCC.$idx.time) [clock seconds]
		set MV(DCC.$idx.server) $sock
		set MV(DCC.$idx.sock) -1
		set MV(DCC.$idx.port) [lindex $port 2]

		SendToUser $who "$GETCMD [lindex $port 2] $what $size"
	} else {
		puts "($who) (DCCSend) File $file does not exist."
	}
}

proc acceptSend {index chan hst port} {
	global MV

	catch {close $MV(DCC.$index.server)}
	uplevel set MV(DCC.$index.server) -1
	uplevel #0 set MV(DCC.$index.sock) $chan
	
	if {[ catch {open $MV(DCC.$index.file) RDONLY} infile]} {
		endDCC Send $index 0 "Cannot read $MV(DCC.$index.file) : $infile"
		return 0
	}

	if {[set posn $MV(DCC.$index.posn)] != {} && $posn > 0} {
		if {[catch {seek $infile $posn start} msg]} {
			endDCC Send $index 0 "Cannot seek $MV(DCC.$index.file) : $msg"
			close $infile
			return 0
		}
		uplevel #0 incr MV(DCC.$index.size) -$posn
	} 

	if {$MV(DCC.$index.size) == 0} {
		close $infile
		after 50 "endDCC Send $index 1 \"Transfer completed.\""
		return 1
	}

	set st [clock seconds]
	fconfigure $infile -translation binary

	if {[catch {set buffer [read $infile $MV(sendbuffer)]} msg]} {
		endDCC Send $index 0 "Error reading $file : $msg"
		close $infile
		return 0
	}

	global tl
	set tl($chan) [string length $buffer]
	fconfigure $chan -blocking 0 -buffering none -translation binary
	if {[catch {puts -nonewline $chan $buffer} msg]} {
		endDCC Send $index 0 "Write error : $msg"
		close $infile
		return 0
	}
	puts "($MV(DCC.$index.sender)) -- Accepted DCCSend"
	fileevent $chan readable "dccSendEvent $index $st $infile"
}

proc dccSendEvent {index st fd} {
	global MV
	

	set sk $MV(DCC.$index.sock)
	uplevel #0 set MV(DCC.$index.time) [clock seconds]

	if {[eof $sk]} {
		after 50 "endDCC Send $index 0 \"Transfer interrupted\""
		close $fd
		return
	}

	if {[catch {set l [read $sk 4]} msg]} {
		endDCC Send $index 0 "Read error : $msg"
		close $fd
		return
	}

	if {[string length $l] == 0} {
		endDCC Send $index 0 "Sync read error"
		close $fd
		return
	}

        global tl
	set cl 0
	binary scan $l I1 cl
	if {$cl != $tl($sk)} {return }

	puts "($MV(DCC.$index.sender) Got Check (OK)"
	if [eof $fd] {
		if {[set st [expr {[clock seconds] - $st}]] == 0} {
			    set st 1
		}
		close $fd
		after 50 "endDCC Send $index 1 \"Transfer completed\""
		return
	}

	puts "($MV(DCC.$index.sender) Got Check (OK Not EOF)"

	if {[catch {set buffer [read $fd $MV(sendbuffer)]} msg]} {
		endDCC Send $index 0 "Error reading $MV(DCC.$index.file) : $msg"
		close $fd
		return
	}

	if {[set lng [string length $buffer]] == 0} {
		if {[set st [expr {[clock seconds] - $st}]] == 0} {
			set st 1
		}
		close $fd
		after 50 "endDCC Send $index 1 \"Transfer completed.\""
		return
	}
	incr tl($sk) $lng
	puts "($MV(DCC.$index.sender)) -- Sent $lng bytes ($tl($sk) total)"
	if {[catch {puts -nonewline $sk $buffer} msg]} {
		endDCC Send $index 0 "Write error : $msg"
		close $fd
		return
	}

	if {[set dt [expr {[clock seconds] - $st}]] == 0} {
		set elt 0
	} {
		set elt [expr {($MV(DCC.$index.size) - $tl($sk)) / ($tl($sk) /([clock seconds] - $st))}]
	}
}

# DCC GET CODE (Passive)
#
# This has been styled using DCC code from Zircon an ircII client
# by Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
#
# This is our central location for DOWNLOADING files.
# 
proc GetBinaryFile {who what size} {
	global MV
	
	
	if ![SanityCheck "$what"] {
		puts "(!) $what fails SanityCheck"
		return
	}
	if ![VerifyAvailable $who $what] {
		puts "($who) -- Already GetTing $what from this user"
		return
	}

	set file "$MV(avatars)/$what"	
	
	set idx [incr MV(dcc_num)]
	set sock [socket -server "acceptGet $idx" 0]
	if {[catch {fconfigure $sock -sockname} port]} {
		puts "($who) (DCCSend) Cannot get port for server - $port"
	}
	lappend MV(dcc_list) $idx
	set MV(DCC.$idx.sender) $who
	set MV(DCC.$idx.file) "$file"
	set MV(DCC.$idx.size) $size
	set MV(DCC.$idx.posn) 0
	set MV(DCC.$idx.time) [clock seconds]
	set MV(DCC.$idx.server) $sock
	set MV(DCC.$idx.sock) -1
	set MV(DCC.$idx.port) [lindex $port 2]
	set MV(DCC.$idx.remote) $MV($who.address)
	set MV(DCC.$idx.av_head_x) $MV($who.av_head_x)
	set MV(DCC.$idx.av_head_y) $MV($who.av_head_y)
	set MV(DCC.$idx.av_baloon_x) $MV($who.av_baloon_x)
	set MV(DCC.$idx.av_baloon_y) $MV($who.av_baloon_y)
	SendToUser $who "DCCSENDAV [lindex $port 2] $what"

}	

proc acceptGet {index chan hst port} {
	global MV

	catch {close $MV(DCC.$index.server)}
	uplevel set MV(DCC.$index.server) -1
	uplevel #0 set MV(DCC.$index.sock) $chan

    set file $MV(DCC.$index.file)
    set posn $MV(DCC.$index.posn)
    fconfigure $MV(DCC.$index.sock) -buffering none -blocking 0 -translation binary -buffersize 4096
    set flags [list WRONLY CREAT]
    if {$posn == 0} { lappend flags TRUNC }
    if {![catch {open $file $flags 0600} outfile]} {
	if {$posn != 0} {
	    if {[catch {seek $outfile $posn start} msg]} {
	    	close $outfile
	    	endDCC Get $index 0 "Cannot seek on $file : $msg"
		return 0
	    }
		uplevel #0 incr MV(DCC.$index.size) -$posn
	}
	uplevel #0 set tl($MV(DCC.$index.sock)) 0
	fconfigure $outfile -translation binary 
	fileevent $MV(DCC.$index.sock) readable "dccgevent $index [clock seconds] $outfile"
    } {
	endDCC Get $index 0 "Cannot write $file : $outfile"
        return 0
    }
    return 1
}

proc dccgevent {index st out} {
    global tl MV

    set xc 0

	set in $MV(DCC.$index.sock)
	set leng $MV(DCC.$index.size)
	uplevel #0 set MV(DCC.$index.time) [clock seconds]

	set fail_type 0

    if {[eof $in]} {
        if {$tl($in) < $leng} {
	    set msg "Transfer Interrupted"
		set fail_type 0
        } elseif {$tl($in) > $leng} {
   	    set msg "Too much data transferred!!"
		set fail_type 0
        } else {
    	    set sx s
	    if {[set st [expr {[clock seconds] - $st}]] == 0} {
	        set st 1
	        set sx {}
	    }
	    set xc 1
	    set msg "Transfer completed. [expr {$leng / ($st * 1024.0)}] Kbytes/sec"
		set fail_type 1
        }
    } {
        if {![catch {set buffer [read $in]} msg]} {
            incr tl($in) [set l [string length $buffer]]
		puts "downloaded $l bytes ($tl($in) total)"
            if {[set dt [expr {[clock seconds] - $st}]] == 0 || $tl($in) == 0} {
                set elt 0
            } {
	        set elt [expr {($leng - $tl($in)) / ($tl($in) /([clock seconds] - $st))}]
	    }
	    if {$leng == 0} {
	    	set xt 0
	    } {
	        set xt [expr {($tl($in) * 100.0) / $leng}]
	    }
		
            if {![catch {puts -nonewline $out $buffer} msg]} {
	        if {![catch {puts -nonewline $in [binary format I1 $tl($in)]} msg]} {
	            return
	        }
		flush $in
	    } else {
		set fail_type 0
	    }
	} else {
	   set fail_type 0
	}
    }
    catch {close $out} 
    endDCC Get $index $fail_type $msg
}

proc endDCC {type index fail_type debug} {
        global MV

        if !$fail_type {
                puts "($MV(DCC.$index.sender) (DCC$type) - $debug"
        }
	catch {close $MV(DCC.$index.sock)}
	set idx [lsearch -exact $MV(dcc_list) $index]
	set MV(dcc_list) [lreplace $MV(dcc_list) $idx $idx]
	if {$type == "Get" && $fail_type} {
		if [CheckGif "$MV(DCC.$index.file)"] {
			SendToAllUsers "AVATAR $MV($MV(DCC.$index.sender).name) [file tail $MV(DCC.$index.file)] $MV(DCC.$index.av_head_x) $MV(DCC.$index.av_head_y) $MV(DCC.$index.size) $MV(DCC.$index.av_baloon_x) $MV(DCC.$index.av_baloon_y)"
		} else {
			set MV($MV(DCC.$index.sender).avatar) "default.gif"
			SendToAllUsers "AVATAR $MV($MV(DCC.$index.sender).name) default.gif 0 20 [file size $MV(icons)/default.gif] 24 6"
			SendToUser $MV(DCC.$index.sender) "TOOBIG"
		}
	}
}

#
# This will read in a gif file header and decide
# if it is within bounds. (or even a valid file)
#

proc CheckGif {file} {
	global MV

	set infile [open $file r]
	fconfigure $infile -translation binary
	set bits [read $infile 10]
	close $infile
	if {[string range $bits 0 2] != "GIF"} {
		puts "(CheckGif) FAILED! NOT A GIF"
		return 0
	}
	binary scan $bits s* var
	if {[lindex $var 4] <= $MV(maxheight) && [lindex $var 3] <= $MV(maxwidth)} {
		puts "(CheckGif) PASSED! [lindex $var 3] X [lindex $var 4]"
		return 1
	} else {
		puts "(CheckGif) FAILED! [lindex $var 3] X [lindex $var 4]"
		return 0
	}
}

# --------------------------------------------------------
# --              BEGIN OLD DOWNLOAD CODE               --
# --------------------------------------------------------
#
# This stuff is crap. It was poorly designed and I'm embarased by it.
# it's here for backwards comptability only and will be removed in
# one year from Tue Sep 28 19:12:00 EDT 1999
#

set MV(ports) {}
set MV(downloads) {}

proc SendRoomFile {who what} {
	global MV
	
	set bad 1
	while {$bad == 1} {
		set port [expr int((rand() * 4096)) + 10000]
		if {[lsearch -exact $MV(ports) $port] == -1} {
			lappend MV(ports) $port
			set bad 0
		}
	}
	set MV($port.server) [socket -server "SendRoom $port" $port]
	puts "(!) -- SOCKET_OPEN $MV($port.server)"
	set MV($port.remote) $MV($who.address)
	set MV($port.file) $what
	set MV($port.sckt) $who
	set MV($port.name) $MV($who.name)
	set MV($port.time) [clock seconds]
	update idletasks
	SendToUser $who "RGET $port $what [file size $MV(roomdir)/$MV(roomfile)]"
}	

proc SendRoom {which sock address their_port} {
	global MV

	catch {close $MV($which.server)}
	puts "(!) -- SOCKET_CLOSE $MV($which.server)"
	set $MV($which.time) 0
	if {$MV($which.remote) != $address} {
		catch {close $sock}
		puts "(!) -- SOCKET_CLOSE $sock"
		return
	}
	set MV($which.socket) $sock
	set MV($which.fileopen) 0
	fconfigure $sock -blocking 0 -buffering none -translation binary
	set infile [open $MV(roomdir)/$MV($which.file)]
	puts "(!) -- FILE_OPEN $infile"
	fconfigure $infile -translation binary
	fconfigure $sock -blocking 0 -buffering none -translation binary
	while {[eof $infile] != 1} {
		set MV($which.idletime) [clock seconds]
		set buffer [read $infile $MV(sendbuffer)]
		catch {puts -nonewline $sock $buffer}
		update idletasks
	}
	close $infile
	puts "(!) -- FILE_CLOSE $infile"
	catch {close $sock}
	puts "(!) -- SOCKET_CLOSE $sock"
	puts "($MV($which.sckt)) --> File Transfer Complete $MV($which.file)"
	set idx [lsearch -exact $MV(ports) $which]
	puts "($MV($which.sckt))  -- Removing idx $idx (of [llength $MV($MV($which.sckt).downloads)])"
	set MV(ports) [lreplace $MV(ports) $idx $idx]
}

# --------------------------------------------------------
# --                END OLD DOWNLOAD CODE               --
# --------------------------------------------------------

CheckTimeouts
vwait waiter
