#!/usr/bin/wish
#
# OpenVerse Main Module 
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Main Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Command Line
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

global MV

if {$argv0 != ""} {
	set app "$argv0"
} else {
	set app [pwd]
}

catch { set app [file readlink "$app"] }


switch [array get tcl_platform platform] {
	"platform macintosh" {
		#
		# This seems to work if you put the wish
		# binary in the dir you are starting from.
		#
		set MV(homedir) "."
		set MV(libdir) "$MV(homedir)/lib"
		set MV(helpdir) "$MV(homedir)/help"
		source [file nativename "$MV(libdir)/Globals.tcl"]
		proc List_Avatars {} {
			global MV
			set avatars [lsort -ascii [glob -nocomplain [file nativename "$MV(anims)/*"]]]
			return $avatars
		}
		proc List_Plugins {} {
			global MV
			set plugins [lsort -ascii [glob -nocomplain [file nativename "$MV(plugindir)/*"]]]
			return $plugins
		}
		proc List_Images {} {
			global MV
			set images [lsort -ascii [glob -nocomplain [file nativename "$MV(images)/*"]]]
			return $images
		}
		proc List_Panels {} {
			global MV
			set panels [lsort -ascii [glob -nocomplain [file nativename "$MV(paneldir)/*"]]]
			return $panels
		}
	} 
	"platform unix" {
		#
		# UNIX just rules, this should take care of all
		# startup problems for this platform including user
		# errors.
		set MV(homedir) "~/.OpenVerse"
		set MV(libdir) "/usr/lib/OpenVerse/lib"
		set MV(libbase) "/usr/lib/OpenVerse"
		set MV(helpdir) "$MV(libbase)/help"
		source [file nativename "$MV(libdir)/Globals.tcl"]
		#
		# FORCE UPGRADE!
		#
		if [file exists "$MV(homedir)/plugins/Query"] {
			catch {file delete -force "$MV(homedir)/plugins/Query"}
		}
		if ![file exists "$MV(homedir)"] {
			file mkdir $MV(homedir)
			file mkdir $MV(homedir)/images
			file mkdir $MV(homedir)/rimages
			file mkdir $MV(homedir)/anims
			file mkdir $MV(homedir)/rooms
			file mkdir $MV(homedir)/plugins
			file mkdir $MV(homedir)/plugins/Query
			file mkdir $MV(homedir)/objects
			file mkdir $MV(homedir)/icons
			file mkdir $MV(homedir)/download
			file copy "$MV(libbase)/images/default.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/bob.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/devil.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/anims/default.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/Bob.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/BSDdevil.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/rooms/room.gif" "$MV(homedir)/rooms"
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
			file copy "$MV(libbase)/icons/unknown.gif" "$MV(homedir)/icons/unknown.gif"
			file copy "$MV(libbase)/icons/notes.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/wwwurl.gif" "$MV(homedir)/icons/wwwurl.gif"
			file copy "$MV(libbase)/icons/ftpurl.gif" "$MV(homedir)/icons/ftpurl.gif"
			file copy "$MV(libbase)/icons/emailurl.gif" "$MV(homedir)/icons/emailurl.gif"
			file copy "$MV(libbase)/icons/dccfile.gif" "$MV(homedir)/icons/dccfile.gif"
			file copy "$MV(libbase)/icons/mv2.xbm" "$MV(homedir)/icons/mv2.xbm"
			file copy "$MV(libbase)/icons/mv2.xpm" "$MV(homedir)/icons/mv2.xpm"
			file copy "$MV(libbase)/icons/mv2.gif" "$MV(homedir)/icons/mv2.gif"
			file copy "$MV(libbase)/icons/log.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/pinfo.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/unlocked.gif" "$MV(homedir)/icons/unlocked.gif"
			file copy "$MV(libbase)/icons/locked.gif" "$MV(homedir)/icons/locked.gif"
			file copy "$MV(libbase)/icons/default.gif" "$MV(homedir)/icons/default.gif"
		}
		if ![file exists $MV(homedir)/images] {
			file mkdir $MV(homedir)/images
			file copy "$MV(libbase)/images/default.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/bob.gif" "$MV(homedir)/images"
			file copy "$MV(libbase)/images/devil.gif" "$MV(homedir)/images"
		}
		if ![file exists $MV(homedir)/icons] {
			file mkdir $MV(homedir)/icons
			file copy "$MV(libbase)/icons/notes.gif" "$MV(homedir)/icons"
			file copy "$MV(libbase)/icons/unknown.gif" "$MV(homedir)/icons/unknown.gif"
			file copy "$MV(libbase)/icons/dccfile.gif" "$MV(homedir)/icons/dccfile.gif"
			file copy "$MV(libbase)/icons/mv2.xpm" "$MV(homedir)/icons/mv2.xpm"
			file copy "$MV(libbase)/icons/mv2.xbm" "$MV(homedir)/icons/mv2.xbm"
			file copy "$MV(libbase)/icons/mv2.gif" "$MV(homedir)/icons/mv2.gif"
			file copy "$MV(libbase)/icons/log.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/pinfo.gif" "$MV(homedir)/icons/"
			file copy "$MV(libbase)/icons/unlocked.gif" "$MV(homedir)/icons/unlocked.gif"
			file copy "$MV(libbase)/icons/locked.gif" "$MV(homedir)/icons/locked.gif"
			file copy "$MV(libbase)/icons/wwwurl.gif" "$MV(homedir)/icons/wwwurl.gif"
			file copy "$MV(libbase)/icons/ftpurl.gif" "$MV(homedir)/icons/ftpurl.gif"
			file copy "$MV(libbase)/icons/emailurl.gif" "$MV(homedir)/icons/emailurl.gif"
			file copy "$MV(libbase)/icons/default.gif" "$MV(homedir)/icons/default.gif"
		}
		if ![file exists $MV(homedir)/icons/dccfile.gif] {
			file copy "$MV(libbase)/icons/dccfile.gif" "$MV(homedir)/icons/dccfile.gif"
		}
		if ![file exists $MV(homedir)/icons/notes.gif] {
			file copy "$MV(libbase)/icons/notes.gif" "$MV(homedir)/icons"
		}
		if ![file exists $MV(homedir)/icons/default.gif] {
			file copy "$MV(libbase)/icons/default.gif" "$MV(homedir)/icons/default.gif"
		}
		if ![file exists $MV(homedir)/icons/unlocked.gif] {
			file copy "$MV(libbase)/icons/unlocked.gif" "$MV(homedir)/icons/unlocked.gif"
		}
		if ![file exists $MV(homedir)/icons/log.gif] {
			file copy "$MV(libbase)/icons/log.gif" "$MV(homedir)/icons/"
		}
		if ![file exists $MV(homedir)/icons/pinfo.gif] {
			file copy "$MV(libbase)/icons/pinfo.gif" "$MV(homedir)/icons/"
		}
		if ![file exists $MV(homedir)/icons/locked.gif] {
			file copy "$MV(libbase)/icons/locked.gif" "$MV(homedir)/icons/locked.gif"
		}
		if ![file exists $MV(homedir)/icons/unknown.gif] {
			file copy "$MV(libbase)/icons/unknown.gif" "$MV(homedir)/icons/unknown.gif"
		}
		if ![file exists $MV(homedir)/icons/wwwurl.gif] {
			file copy "$MV(libbase)/icons/wwwurl.gif" "$MV(homedir)/icons/wwwurl.gif"
		}
		if ![file exists $MV(homedir)/icons/ftpurl.gif] {
			file copy "$MV(libbase)/icons/ftpurl.gif" "$MV(homedir)/icons/ftpurl.gif"
		}
		if ![file exists $MV(homedir)/icons/emailurl.gif] {
			file copy "$MV(libbase)/icons/emailurl.gif" "$MV(homedir)/icons/emailurl.gif"
		}
		if ![file exists $MV(homedir)/icons/mv2.gif] {
			file copy "$MV(libbase)/icons/mv2.gif" "$MV(homedir)/icons/mv2.gif"
		}
		if ![file exists $MV(homedir)/icons/mv2.xpm] {
			file copy "$MV(libbase)/icons/mv2.xpm" "$MV(homedir)/icons/mv2.xpm"
		}
		if ![file exists $MV(homedir)/icons/mv2.xbm] {
			file copy "$MV(libbase)/icons/mv2.xbm" "$MV(homedir)/icons/mv2.xbm"
		}
		if ![file exists $MV(homedir)/panels] {
			file mkdir $MV(homedir)/panels
		}
		if ![file exists "$MV(homedir)/panels/Fun"] {
			file copy "$MV(libbase)/panels/Fun" "$MV(homedir)/panels"
		}
		if ![file exists "$MV(homedir)/panels/NotFun"] {
			file copy "$MV(libbase)/panels/NotFun" "$MV(homedir)/panels"
		}
		if ![file exists $MV(homedir)/plugins] {
			file mkdir $MV(homedir)/plugins
			file mkdir $MV(homedir)/plugins/Query
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
		}
		if ![file exists $MV(homedir)/plugins/Query] {
			file mkdir $MV(homedir)/plugins/Query
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
		}
		if ![file exists $MV(homedir)/plugins/Query/PlugInit.tcl] {
			file copy "$MV(libbase)/plugins/Query/PlugInit.tcl" "$MV(homedir)/plugins/Query"
		}
		if ![file exists $MV(homedir)/anims] {
			file mkdir $MV(homedir)/anims
			file copy "$MV(libbase)/anims/default.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/Bob.av" "$MV(homedir)/anims"
			file copy "$MV(libbase)/anims/BSDdevil.av" "$MV(homedir)/anims"
		}
		if ![file exists $MV(homedir)/rooms] {
			file mkdir $MV(homedir)/rooms
			file copy "$MV(libbase)/rooms/room.gif" "$MV(homedir)/rooms"
		}
		if ![file exists $MV(homedir)/images/default.gif] {
			file copy "$MV(libbase)/images/default.gif" "$MV(homedir)/images"
		}
		if ![file exists $MV(homedir)/images/bob.gif] {
			file copy "$MV(libbase)/images/bob.gif" "$MV(homedir)/images"
		}
		if ![file exists $MV(homedir)/images/devil.gif] {
			file copy "$MV(libbase)/images/devil.gif" "$MV(homedir)/images"
		}
		if ![file exists $MV(homedir)/anims/default.av] {
			file copy "$MV(libbase)/anims/default.av" "$MV(homedir)/anims"
		}
		if ![file exists $MV(homedir)/anims/Bob.av] {
			file copy "$MV(libbase)/anims/Bob.av" "$MV(homedir)/anims"
		}
		if ![file exists $MV(homedir)/anims/BSDdevil.av] {
			file copy "$MV(libbase)/anims/BSDdevil.av" "$MV(homedir)/anims"
		}
		if ![file exists $MV(homedir)/rooms/room.gif] {
			file copy "$MV(libbase)/rooms/room.gif" "$MV(homedir)/rooms"
		}
		wm iconbitmap . @$MV(homedir)/icons/mv2.xbm
		proc List_Avatars {} {
			global MV
			set avatars [lsort -ascii [glob -nocomplain "$MV(anims)/*"]]
			return $avatars
		}
		proc List_Images {} {
			global MV
			set images [lsort -ascii [glob -nocomplain "$MV(images)/*"]]
			return $images
		}
		proc List_Plugins {} {
			global MV
			set plugins [lsort -ascii [glob -nocomplain "$MV(plugindir)/*"]]
			return $plugins
		}
		proc List_Panels {} {
			global MV
			set panels [lsort -ascii [glob -nocomplain "$MV(paneldir)/*"]]
			return $panels
		}
	}
	default {
		#
		# Windows! This section needs some more work
		# since windows does not really support a safe
		# central location for OpenVerse, there is really
		# no way to protect against users who delete things.
		#
		set MV(homedir) "[file dirname "$app"]"
		set MV(libdir) "$MV(homedir)/lib"
		set MV(helpdir) "$MV(homedir)/help"
		source [file nativename "$MV(libdir)/Globals.tcl"]
		#wm iconbitmap . @$MV(homedir)/icons/mv2.ico
		proc List_Avatars {} {
			global MV
			set avatars [lsort -ascii [glob -nocomplain "$MV(anims)/*"]]
			return $avatars
		}
		proc List_Plugins {} {
			global MV
			set plugins [lsort -ascii [glob -nocomplain "$MV(plugindir)/*"]]
			return $plugins
		}
		proc List_Images {} {
			global MV
			set images [lsort -ascii [glob -nocomplain "$MV(images)/*"]]
			return $images
		}
		proc List_Panels {} {
			global MV
			set panels [lsort -ascii [glob -nocomplain "$MV(paneldir)/*"]]
			return $panels
		}
	}
} 

if ![file exists "$MV(homedir)/rimages"] {file mkdir "$MV(homedir)/rimages"}
if ![file exists "$MV(homedir)/download"] {file mkdir "$MV(homedir)/download"}
if ![file exists "$MV(homedir)/objects"] {file mkdir "$MV(homedir)/objects"}

source [file nativename "$MV(libdir)/IOFuncs.tcl"]
source [file nativename "$MV(libdir)/BaseFunc.tcl"]
source [file nativename "$MV(libdir)/FBrowse.tcl"]
source [file nativename "$MV(libdir)/InitMain.tcl"]
