# OpenVerse Bug Reporting Module
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Bug Reporting Module
# Current Revision No.	- 0.1
# Current Maintainter 	- Cruise <cruise@drunkenbastards.org>
# Last update 		- Sun Sep  5 21:24:33 EDT 1999
# Sourced By		- Main Module
#
# Copyright (C) 1999 David Gale <cruise@drunkenbastards.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

proc BugReport {win badbutton} {
	global MV tcl_platform env

	pack forget $badbutton
	pack $win.text -side bottom -fill both -expand y
	pack $win.text.text -fill both -expand y
	update idletasks
	set platform [array get tcl_platform platform]
	$win.text.text insert end "Connecting to mail server\n"
	update idletasks
	set mail_server [socket 206.154.148.10 25]
	if {[string range $mail_server 0 3] != "sock"} {
		$win.text.text insert end "Connection to mail server failed\n"
		pack $win.text.quit
		update idletasks
		return -1
	}
	update idletasks
	$win.text.text insert end "Sending HELO\n"
	update idletasks
	puts $mail_server "HELO OpenVerse.drunkenbastards.org"
	$win.text.text insert end "Sending MAIL FROM\n"
	update idletasks
	puts $mail_server "MAIL FROM: cruise@drunkenbastards.org"
	$win.text.text insert end "Sending RCPT TO\n"
	update idletasks
	puts $mail_server "RCPT TO: cruise@drunkenbastards.org"
	$win.text.text insert end "Sending DATA\n"
	update idletasks
	puts $mail_server "DATA"
	puts $mail_server "From: OpenVerse User $env(USER)"
	puts $mail_server "Subject: OpenVerse Bug Report from $env(USER)\n"
	puts $mail_server "Here are the details.\n"
	puts $mail_server "-------------------------------------"
	puts $mail_server "Version        : $MV(version)"
	puts $mail_server "Platform       : $platform"
	puts $mail_server ""
	puts $mail_server "Primary Error  : $MV(error)"
	$win.text.text insert end "Sending DATA\n"
	update idletasks
	puts $mail_server ""
	puts $mail_server "--------- StackTrace ----------"
	puts $mail_server ""
	puts $mail_server "$MV(errorInfo)"
	puts $mail_server ""
	puts $mail_server "."
	$win.text.text insert end "Done Sending BugReport!\n"
	$win.text.text insert end "Thank you for your assistance!!\n"
	update idletasks
	close $mail_server
	pack $win.text.quit
	return 1
}
