# OpenVerse File Browser
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- File Browser Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Command Line
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

proc MP3setFile {w y cmd init dirv} {
   set x [$w.mid.flist.l nearest $y]
    set fn [$w.mid.flist.l get $x]
    MP3checkFile $w $fn $cmd $init $dirv
}
#
proc MP3fillFile {w fn} {
    global Shall FBFilter
    $w.mid.flist.l delete 0 end
    set od [pwd]
    cd $fn
    set ptns *
    if {$Shall($w)} { set ptns {.* *} }
	foreach ptn $ptns {
	if {![catch {set fls [glob -nocomplain $ptn]}]} {
	    foreach fl [lsort $fls] {
		switch -exact -- $fl { . - .. { continue} }
		if {[file isdirectory $fl]} { append fl / } \
		elseif {![regexp -- $FBFilter($w) $fl]} continue
		$w.mid.flist.l insert end $fl
	    }
	}
    }
    cd $od
}
#
proc MP3checkFile {w fn cmd init dirv} {
    upvar #0 $dirv dir
    if {[file isdirectory [set fn [file join $dir $fn]]]} {
	set dir $fn
	#regexp {^(.+)/$} $dir m dir
	MP3setDirMenu $w $cmd $init $dirv
	MP3entrySet $w.mid.e4 $init
	MP3fillFile $w $fn
    } {
	$cmd "$fn"
	MP3killFWindow $w
    }
}
#
proc MP3mkFileBox {w dirv filter title msgText init args} {
	global tcl_platform 
    upvar #0 $dirv direct
    if {![info exists direct] || [string match {} $direct]} {
	set direct [pwd]
    }
    switch {} $w {set w .@[newName flb]} default {MP3killFWindow $w}
    global FBFilter
    set FBFilter($w) $filter
	toplevel $w
	wm title $w $title
	wm resizable $w 0 0
    wm transient $w [winfo toplevel [winfo parent $w]]
    frame $w.top -relief raised
    frame $w.mid -borderwidth 0
    frame $w.bot -relief raised
    grid $w.top -sticky nsew
    grid $w.mid -sticky nsew
    grid columnconfigure $w.mid 1 -weight 1
    grid $w.bot -sticky ew
    switch {} $msgText {} default {
	grid [message $w.top.message -text $msgText -aspect 800] - -sticky nsew
    }
    set arg [lindex $args 0]
    set cmd [lindex $arg 1]
set col 0
if {[file exists "a:/"] == 1} {button $w.top.a -text "A:" -command "MP3checkFile $w a:/ {} {} $dirv";grid $w.top.a -row 1 -column $col;incr col}
if {[file exists "b:/"] == 1} {button $w.top.b -text "B:" -command "MP3checkFile $w b:/ {} {} $dirv";grid $w.top.b -row 1 -column $col;incr col}
if {[file exists "c:/"] == 1} {button $w.top.c -text "C:" -command "MP3checkFile $w c:/ {} {} $dirv";grid $w.top.c -row 1 -column $col;incr col}
if {[file exists "d:/"] == 1} {button $w.top.d -text "D:" -command "MP3checkFile $w d:/ {} {} $dirv";grid $w.top.d -row 1 -column $col;incr col}
if {[file exists "e:/"] == 1} {button $w.top.e -text "E:" -command {};grid $w.top.e -row 1 -column $col;incr col}
if {[file exists "f:/"] == 1} {button $w.top.f -text "F:" -command {};grid $w.top.f -row 1 -column $col;incr col}
if {[file exists "g:/"] == 1} {button $w.top.g -text "G:" -command {};grid $w.top.g -row 1 -column $col;incr col}
if {[file exists "h:/"] == 1} {button $w.top.h -text "H:" -command {};grid $w.top.h -row 1 -column $col;incr col}
if {[file exists "i:/"] == 1} {button $w.top.i -text "I:" -command {};grid $w.top.i -row 1 -column $col;incr col}
if {[file exists "j:/"] == 1} {button $w.top.j -text "J:" -command {};grid $w.top.j -row 1 -column $col;incr col}
if {[file exists "k:/"] == 1} {button $w.top.k -text "K:" -command {};grid $w.top.k -row 1 -column $col;incr col}
if {[file exists "l:/"] == 1} {button $w.top.l -text "L:" -command {};grid $w.top.l -row 1 -column $col;incr col}
if {[file exists "m:/"] == 1} {button $w.top.m -text "M:" -command {};grid $w.top.m -row 1 -column $col;incr col}
if {[file exists "n:/"] == 1} {button $w.top.n -text "N:" -command {};grid $w.top.n -row 1 -column $col;incr col}
if {[file exists "o:/"] == 1} {button $w.top.o -text "O:" -command {};grid $w.top.o -row 1 -column $col;incr col}
if {[file exists "p:/"] == 1} {button $w.top.p -text "P:" -command {};grid $w.top.p -row 1 -column $col;incr col}
if {[file exists "q:/"] == 1} {button $w.top.q -text "Q:" -command {};grid $w.top.q -row 1 -column $col;incr col}
if {[file exists "r:/"] == 1} {button $w.top.r -text "R:" -command {};grid $w.top.r -row 1 -column $col;incr col}
if {[file exists "s:/"] == 1} {button $w.top.s -text "S:" -command {};grid $w.top.s -row 1 -column $col;incr col}
if {[file exists "t:/"] == 1} {button $w.top.t -text "T:" -command {};grid $w.top.t -row 1 -column $col;incr col}
if {[file exists "u:/"] == 1} {button $w.top.u -text "U:" -command {};grid $w.top.u -row 1 -column $col;incr col}
if {[file exists "v:/"] == 1} {button $w.top.v -text "V:" -command {};grid $w.top.v -row 1 -column $col;incr col}
if {[file exists "w:/"] == 1} {button $w.top.w -text "W:" -command {};grid $w.top.w -row 1 -column $col;incr col}
if {[file exists "x:/"] == 1} {button $w.top.x -text "X:" -command {};grid $w.top.x -row 1 -column $col;incr col}
if {[file exists "y:/"] == 1} {button $w.top.y -text "Y:" -command {};grid $w.top.y -row 1 -column $col;incr col}
if {[file exists "z:/"] == 1} {button $w.top.z -text "Z:" -command {};grid $w.top.z -row 1 -column $col;incr col}
    menubutton $w.mid.dir -relief raised -menu $w.mid.dir.menu -borderwidth 2
    menu $w.mid.dir.menu -tearoff 0
    MP3setDirMenu $w $cmd $init $dirv
    grid $w.mid.dir - -sticky ew -padx 5
    MP3makeLB $w.mid.flist
    grid $w.mid.flist - -sticky nsew
    uplevel 0 set Shall($w) 0
    checkbutton $w.mid.shall -text "Show Hidden Files" -variable Shall($w) \
	-command "MP3checkFile $w \[set $dirv\] {$cmd} {$init} $dirv"
    grid $w.mid.shall -
    MP3glabelEntry 0 3 0 $w.mid "-text Filter" {.*} "MP3setFilter %W {$init} $dirv; break"
    MP3glabelEntry 0 4 0 $w.mid "-text FileName" $init \
      "MP3checkFile $w \[%W get\] {$cmd} {$init} $dirv; MP3killFWindow $w ; break"
    MP3fillFile $w $direct
    bind $w.mid.flist.l <1> "
	set x \[%W nearest %y\]
	set f \[%W get \$x\]
	MP3entrySet $w.mid.e4 \
	 \[expr {\[file isdirectory \$f\] ? {} : \$f }\]
	%W selection anchor \$x
	break
    "
    bind $w.mid.flist.l <Double-1> "MP3setFile $w %y {$cmd} {$init} $dirv; break"
    switch {} $args {} default {
	frame $w.bot.0 -relief raised -border 1
	grid $w.bot.0 -row 0 -column 0 -padx 5 -pady 5
	set cmd [lindex $arg 1]
	switch {} $cmd {} default {append cmd " \[file join \[set $dirv\] \[$w.mid.e4 get\]\]"}
	button $w.bot.0.button -text [lindex $arg 0] \
		-command "$cmd ; MP3killFWindow $w"
	grid $w.bot.0.button -padx 5 -pady 5
	bind $w <Return> "$cmd ; MP3killFWindow %W ; break"
	focus $w
	set i 1
	foreach arg [lrange $args 1 end] {
	    set cmd [lindex $arg 1]
	    switch {} $cmd {} default {append cmd " \[file join \[set $dirv\] \[$w.mid.e4 get\]\]"}
	    button $w.bot.$i -text [lindex $arg 0] \
	      -command "$cmd ; MP3killFWindow $w"
	    grid $w.bot.$i -row 0 -column $i
	    incr i
	}
    }
    bind $w <Any-Enter> {focus %W ; break}
    MP3dialogPosn $w
    return $w
}
#
proc MP3setDirMenu {w cmd init dirv} {
    upvar #0 $dirv dir
    [set mn $w.mid.dir.menu] delete 0 end
    $mn add command -label / -command "MP3checkFile $w / {$cmd} {$init} $dirv"
    set crt {}
    set lst [split $dir /]
    foreach x [lrange $lst 1 end] {
	switch {} $x continue
	append crt /$x
	$mn add command -label $x \
	  -command "MP3checkFile $w {$crt} {$cmd} {$init} $dirv"
    }
    
    switch / $dir {
	$w.mid.dir configure -text /
    } default {
	$w.mid.dir configure -text [lindex $lst end]
    }
}
#
proc MP3setFilter {win init dirv} {
   global FBFilter
   set w [winfo toplevel $win]
   set FBFilter($w) [$win get]
   MP3checkFile $w {} {} $init $dirv
}
#
proc MP3killFWindow {w} {
    catch {uplevel #0 FBFilter($w) Shall($w)}
    destroy $w
}
#
#
#
#
#

proc MP3makeLB {win args} {
    frame $win -borderwidth 0 -relief flat
    grid columnconfigure $win 0 -weight 1
    grid rowconfigure $win 0 -weight 1
    scrollbar $win.vs -command "$win.l yview" -relief sunken -highlightthickness 0
    scrollbar $win.hs -command "$win.l xview" -orient horizontal \
      -relief sunken -highlightthickness 0
    eval listbox $win.l -xscrollcommand "{MP3ghsSet $win.hs}" \
	-width 40 \
      -yscrollcommand "{MP3gvsSet $win.vs}" -selectmode single -setgrid 1 $args
    grid $win.l -row 0 -column 0 -sticky nsew
    bind $win <Enter> {focus %W.l}
    return $win
}

proc MP3emacsEntry {name args} {
    eval entry $name -relief sunken $args
    switch {} [bind EmacsEntry] {MP3entryBindings}
    bindtags $name "$name EmacsEntry Entry . all"
    return $name
}

proc MP3entryBindings {} {
    bind EmacsEntry <Delete> {notIdle %W ; tkEntryBackspace %W ; break}
    bind EmacsEntry <Control-u> {notIdle %W ; %W delete 0 insert }
}

proc MP3glabelEntry {t row col name opts init code} {
    eval label $name.l$row $opts
    [expr {$t ? "emacsTEntry" : "MP3emacsEntry"}] $name.e$row -relief sunken
    $name.e$row insert end $init
    grid $name.l$row -row $row -column $col
    grid $name.e$row -row $row -column [expr {$col + 1}]
    bind $name.e$row <Return> "notIdle %W ; $code"
    bind $name.e$row <BackSpace> [bind $name.e$row <Delete>]
    bind $name.e$row <Control-h> [bind $name.e$row <Delete>]
    return $name
}

proc MP3dialogPosn {w} {
    set sh [winfo screenheight $w]
    set sw [winfo screenwidth $w]
    wm geometry $w +[expr {($sw - [winfo reqwidth $w])/ 2}]+[expr {($sh - [winfo reqheight $w])/ 2}]
}

proc MP3gvsSet {sb f l} {
    switch 0 $f {switch 1 $l {catch {grid forget $sb ; return}}}
    catch {grid $sb -row 0 -column 1 -sticky ns}
    $sb set $f $l
}

proc MP3ghsSet {sb f l} {
    switch 0 $f {switch 1 $l {catch {grid forget $sb ; return}}}
    catch {grid $sb -row 1 -column 0 -sticky ew}
    $sb set $f $l
}

proc MP3entrySet {win val} { $win delete 0 end ; $win insert end $val }
