# OpenVerse Passageways Module
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Passageways Module
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- Init Main Window
#
# Copyright (C) 1999 David Gale <cruise@drunkenbastards.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

proc DoBookmarks {} {
	global MV

	set depth 0
	set marks 0

	destroy $MV(passageways_menu).m

	if !$MV(use_windowmanager_colors) {
		menu $MV(passageways_menu).m -bg $MV(colors.pw.bg) \
			-fg $MV(colors.pw.fg) -activeforeground $MV(colors.pw.afg) \
			-activebackground $MV(colors.pw.abg)
	} else {
		menu $MV(passageways_menu).m
	}

	$MV(passageways_menu).m add command -label "Add Current Room" \
		-command "AddBookmark"
	$MV(passageways_menu).m add command -label "Refresh List" \
		-command "QueryServers 1"

	if [file exists "$MV(bookmarks)"] {
		set MV(pwq.queries) {}
		set infile [open "$MV(bookmarks)" r]
		set server 0
		while {[eof $infile] != 1} {
			gets $infile input
			set bm [split $input "|"]
			set serv [split [lindex $bm 1] ":"]
			if {[string first "|" $input] != -1} {
				if !$depth {
					incr depth
					$MV(passageways_menu).m add cascade -menu \
						$MV(passageways_menu).m.m$depth -label "Passageways $depth"
					if !$MV(use_windowmanager_colors) {					
						menu $MV(passageways_menu).m.m$depth -bg $MV(colors.pw.bg) \
							-fg $MV(colors.pw.fg) -activeforeground $MV(colors.pw.afg) \
							-activebackground $MV(colors.pw.abg)
					} else {
						menu $MV(passageways_menu).m.m$depth
					}
				} 
				set MV(pwq.queries) "$server"
				set MV(pwq.$server.name) "[lindex $bm 0]"
				set MV(pwq.$server.host) "[lindex $serv 0]"
				set MV(pwq.$server.port) "[lindex $serv 1]"
				set MV(pwq.$server.menu) "$MV(passageways_menu).m.m$depth"
				incr server
				$MV(passageways_menu).m.m$depth add command -label "[lindex $bm 0]" \
					-command "ConnectToRoom [lindex $serv 0] [lindex $serv 1]"
				incr marks
				if {$marks > 19} {
					incr depth
					$MV(passageways_menu).m add cascade -menu \
						$MV(passageways_menu).m.m$depth -label "Passageways $depth"
					if !$MV(use_windowmanager_colors) {
						menu $MV(passageways_menu).m.m$depth -bg $MV(colors.pw.bg) \
								-fg $MV(colors.pw.fg) -activeforeground $MV(colors.pw.afg) \
								-activebackground $MV(colors.pw.abg)
					} else {
						menu $MV(passageways_menu).m.m$depth
					}
					set marks 0
				}
			}
		}
		close $infile
	}
}

proc AddBookmark {} {
	global MV

	set outfile [open "$MV(bookmarks)" a+]
	puts $outfile "$MV(roomname)|$MV(roomhost):$MV(roomport)"
	close $outfile
	DoBookmarks
}

#
# Will query all servers in the passageways list
# and retrieve a number of users on each server.
# It will also note the time it took to respond to the query.

proc QueryServers {BookMark} {
	global MV

	if {[llength $MV(server_queries)] > 0} {return}
	if $BookMark {
		DoBookmarks
	}
	for {set c 0} {$c <= $MV(pwq.queries)} {incr c} {
		lappend MV(server_queries) $c
		set MV(pwq.$c.sock) -1
		catch {set sck [socket -async $MV(pwq.$c.host) $MV(pwq.$c.port)]}
		set MV(pwq.$c.sock) $sck
		catch {fconfigure $MV(pwq.$c.sock) -blocking 1}
		set MV(pwq.$c.time) [clock seconds]
		after 30000 "PWKillRequestSocket $c"
		catch {fileevent $MV(pwq.$c.sock) writable "PWQueryServer $c"}
		update idletasks
	}
}

proc PWQueryServer {idx} {
	global MV

	catch {fileevent $MV(pwq.$idx.sock) {}}
	catch {puts $MV(pwq.$idx.sock) "USERS"}
	catch {flush $MV(pwq.$idx.sock)}
	catch {fileevent $MV(pwq.$idx.sock) readable "PWGetUsers $idx"}
}

proc PWGetUsers {idx} {
	global MV

	set input "AUTH REQD"
	catch {gets $MV(pwq.$idx.sock) input}
	set users [string range $input [expr [string first " " $input] +1] end]
	set tme [expr [clock seconds] - $MV(pwq.$idx.time)]
	switch -exact -- $users {
		"PING" { 
			# caught in a ping loop :)
			return;
		}
		"REQD" {
			$MV(pwq.$idx.menu) entryconfigure $MV(pwq.$idx.name) -label "(??) ($tme S) $MV(pwq.$idx.name)" -foreground red -activeforeground red
		}
		default {
			if {$users != "" && $users > 0} {
				$MV(pwq.$idx.menu) entryconfigure $MV(pwq.$idx.name) -label "($users) ($tme S) $MV(pwq.$idx.name)" -foreground blue -activeforeground blue
			} else {
				$MV(pwq.$idx.menu) entryconfigure $MV(pwq.$idx.name) -label "($users) ($tme S) $MV(pwq.$idx.name)" -foreground "dark green" -activeforeground "dark green"
			}
		}
	}
	set MV(pwq.$idx.time) 0
	set id [lsearch -exact $MV(server_queries) $idx]
	set MV(server_queries) [lreplace $MV(server_queries) $id $id]
	catch {close $MV(pwq.$idx.sock)}
}

proc PWKillRequestSocket {idx} {
	global MV

	if !$MV(pwq.$idx.time) {
		set id [lsearch -exact $MV(server_queries) $idx]
		set MV(server_queries) [lreplace $MV(server_queries) $id $id]
		return
	}
	catch {close $MV(pwq.$idx.sock)}
	$MV(pwq.$idx.menu) entryconfigure $MV(pwq.$idx.name) -label "(--) (TO) $MV(pwq.$idx.name)" -foreground red -activeforeground red
	set id [lsearch -exact $MV(server_queries) $idx]
	set MV(server_queries) [lreplace $MV(server_queries) $id $id]
	set MV(pwq.$idx.time) 0
}
