# Movie Support Procs
# 


# 
proc MovieProgressProc {widget action command percent } { 
	
	update
	# remove all the '.' characters
	regsub -all \. $widget "" mwidget
	set t .movieProgressProc$mwidget
	set title [$widget cget -file]
	switch $action {
		open {
			# open here
			toplevel $t
			wm title $t "Progress for $title"
			label $t.l -text "Movie $title 0 % done"
			grid $t.l
			button $t.cancel -text Cancel \
			  -command "MovieProgressProc $widget cancel $command $percent"
			grid $t.cancel
		}
		percent {
			# percent here
			$t.l configure -text "Movie $title $percent % done"
		}
		close {
			# close here
			destroy $t
		}
		cancel {
			destroy $t
			error "user canceled"
		}
		
	}
	update
}

# Note that these two procs are now no longer really needed since QuickTimeTcl
# now can use the Apple Movie Controllers.

proc MovieControllerTime {timescale time} {
	set hrs [expr int($time/$timescale/3600)]
	set mins [expr $time/$timescale - 3600*$hrs]
	set mins [expr int($mins/60)]
	set secs [expr double($time)/double($timescale) - 3600*$hrs - 60*$mins]
	return [format "%02.2d:%02.2d:%05.2f" $hrs $mins $secs]
}


# movie controller proc

proc MovieController {widget {action create}} {
	
	switch $action {
		create {
			frame $widget
			Movie $widget.movie
			frame $widget.controls
			label $widget.controls.movietime -text "00:00:00.00"
			label $widget.controls.totaltime -text "00:00:00.00"
			button $widget.controls.control -state disabled -text "Play" \
			  -command "MovieController $widget play"
			button $widget.controls.volp -state disabled -text "+" \
			  -command "MovieController $widget upvol"
			button $widget.controls.volm -state disabled -text "-" \
			  -command "MovieController $widget downvol"
			grid $widget.movie 
			grid $widget.controls -sticky sw
			grid $widget.controls.control -columnspan 2 
			grid $widget.controls.movietime -column 2 -row 0
			grid $widget.controls.volp $widget.controls.volm \
			  $widget.controls.totaltime
			after 500 MovieController $widget update
		}
		upvol {
			set vol [$widget.movie cget -volume]
			set vol [expr $vol + 32]
			if {$vol >= 255} {
				set vol 255
				$widget.controls.volp configure -state disabled
			}
			$widget.movie configure -volume $vol
		}
		downvol {
			set vol [$widget.movie cget -volume]
			set vol [expr $vol - 32]
			if {$vol <= 0} {
				set vol 0
				$widget.controls.volm configure -state disabled
			}
			$widget.movie configure -volume $vol
		}
		
		destroy {
			destroy $widget
		}
		play {
			$widget.movie stop
			$widget.movie settime 0
			$widget.movie play
			$widget.controls.control configure -command "MovieController $widget stop" \
			  -text "Stop"
		}
		stop {
			$widget.movie stop
			$widget.controls.control configure -command "MovieController $widget play" \
			  -text "Play"
		}
		rewind {
			MovieController $widget stop
			$widget.movie settime 0
		}
		update {
			update
			if {[catch {$widget.movie isdone}]} {
				# we don't have a movie
			} else {
				# we have a movie
				set totaltime [lindex [lindex [$widget.movie gettime] 1] 1]
				set timescale [lindex [lindex [$widget.movie gettime] 2] 1]
				set movietime [lindex [lindex [$widget.movie gettime] 0] 1]	
				set vol [$widget.movie cget -volume]
				if {[$widget.movie isdone]} {
					$widget.movie stop
					$widget.controls.control configure -text "Play" \
					  -command "MovieController $widget play"
				}
				$widget.controls.control configure -state normal
				if {$vol > 0} {
					$widget.controls.volm configure -state normal
				} else {
					$widget.controls.volm configure -state disabled
				}
				if {$vol < 255} {
					$widget.controls.volp configure -state normal
				} else {
					$widget.controls.volp configure -state disabled
				}
				
				set totaltime [lindex [lindex [$widget.movie gettime] 1] 1]
				set timescale [lindex [lindex [$widget.movie gettime] 2] 1]
				set movietime [lindex [lindex [$widget.movie gettime] 0] 1]	
				$widget.controls.totaltime configure -text \
				  [MovieControllerTime $timescale $totaltime]
				$widget.controls.movietime configure -text \
				  [MovieControllerTime $timescale $movietime]
			}
			
			after 1500 MovieController $widget update
		}
		
	}
}
