#------------------------------------------------------------------------
#
#  mkGetCanvas.tcl ---
#  
#  Part of the Whiteboard application. 
#   
#  The whiteboard application has been developed by:
#  
#	Mats Bengtsson, 
#	Hamngatan 21,
#	SE-58226, Linkoping Sweden,
#	matben@lin.foa.se,
#	phone: +46 13 136114
# 
#  It is distributed under the standard GPL.
#  See the README file for further details.
#  
#------------------------------------------------------------------------

proc mkGetCanvas { w }  {
    global  allIPnumsTo ipNum2Name ipName2Num getIPName finished sysFont  \
      prefs
    
    # Build list of ip names.
    set ipNames {}
    foreach ip $allIPnumsTo  {
	if {[info exists ipNum2Name($ip)]}  {
	    lappend ipNames $ipNum2Name($ip)
	}
    }
    #set ipNames {kalle bertil johan}
    if {[llength $ipNames] == 0}  {
	return 
    }
    set finished 0
    catch {toplevel $w}
    wm title $w "Get Canvas"
    # Global frame.
    pack [frame $w.frall -borderwidth 1 -relief raised] -fill both -expand 1
    
    # Labelled frame.
    set wcfr [frame $w.frall.fr -borderwidth 0]
    pack $wcfr -side top -fill both -ipadx 10 -ipady 6 -in $w.frall
    set wcont [LabeledFrame $wcfr "Get Canvas"]
    # Overall frame for whole container.
    set frtot [frame $wcont.frin]
    pack $frtot
    message $frtot.msg -borderwidth 0 -font $sysFont(s) -aspect 500 \
      -text "Choose client from which you want to get the canvas.\
      Your own canvas will be erased."
    eval {tk_optionMenu $frtot.optm getIPName} $ipNames
    $frtot.optm configure -highlightthickness 0  \
      -background $prefs(bgColGeneral) -foreground black
    grid $frtot.msg -column 0 -row 0 -columnspan 2 -padx 4 -pady 2 -sticky news
    grid $frtot.optm -column 1 -row 1 -padx 4 -pady 0 -sticky e
    
    # button part
    set frbot [frame $w.frall.frbot -borderwidth 0]
    pack [button $frbot.btconn -text "    Get    " -default active \
      -command {set finished 1}]  \
      -side right -padx 5 -pady 5
    pack [button $frbot.btcancel -text " Cancel " -command {set finished 2}]  \
      -side right -padx 5 -pady 5
    pack $frbot -side top -fill both -expand 1 -padx 8 -pady 6

    wm resizable $w 0 0
    bind $w <Return> {set finished 1}
    # grab and focus
    focus $w
    catch {grab $w}
    tkwait variable finished

    catch {grab release $w}
    catch {destroy $w}
        
    if {$finished == 1 && [info exists ipName2Num($getIPName)]}  {
    	return $ipName2Num($getIPName)
    } else {
    	return ""
    }
}
