#------------------------------------------------------------------------
#
#  mkProgressWindow.tcl ---
#  
#  Part of the Whiteboard application. It makes a progress window.
#  The 'updatePerc' is a number between 0 and 100. Init by -1.
#  The 'cancelCmd' should contain the full command for the cancel operation.
#  
#  The whiteboard application has been developed by:
#  
#	Mats Bengtsson, 
#	Hamngatan 21,
#	SE-58226, Linkoping Sweden,
#	matben@lin.foa.se,
#	phone: +46 13 136114
# 
#  It is distributed under the standard GPL.
#  See the README file for further details.
#  
#------------------------------------------------------------------------

proc mkProgressWindow {w name fname cancelCmd {updatePerc -1}} {
    global  sysFont tcl_platform debugLevel
    
    if {$debugLevel >= 2}  {
	#puts "mkProgressWindow:: (entry) updatePerc=$updatePerc"
    }
    # Total size of canvas.
    set wwidth 280
    set wheight 90
    # Coordinates for the progress bar.
    set x1 12
    set y1 43
    set x2 198
    set y2 54
    
    # Apple original colors for the bar: #CECEFF and #424242
    # Create window
    if {$updatePerc == -1} {
	catch {destroy $w}
	if {$tcl_platform(platform) == "macintosh"}  {
	    toplevel $w; unsupported1 style $w documentProc;  \
		    wm withdraw $w
	} else  {
	    toplevel $w; wm withdraw $w
	}
	wm title $w $name
	wm resizable $w 0 0
	
	canvas $w.c -scrollregion "0 0 $wwidth $wheight"  \
	  -width $wwidth -height $wheight -highlightthickness 0  \
	  -bd 1 -relief raised
	pack $w.c -side top -fill x
	set id [$w.c create text 11 18 -anchor w -font $sysFont(sb)  \
	  -text "Writing file:"]
	set xoff [expr [lindex [$w.c bbox $id] 2] + 10]
	$w.c create text $xoff 18 -anchor w -text $fname -font $sysFont(sb)
	$w.c create text 75 75 -anchor se -text "Remaining: " -font $sysFont(s)
	$w.c create rectangle $x1 $y1 $x2 $y2 -fill #CECEFF -outline {}
	$w.c create rectangle $x1 $y1 $x1 $y2 -outline {} -fill   \
	  #424242 -tag progbar
	$w.c create line      $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 $x1 $y1  \
	  -width 1 -fill black
	button $w.c.bt -text "Cancel"  \
	  -command "catch {destroy $w}; eval $cancelCmd"
	$w.c create window 212 48 -window $w.c.bt -anchor w
	update idletasks
	wm deiconify $w
	raise $w
	update idletasks

    } elseif {$updatePerc >= 0 && $updatePerc <= 100} {
	# Only update progress bar
	$w.c coords progbar $x1 $y1 [expr $updatePerc*($x2 - $x1)/100 + $x1] $y2
	$w.c delete percent
	set num [expr 100 - int($updatePerc)]
	if {$num > 0}  {
	    $w.c create text 85 75 -anchor sw   \
	      -text "[expr 100 - int($updatePerc)]% left" -font $sysFont(s)	 \
	      -tag percent
	} else {
	    $w.c create text 85 75 -anchor sw   \
	      -text "Document: done" -font $sysFont(s) -tag percent
	}
	update idletasks
    } else {
    }
}

