
#  EditFontFamilies.tcl ---
#  
#      This file is part of the whiteboard application. It implements the
#      dialog of importing fonts to the whiteboard.
#      
#  Copyright (c) 1999-2000  Mats Bengtsson
#  
#  See the README file for license, bugs etc.

namespace eval ::EditFontFamilies::  {
    
    namespace export EditFontFamilies
}

proc ::EditFontFamilies::EditFontFamilies { w }  {
    global  sysFont prefs tcl_platform
    
    variable finished -1
    if {[winfo exists $w]} {
	return
    }
    if {[string compare $tcl_platform(platform) "macintosh"] == 0} {
	toplevel $w
	unsupported1 style $w documentProc
    } else {
	toplevel $w
    }
    wm title $w "Import Fonts"
    # Global frame.
    pack [frame $w.frall -borderwidth 1 -relief raised] -fill both -expand 1
    
    # Labelled frame.
    set wcfr [frame $w.frall.fr -borderwidth 0]
    pack $wcfr -side top -fill both -ipadx 10 -ipady 6 -in $w.frall
    set wcont [LabeledFrame $wcfr "Import/Remove fonts"]
    
    # Overall frame for whole container.
    set frtot [frame $wcont.frin]
    pack $frtot
    
    label $frtot.sysfont -text "System fonts" -font $sysFont(sb)
    label $frtot.wifont -text "Whiteboard fonts" -font $sysFont(sb)
    grid $frtot.sysfont x $frtot.wifont -padx 6 -pady 6
    
    grid [frame $frtot.fr1] [frame $frtot.fr2] [frame $frtot.fr3]   \
      -sticky news -padx 6 -pady 4
    set wlbsys $frtot.fr1.lb
    set wlbwb $frtot.fr3.lb
    
    # System fonts.
    listbox $wlbsys -width 22 -height 10  \
      -font $sysFont(s) -yscrollcommand [list $frtot.fr1.sc set]
    scrollbar $frtot.fr1.sc -orient vertical   \
      -command [list $frtot.fr1.lb yview]
    pack $frtot.fr1.lb $frtot.fr1.sc -side left -fill y
    eval $frtot.fr1.lb insert 0 [font families]
    
    # Mid buttons.
    pack [button $frtot.fr2.imp -text ">> Import >>" -state disabled \
      -command "[namespace current]::PushBtImport  \
      \[$wlbsys curselection] $wlbsys $wlbwb"] -padx 4 -pady 6 -fill x
    pack [button $frtot.fr2.rm -text "Remove" -state disabled  \
      -command "[namespace current]::PushBtRemove  \
      \[$wlbwb curselection] $wlbwb"] -padx 4 -pady 6 -fill x
    
    # Whiteboard fonts.
    listbox $wlbwb -width 22 -height 10  \
      -font $sysFont(s) -yscrollcommand [list $frtot.fr3.sc set]
    scrollbar $frtot.fr3.sc -orient vertical   \
      -command [list $frtot.fr3.lb yview]
    pack $frtot.fr3.lb $frtot.fr3.sc -side left -fill y
    eval $frtot.fr3.lb insert 0 $prefs(canvasFonts)
    
    message $frtot.msg -text "Warning: by importing any other fonts\
      than the standard three ones (Times, Helvetica or Courier),\
      you must be confident that all remote clients also have\
      this font installed on their system."   \
      -font $sysFont(s) -aspect 1000
    grid $frtot.msg -columnspan 3 -sticky news
    
    # Button part.
    set frbot [frame $w.frall.frbot -borderwidth 0]
    pack [button $frbot.btconn -text "  Save  " -default active \
      -command "[namespace current]::PushBtSave $wlbwb"]  \
      -side right -padx 5 -pady 5
    pack [button $frbot.btcancel -text " Cancel "   \
      -command "set [namespace current]::finished 0"]  \
      -side right -padx 5 -pady 5
    pack [button $frbot.btstd -text "Standard"  \
      -command "[namespace current]::PushBtStandard $wlbwb"]  \
      -side right -padx 5 -pady 5
    pack $frbot -side top -fill both -expand 1 -padx 8 -pady 6
    
    bind $w <Return> "$frbot.btconn invoke"
    bind $wlbsys <Button-1> {+ focus %W}
    bind $wlbwb <Button-1> {+ focus %W}
    bind $wlbsys <FocusIn>   \
      [list $frtot.fr2.imp configure -state normal]
    bind $wlbsys <FocusOut>   \
      [list $frtot.fr2.imp configure -state disabled]
    bind $wlbwb <FocusIn>   \
      [list $frtot.fr2.rm configure -state normal]
    bind $wlbwb <FocusOut>   \
      [list $frtot.fr2.rm configure -state disabled]
    wm resizable $w 0 0
    
    # Grab and focus.
    focus $w
    catch {grab $w}
    tkwait variable [namespace current]::finished
    
    catch {grab release $w}
    catch {destroy $w}
}
    
proc ::EditFontFamilies::PushBtImport { indSel wsys wapp }  {
    
    if {$indSel == ""}  {
	return
    }
    set fntName [$wsys get $indSel]
    
    # Check that it is not there already.
    set allFntApp [$wapp get 0 end]
    if {[lsearch $allFntApp $fntName] >= 0}  {
	return
    }
    $wapp insert end $fntName	
}
    
proc ::EditFontFamilies::PushBtRemove { indSel w }  {
    
    if {$indSel == ""}  {
	return
    }
    set fntName [$w get $indSel]
    # Check that not the standard fonts are removed.
    if {[lsearch {Times Helvetica Courier} $fntName] >= 0}  {
	tk_messageBox -message "The standard fonts, \
	  Times, Helvetic or Courier may not be removed" \
	  -icon error -type ok
	return
    }
    $w delete $indSel	
}
    
proc ::EditFontFamilies::PushBtSave { w }  {
    global  prefs
    
    variable finished

    # Do save.
    set prefs(canvasFonts) [$w get 0 end]
    BuildFontMenu .menu.prefs.font $prefs(canvasFonts)
    
    set finished 1
}
    
proc ::EditFontFamilies::PushBtStandard { w }  {
    
    # Insert the three standard fonts.
    $w delete 0 end
    eval $w insert 0 {"Times" "Helvetica" "Courier"}
}

#---------------------------------------------------------------------
