
#  SplashScreen.tcl ---
#  
#      This file is part of the whiteboard application. It implements the
#      splash screen typically displayed on startup.
#      
#  Copyright (c) 1999-2000  Mats Bengtsson
#  
#  See the README file for license, bugs etc.

namespace eval ::SplashScreen::  {
    
    # Trace variable to show progress in splash screen.
    variable startMsg ""
}
    
proc ::SplashScreen::SplashScreen  { w }  {
    global  sysFont tcl_platform dims
    
    variable startMsg
    if {$tcl_platform(platform) == "macintosh"}  {
	if [catch {toplevel $w; unsupported1 style $w movableDBoxProc}]  {
	    return
	}
    } else  {
	if [catch {toplevel $w}]  {
	    return
	}
    }
    wm title $w "About Whiteboard (Coccinella)"
    wm resizable $w 0 0
    wm transient $w
    wm geometry $w   \
      +[expr ($dims(screenW) - 450)/2]+[expr ($dims(screenH) - 300)/2]
    
    # If image not alreade there, get it.
    if {[lsearch [image names] mysplash] == -1}  {
	image create photo mysplash -format gif -file   \
	  [file join images splash.gif]
    }
    canvas $w.can -width 450 -height 300 -bd 0 -highlightthickness 0
    $w.can create image 0 0 -anchor nw -image mysplash
    $w.can create text 50 280 -anchor nw -tags tsplash   \
      -font $sysFont(s) -text $startMsg
    pack $w.can
    bind $w <Return> "destroy $w"
    bind $w <Button-1> "destroy $w"
}

#---------------------------------------------------------------------