# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: record.tcl,v 1.8 1998/10/17 20:40:52 jfontain Exp $}


class record {

    proc record {this args} switched {$args} {
        switched::complete $this
    }

    proc ~record {this} {
        variable ${this}data
        catch {unset ${this}data}
    }

    proc options {this} {
        return [list\
            [list -file {} {}]\
        ]
    }

    proc set-file {this value} {}

    proc write {this} {
        if {[string length $switched::($this,-file)]==0} {
            error {-file option undefined}
        }
        set file [open $switched::($this,-file) w+]                                                           ;# create or overwrite

        puts $file "version $::applicationVersion"
        set seconds [clock seconds]
        puts $file "date [clock format $seconds -format %D] time [clock format $seconds -format %T]"
        puts $file "configuration {}"                                                                      ;### when implemented ###
        # main window coordinates are not saved as it would be bad manners to force initial window placement
        puts $file "width [winfo width .] height [winfo height .]"
        puts $file "pollTime $::pollTime"
        puts $file "modules \{"
        foreach module $::modules(all) {
            puts $file "    $module \{"
            puts $file "        arguments {}"                                                              ;### when implemented ###
            puts $file "        tables \{"
            set index 0
            foreach table $dataTable::(list) {
                # filter other module tables
                if {[string compare $module [namespace qualifiers [composite::cget $table -data]]]!=0} continue
                foreach {x y width height} [canvasWindowManager::getGeometry $::windowManager $widget::($table,path)] {}
                puts $file "            $index \{"
                puts $file "                x $x y $y width $width height $height"
                puts $file "            \}"
                incr index
            }
            puts $file "        \}"
            puts $file "    \}"
        }
        puts $file \}
        puts $file "viewers \{"
        set index 0
        foreach viewer $viewer::(list) {
            puts $file "    $index \{"
            puts $file "        class [classof $viewer]"
            foreach {x y width height} [canvasWindowManager::getGeometry $::windowManager $widget::($viewer,path)] {}
            puts $file "        x $x y $y width $width height $height"
            puts $file "        cells {[viewer::cells $viewer]}"
            set options [viewer::initializationConfiguration $viewer]
            if {[llength $options]>0} {
                puts $file "        $options"
            }
            puts $file "    \}"
            incr index
        }
        puts $file \}

        close $file
    }

    proc read {this} {
        variable ${this}data

        if {[string length $switched::($this,-file)]==0} {
            error {-file option undefined}
        }
        set file [open $switched::($this,-file)]
        array set ${this}data [::read $file]
        close $file
    }

    proc modules {this} {
        variable ${this}data

        array set data [set ${this}data(modules)]
        return [array names data]
    }

    proc pollTime {this} {
        variable ${this}data

        return [set ${this}data(pollTime)]
    }

    proc sizes {this} {
        variable ${this}data

        return "[set ${this}data(width)] [set ${this}data(height)]"
    }

    proc viewersData {this} {
        variable ${this}data

        array set data [set ${this}data(viewers)]
        set list {}
        foreach index [lsort -integer [array names data]] {
            array set viewer $data($index)
            set options {}                                  ;# gather viewer specific switched options in a switch / value pair list
            foreach name [array names viewer -*] {
                lappend options $name $viewer($name)
            }
            lappend list $viewer(class) $viewer(cells) $viewer(x) $viewer(y) $viewer(width) $viewer(height) $options
        }
        return $list
    }

    proc tableGeometry {this module {index 0}} {
        variable ${this}data

        array set data [set ${this}data(modules)]
        array set moduleData $data($module)
        unset data
        array set tablesData $moduleData(tables)
        unset moduleData
        array set data $tablesData($index)
        unset tablesData
        return "$data(x) $data(y) $data(width) $data(height)"
    }

}
