.TH tkhylafax n
.SH NAME
tkhylafax v3.0 \- A Tcl/Tk graphical interface to Hylafax
.SH SYNOPSIS
.B tkhylafax [-faxResolution high|low] [-notifyOnCompletion yes|no] [-notifyOnRetry yes|no] [-initiatePoll yes|no] [-coverPage yes|no] [-editorCmd command] [-coverPageDirs paths]
.SH DESCRIPTION
.I tkhylafax
is a simple graphical interface to 
.I HylaFax. 
By using 
.I tkhylafax, 
you have
the ability to send a fax with selected options, and remove fax jobs. Currently
not all functionality is supported. In addition, a simple rolodex feature
is supported to add, modify, and delete fax numbers from your personal fax
database. Also, a batch feature allows the same files to be faxed to multiple
destinations.
.PP
To use 
.I tkhylafax
first make sure that 
.I HylaFax
is in your path. Also, 
.I tkhylafax
looks for the environment variable FAXNUMBERS for the rolodex database file.
YOU MUST HAVE THIS DEFINED TO USE THIS FEATURE.
.I tkhylafax
looks for the environment variable FAXALIASES for the batch alias database 
file. YOU MUST HAVE THIS DEFINED TO USE THIS FEATURE.
.I tkhylafax
should then start and be fully functional. To add phone numbers to the
rolodex database file, type in the name, company and fax number in the cover
sheet section, then select "Add a Number" under the phone pulldown menu. To
list all numbers select "List Numbers" and a new window with the numbers
should appear. Clicking the left mouse button over any entry in this window
will highlight that entry and popup a menu with three choices: "Add to Batch", 
"Load Cover Sheet" and "Remove from Database". Select the middle choice to 
load the information into 
the cover sheet information section of the main panel. "Remove from database"
will remove that entry from the fax number database. You'll have to re-enter
it if you want it back.
This information can now be used to send a fax. To delete a number, select 
the entry in the fax numbers window to be deleted (as described above), and 
then select "Delete a Number". To modify a number, 
select the entry in the fax numbers window to be modified, modify it in the
cover sheet information section and select "Add a Number". Currently, hitting
the 
.I tab
or
.I return
key will move you to the next entry field. Hitting the
.I shift-tab
keys will move you to the previous field.
.PP
There is now a search feature for fax numbers. On the fax numbers window, 
press the
.I search
button. A dialog will pop up and ask for a regular expression to use as the
search criteria. If you don't know what a regular expression is, just enter
the character string you're looking for. Pressing the
.I return
key will move you forward in the search. Pressing
.I shift-tab
will move you backwards in the search. The search always starts from the last
highlighted entry. If no entry is highlighted, then the search begins at the
start or end depending on the direction you choose.
.I Note: the search does not wrap. It will go to either end then stop until the
.I opposite direction search is requested.
.PP
To browse for files to fax, select "Browse for files to FAX" under the "File" 
pulldown menu. This will popup a window with the current directory contents.
Clicking the left mouse button on a directory will move you there. Clicking the
left mouse button on a non-directory entry will load the file into the 
"Documents to FAX" section. 
To remove a selected file to fax, click the left mouse button on it. This
will popup a menu with two choices: "Edit file" and "Remove from List".
Select the latter to remove the file from the "Documents to FAX" list. If
you need to edit the file, select "Edit file". This will execute the edit
command specified in the .tkhylafaxrc file or on the command line. The
edit command 
.B MUST
always take a complete file name as its 
.B LAST
argument. A sample editor command is given in .tkhylafaxrc.sample in this
distribution.
.PP
To select a specific file for faxing, select "Enter file to FAX" under the
"File" pulldown menu. This will popup an entry dialog box that will allow
you to enter a pathname to any file that you want to fax. Press "Ok" to
enter this file into the "Documents to FAX" list.
.PP
To generate a batch job to fax, select "Add to Batch" in the popup menu
when choosing a destination from the fax numbers window (see above). This
entry will be entered into the "Batch Recipients" window if it exists. You
can bring this window up by selecting "View Batch" under the "File"
pulldown menu. It is not necessary for this window to exist to create a 
batch job. Its just convenient to see what you've selected. Once you have 
selected all the destinations for a batch, select
"Send Batch" under the "File" pulldown menu. Each destination should be loaded
into the cover sheet information section as it is processed. Additionally,
if the "Batch Recipients" window exists, it should be updated after each
destination is processed. If there are destinations you don't want to send
a fax to, click the left mouse button over the entry in the 
"Batch Recipients" window to highlight that destination. Then push the
.I remove 
button. The entry will be removed from the list. To remove all 
the entries from the "Batch Recipients" window, push the
.I clear 
button. Do this to start with a fresh batch of recipients. The
.I alias
button is used to tag a list of recipients and save them as a group. Once you
are satisfied with your batch list, push 
.I alias
to get a dialog box that requests a name for this batch. Once saved, a batch
can be recalled at anytime by selecting the "Select a Batch" choice under
the "Phone" pulldown menu. Note: if a batch is selected it is 
.I added
to the existing batch destinations, it does NOT replace them. If you want
only the destinations in the batch, clear the current entries first (via
the clear button or from the choice "Clear Batch" under the "Phone" phone
pulldown menu.)
.PP
To view the server status select "Display Server Status" under the "File"
pulldown menu. This will popup a window with the current 
.I HylaFax 
server status. If there are any jobs pending that you wish to remove from the
queue, simply click the left mouse button over the entry you desire to remove.
.PP
If you wish to preview the cover page, select "Preview Cover Page" under the
"File" pulldown menu. This will start a 
.I ghostview
program to view the cover page.
.PP
A new feature is the row of buttons along the bottom of the main window. These
buttons are for quick access to important functions. The
.I send
button, initiates a fax transmission. It will determine if the transmission
type is a batch or a single destination.  If there is a batch defined 
.I and 
there is cover sheet information filled in, a dialog box will ask you which 
destination to use. You may select either one or both.
The 
.I browser
button starts the directory browser to select files to fax. The
.I rolodex
button will show the current fax numbers in the database. The
.I add current
button will insert the current values in the cover sheet information section 
into the fax numbers database. The
.I select batch
button, allows the user to choose previously defined batches.
Another new feature, is the automatic detection of a cover sheet only fax
transmission. If
.I tkhylafax
does not find any files to fax in the "Documents to FAX" section, then a dialog
box will pop up asking the user to confirm that only the cover sheet be sent.
.PP
.SH NEW
A new option has been added to tkhylafax called
.I coverPageDirs.
This option specifies a colon separated list of directories to search for 
alternate cover pages. Only valid 
.I Postscript 
files are considered. 
The list of alternates found by 
.I tkhylafax
will be listed under the 
.I Options
pulldown menu. Note that 
.I No Cover Page
is also a choice. However, hylafax will use the environment variable
.I FAXCOVER
whenever more than just a cover page is sent. So, this option is only valid for
cover sheet only transmissions.
.SH OPTIONS
.PP
.IB -faxResolution.
Can be either 
.I high 
or 
.I low.
High tells hylafax to use 196 lines/inch. Low says use 98 lines/inch
.PP
.IB -notifyOnCompletion.
Can be either
.I yes
or
.I no.
Indicates user wants e-mail when fax transmission is complete.
.PP
.IB -notifyOnRetry.
Can be either
.I yes
or
.I no.
Indicates user wants e-mail when fax transmission is retried.
.PP
.IB -initiatePoll.
Can be either
.I yes
or
.I no.
Indicates user wants to initiate a poll upon submtting a fax job. See
hylafax documentation for more details.
.PP
.IB -coverPage.
Can be either
.I yes
or
.I no.
A "yes" means create and send a cover page. "No" means a cover page is ALREADY
included with the files to fax.
.PP
.IB -editorCmd.
See restrictions mentioned above. An example, "xterm -e vi" would start an 
xterm, and pop the user into vi to edit the selected file.
.PP
.IB -coverPageDirs.
See the 
. NEW 
section above.
.SH FILES
.PP
The file associated with the fax number database given by the environment
variable 
.IR FAXNUMBERS.
.PP
The file associated with the batch alias database given by the environment
variable 
.IR FAXALIASES.
Note: The batch alias database looks at the fax number database to translate
batch aliases into real fax destinations. Therefore, two unrelated alias
and fax databases WILL NOT WORK together.
.PP
.IR $HOME/.tkhylafaxrc.  
This is the user's default options file. The contents are in option=value
format. The currently recognized options are those options described in the
OPTIONS section of this man page and the ones at the end of this section. 
For example, a legal line in this file would be ``faxResolution=high''. A ``#'' 
in the first column of any line is treated as a comment. A sample .tkhylafaxrc 
file is included in this distribution.
.PP
.IB commentLines.
The total number of comment lines to create in the cover sheet section. Each
line is 40 characters. The default is 4 comment lines.
.PP
.IB phoneFieldLen.
The length of the fax phone number field in the cover sheet section. The 
default is 20 characters.
.SH "SEE ALSO"
sendfax(1),
faxstat(1),
and
faxrm(1)
.SH BUGS
If there are any bugs, report them to 
.I andy@wx.gtegsc.com. 
Comments and patches are also accepted.
If you send a patch, please, send a context diff patch.
.SH ACKNOWLEDGEMENTS
mike@cs.UMD.EDU (Mike Steele), 
rich@id.slip.bcm.tmc.edu (Rich Murphey),
Adam-Stauffer@deshaw.com (Adam Stauffer),
Pekka.Kytolaakso@csc.fi,
raymond@es.ele.tue.nl (Raymond Nijssen),
rbsmith@sandia.gov (Randall Smith),
joe@morton.rain.com (Joe V. Moss),
todorov@cui.unige.ch (Krassimir Todorov)
and others whose names I forgot...
