//  Copyright 1999 McMillan Enterprises, Inc. -- www.mcmillan-inc.com
//  Copyright (C) 1999 Jean-Claude Wippler.  All rights reserved.
//
//  RowRef class implementation

#include <PWOSequence.h>
#include <PWONumber.h>
#include "PyRowRef.h"
#include "PyView.h"

static PyMethodDef RowRefMethods[] = {
	{0, 0, 0, 0}
};

static void PyRowRef_dealloc(PyRowRef *o) {
	//o->~PyRowRef();
	delete o;
}

static int PyRowRef_print(PyRowRef *o, FILE *f, int) {
	fprintf(f, "<PyRowRef object at %x>", (int)o);
	return 0;
}

static PyObject* PyRowRef_getattr(PyRowRef *o, char *nm) {
	try {
		PyObject* attr = o->getPropertyValue(nm);
		if (attr)
			return attr;
	}
	catch(PWException e) {
		return e.toPython();
	}
	return Py_FindMethod(RowRefMethods, (PyObject* )o, nm);
}

static int PyRowRef_setattr(PyRowRef *o, char *nm, PyObject* v) {
    try {
        PyProperty *p = o->getProperty(nm);
        if (p) {
            if (v)
                PyRowRef::setFromPython(*o, *p, v);
            else 
                PyRowRef::setDefault(*o, *p);
            Py_DECREF(p);
            return 0;
        }
		PyErr_SetString(PyExc_AttributeError, "delete of non-existing attribute");
		return -1;
	}
	catch(PWException e) {
		e.toPython();
		return -1;
	}
}
PyTypeObject PyRowReftype = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"PyRowRef",
	sizeof(PyRowRef),
	0,
	(destructor)PyRowRef_dealloc, /*tp_dealloc*/
	(printfunc)PyRowRef_print, /*tp_print*/
	(getattrfunc)PyRowRef_getattr, /*tp_getattr*/
	(setattrfunc)PyRowRef_setattr,		/*tp_setattr*/
	(cmpfunc)0, /*tp_compare*/
	(reprfunc)0, /*tp_repr*/
	0,		/*tp_as_number*/
	0,	/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
};

PyRowRef::PyRowRef(const c4_RowRef& o, PyView *owner)
  : PyHead (PyRowReftype), c4_RowRef(o) {
}

void PyRowRef::setFromPython(const c4_RowRef& row, const c4_Property& prop, PyObject* attr) {
	switch (prop.Type()) {
		case 'I':   
			if (PyInt_Check(attr))
				((const c4_IntProp&) prop) (row) = PyInt_AS_LONG(attr);
			break;
		case 'F':   
			if (PyFloat_Check(attr))
				((const c4_FloatProp&) prop) (row) = PyFloat_AS_DOUBLE(attr);
			break;
		 case 'D':   
			 if (PyFloat_Check(attr))
				((const c4_DoubleProp&) prop) (row) = PyFloat_AS_DOUBLE(attr);
			 break;
		case 'S': 
			 if (PyString_Check(attr)) {
				c4_Bytes temp (PyString_AS_STRING(attr), PyString_GET_SIZE(attr) + 1, false);
				prop (row).SetData(temp);
			}
			break;
		case 'V':	
			if (PyView_Check(attr)) {
				PyView *obj = (PyView*)attr;
				((const c4_ViewProp&) prop)(row) = *obj;
			}
			else {	
				((const c4_ViewProp&) prop) (row) = c4_View ();
				PyView tmp(((const c4_ViewProp&) prop)(row));
				PWOSequence lst(attr);
				tmp.SetSize(lst.len());
				for (int i=0; i<lst.len(); i++)
				{
					PyObject* entry = lst[i];
					tmp.setItem(i, entry);
					Py_DECREF(entry);
				}
			}
			break;
		case 'B':
		case 'M':   
			if (PyString_Check(attr)) {
				c4_Bytes temp (PyString_AS_STRING(attr), PyString_GET_SIZE(attr), false);
				prop (row).SetData(temp);
			}
	}
}

void PyRowRef::setDefault(const c4_RowRef& row, const c4_Property& prop) {
	switch (prop.Type()) {
		case 'I':
			((const c4_IntProp&) prop) (row) = 0;
			break;
		case 'F': 
			((const c4_FloatProp&) prop) (row) = 0.0;
			break;
		 case 'D':
			 ((const c4_DoubleProp&) prop) (row) = 0.0;
			 break;
		case 'S':
			((const c4_StringProp&) prop) (row) = "";
			break;
		case 'V':	
			((const c4_ViewProp&) prop) (row) = c4_View ();
			break;
		case 'B':
		case 'M':
			{
				c4_Bytes temp;
				prop (row).SetData(temp);
			}
	}
}

PyObject* PyRowRef::asPython(const c4_Property& prop) {
	switch (prop.Type()) {
	case 'I': {
		PWONumber rslt(((const c4_IntProp&)prop)(*this));
		return rslt.disOwn();
			  }
	case 'F': {
		PWONumber rslt(((const c4_FloatProp&)prop)(*this));
		return rslt.disOwn();
			  }
	case 'D': {
		PWONumber rslt(((const c4_DoubleProp&)prop)(*this));
		return rslt.disOwn();
			  }
	case 'S': {
		//c4_String tmp = ((c4_StringProp&)prop).Get(*this);
		PWOString rslt(((c4_StringProp&)prop).Get(*this));
		return rslt.disOwn();
			  }
	case 'V': {
		return new PyView(((const c4_ViewProp&)prop)(*this));
			  }
	case 'B':
	case 'M': {
		c4_Bytes temp;
		prop (*this).GetData(temp);
		PWOString rslt((const char*)temp.Contents(), temp.Size());
		return rslt.disOwn();
			  }
	}
	return 0;
}