//  Copyright 1999 McMillan Enterprises, Inc. -- www.mcmillan-inc.com
//  Copyright (C) 1999 Jean-Claude Wippler.  All rights reserved.
//
//  RowRef class header

#if !defined INCLUDE_PYROWREF_H
#define INCLUDE_PYROWREF_H

#include <mk4.h>
#include "PyHead.h"
#include <PWOSequence.h>
#include "PyView.h"
#include "PyProperty.h"

#define PyRowRef_Check(ob) ((ob)->ob_type == &PyRowReftype)

extern PyTypeObject PyRowReftype;

class PyRowRef : public PyHead, public c4_RowRef {
public:
	//PyRowRef();
	PyRowRef(const c4_RowRef& o, PyView *owner=0);
	//PyRowRef(c4_Row row);
    ~PyRowRef() { }
	PyProperty *getProperty(char *nm) {
		c4_View cntr = Container();
		int ndx = cntr.FindPropIndexByName(nm);
		if (ndx > -1) {
			return new PyProperty(cntr.NthProperty(ndx));
		}
		return 0;
	};

	PyObject* getPropertyValue(char *nm) {
		PyProperty *prop = getProperty(nm);
		if (prop)
		{
			PyObject* result = asPython(*prop);
			Py_DECREF(prop);
			return result;
		}
		return 0;
	};

	static void setFromPython(const c4_RowRef& row, const c4_Property& prop, PyObject* val);
	static void setDefault(const c4_RowRef& row, const c4_Property& prop);
	PyObject* asPython(const c4_Property& prop);
};

#endif