//	Copyright 1999 McMillan Enterprises, Inc. -- www.mcmillan-inc.com
//  Copyright (C) 1999 Jean-Claude Wippler.  All rights reserved.
//
//  View class header

#if !defined INCLUDE_PYVIEW_H
#define INCLUDE_PYVIEW_H

#include <mk4.h>
#include <PWOSequence.h>
#include "PyHead.h"

#define PyView_Check(v) ((v)->ob_type==&PyViewtype)

class PyView;
class PyRowRef;

extern PyTypeObject PyViewtype;

class PyView : public PyHead, public c4_View {
	PyView *_base;
public:
	PyView();
	PyView(const c4_View& o, PyView *owner=0);
	~PyView() {}
	void insertAt(int i, PyObject* o);
	PyRowRef *getItem(int i);
	PyView *getSlice(int s, int e);
	int setItem(int i, const c4_RowRef& v) {
		if (i < 0)
			i += GetSize();
		if (i > GetSize() || i < 0)
			throw PWException(PyExc_IndexError, "Index out of range");
		SetAt(i, v);
		return 0;
	};
	int setItem(int i, PyObject* v);
	int addProperties(const PWOSequence& lst);
	int setSlice(int s, int e, const PWOSequence& lst);
	PyObject* structure();
	c4_Row& makeRow(c4_Row& temp, PyObject* o, bool useDefaults=true);
};

PyObject* PyView_new(PyObject* o, PyObject* _args);

#endif