//  Copyright (C) 1996-1999 Jean-Claude Wippler.  All rights reserved.
//
//	Regression test program, custom biew tests

#include "regress.h"

/////////////////////////////////////////////////////////////////////////////

void TestCustom2()
{
	B(c11, Unique operation, 0);
	{
		c4_IntProp p1 ("p1"), p2 ("p2");

		c4_View v1, v2, v3;

		v1.Add(p1 [1] + p2 [11]);
		v1.Add(p1 [1] + p2 [22]);
		v1.Add(p1 [2] + p2 [33]);
		v1.Add(p1 [2] + p2 [33]);
		v1.Add(p1 [3] + p2 [44]);
		v1.Add(p1 [4] + p2 [55]);
		v1.Add(p1 [4] + p2 [55]);
		v1.Add(p1 [4] + p2 [55]);

		v2 = v1.Unique();
			A(v2.GetSize() == 5);
			A(p1 (v2[0]) == 1);
			A(p1 (v2[1]) == 1);
			A(p1 (v2[2]) == 2);
			A(p1 (v2[3]) == 3);
			A(p1 (v2[4]) == 4);

			A(p2 (v2[0]) == 11);
			A(p2 (v2[1]) == 22);
			A(p2 (v2[2]) == 33);
			A(p2 (v2[3]) == 44);
			A(p2 (v2[4]) == 55);

	} E;

	B(c12, Union operation, 0)
	{
		c4_IntProp p1 ("p1");

		c4_View v1, v2, v3;

		v1.Add(p1 [1]);
		v1.Add(p1 [2]);
		v1.Add(p1 [3]);

		v2.Add(p1 [2]);
		v2.Add(p1 [3]);
		v2.Add(p1 [4]);
		v2.Add(p1 [5]);

		v3 = v1.Union(v2);
			A(v3.GetSize() == 5);
			A(p1 (v3[0]) == 1);
			A(p1 (v3[1]) == 2);
			A(p1 (v3[2]) == 3);
			A(p1 (v3[3]) == 4);
			A(p1 (v3[4]) == 5);
	} E;

	B(c13, Intersect operation, 0)
	{
		c4_IntProp p1 ("p1");

		c4_View v1, v2, v3;

		v1.Add(p1 [1]);
		v1.Add(p1 [2]);
		v1.Add(p1 [3]);

		v2.Add(p1 [2]);
		v2.Add(p1 [3]);
		v2.Add(p1 [4]);
		v2.Add(p1 [5]);

		v3 = v1.Intersect(v2);
			A(v3.GetSize() == 2);
			A(p1 (v3[0]) == 2);
			A(p1 (v3[1]) == 3);
	} E;

	B(c14, Different operation, 0)
	{
		c4_IntProp p1 ("p1");

		c4_View v1, v2, v3;

		v1.Add(p1 [1]);
		v1.Add(p1 [2]);
		v1.Add(p1 [3]);

		v2.Add(p1 [2]);
		v2.Add(p1 [3]);
		v2.Add(p1 [4]);
		v2.Add(p1 [5]);

		v3 = v1.Different(v2);
			A(v3.GetSize() == 3);
			A(p1 (v3[0]) == 1);
			A(p1 (v3[1]) == 4);
			A(p1 (v3[2]) == 5);
	} E;

	B(c15, Minus operation, 0)
	{
		c4_IntProp p1 ("p1");

		c4_View v1, v2, v3;

		v1.Add(p1 [1]);
		v1.Add(p1 [2]);
		v1.Add(p1 [3]);

		v2.Add(p1 [2]);
		v2.Add(p1 [3]);
		v2.Add(p1 [4]);
		v2.Add(p1 [5]);

		v3 = v1.Minus(v2);
			A(v3.GetSize() == 1);
			A(p1 (v3[0]) == 1);
	} E;

	B(c16, View comparisons, 0)
	{
		c4_IntProp p1 ("p1");

		c4_View v1;
		v1.Add(p1 [1]);
		v1.Add(p1 [2]);
		v1.Add(p1 [3]);
		v1.Add(p1 [4]);
		v1.Add(p1 [5]);

			A(v1 == v1);
			A(v1 == v1.Slice(0));
			A(v1.Slice(0,2) < v1.Slice(0,3));
			A(v1.Slice(0,3) == v1.Slice(0,3));
			A(v1.Slice(0,4) > v1.Slice(0,3));
			A(v1.Slice(0,3) < v1.Slice(1,3));
			A(v1.Slice(0,3) < v1.Slice(1,4));
			A(v1.Slice(1,3) > v1.Slice(0,3));
			A(v1.Slice(1,4) > v1.Slice(0,3));
	} E;

	B(c17, Join operation, 0)
	{
		c4_StringProp p1 ("p1"), p2 ("p2");
		c4_IntProp p3 ("p3");

		c4_View v1, v2, v3;

		v1.Add(p1 [""]);
		v1.Add(p1 ["1"] + p2 ["a"]);
		v1.Add(p1 ["12"] + p2 ["ab"]);
		v1.Add(p1 ["123"] + p2 ["abc"]);

		v2.Add(p1 ["1"] + p3 [1]);
		v2.Add(p1 ["12"] + p3 [1]);
		v2.Add(p1 ["12"] + p3 [2]);
		v2.Add(p1 ["123"] + p3 [1]);
		v2.Add(p1 ["123"] + p3 [2]);
		v2.Add(p1 ["123"] + p3 [3]);

		v3 = v1.Join(p1, v2);			// inner join
			A(v3.GetSize() == 6);

			A(p1 (v3[0]) == (c4_String) "1");
			A(p1 (v3[1]) == (c4_String) "12");
			A(p1 (v3[2]) == (c4_String) "12");
			A(p1 (v3[3]) == (c4_String) "123");
			A(p1 (v3[4]) == (c4_String) "123");
			A(p1 (v3[5]) == (c4_String) "123");

			A(p2 (v3[0]) == (c4_String) "a");
			A(p2 (v3[1]) == (c4_String) "ab");
			A(p2 (v3[2]) == (c4_String) "ab");
			A(p2 (v3[3]) == (c4_String) "abc");
			A(p2 (v3[4]) == (c4_String) "abc");
			A(p2 (v3[5]) == (c4_String) "abc");

			A(p3 (v3[0]) == 1);
			A(p3 (v3[1]) == 1);
			A(p3 (v3[2]) == 2);
			A(p3 (v3[3]) == 1);
			A(p3 (v3[4]) == 2);
			A(p3 (v3[5]) == 3);

		v3 = v1.Join(p1, v2, true); 	// outer join
			A(v3.GetSize() == 7);

			A(p1 (v3[0]) == (c4_String) "");
			A(p1 (v3[1]) == (c4_String) "1");
			A(p1 (v3[2]) == (c4_String) "12");
			A(p1 (v3[3]) == (c4_String) "12");
			A(p1 (v3[4]) == (c4_String) "123");
			A(p1 (v3[5]) == (c4_String) "123");
			A(p1 (v3[6]) == (c4_String) "123");

			A(p2 (v3[0]) == (c4_String) "");
			A(p2 (v3[1]) == (c4_String) "a");
			A(p2 (v3[2]) == (c4_String) "ab");
			A(p2 (v3[3]) == (c4_String) "ab");
			A(p2 (v3[4]) == (c4_String) "abc");
			A(p2 (v3[5]) == (c4_String) "abc");
			A(p2 (v3[6]) == (c4_String) "abc");

			A(p3 (v3[0]) == 0);
			A(p3 (v3[1]) == 1);
			A(p3 (v3[2]) == 1);
			A(p3 (v3[3]) == 2);
			A(p3 (v3[4]) == 1);
			A(p3 (v3[5]) == 2);
			A(p3 (v3[6]) == 3);
	} E;

	B(c18, Groupby sort fix, 0) // fails in 1.8.4 (from P. Ritter, 14-10-1998)
	{
		c4_StringProp p1 ("Country");
		c4_StringProp p2 ("City");
		c4_ViewProp p3 ("SubList");

		c4_View v1, v2, v3;

		v1.Add(p1 ["US"]   + p2 ["Philadelphia"]);
		v1.Add(p1 ["France"]   + p2 ["Bordeaux"]);
		v1.Add(p1 ["US"]   + p2 ["Miami"]);
		v1.Add(p1 ["France"]   + p2 ["Paris"]);
		v1.Add(p1 ["US"]   + p2 ["Boston"]);
		v1.Add(p1 ["France"]   + p2 ["Nice"]);
		v1.Add(p1 ["US"]   + p2 ["NY"]);
		v1.Add(p1 ["US"]   + p2 ["Miami"]);

		v2 = v1.GroupBy(p1, p3);
			A(v2.GetSize() == 2);
			A(p1 (v2[0]) == (c4_String) "France");
			A(p1 (v2[1]) == (c4_String) "US");

		v3 = p3 (v2[0]);
			A(v3.GetSize() == 3);
			A(p2 (v3[0]) == (c4_String) "Bordeaux");
			A(p2 (v3[1]) == (c4_String) "Nice");
			A(p2 (v3[2]) == (c4_String) "Paris");
		v3 = p3 (v2[1]);
			A(v3.GetSize() == 5);
			A(p2 (v3[0]) == (c4_String) "Boston");
			A(p2 (v3[1]) == (c4_String) "Miami");
			A(p2 (v3[2]) == (c4_String) "Miami");
			A(p2 (v3[3]) == (c4_String) "NY");
			A(p2 (v3[4]) == (c4_String) "Philadelphia");
	} E;

	B(c19, JoinProp operation, 0) // moved, used to also be called c15
	{
		c4_StringProp p1 ("p1");
		c4_ViewProp p2 ("p2");
		c4_IntProp p3 ("p3");

		c4_View v1, v2a, v2b, v2c, v3;

		v2a.Add(p3 [1]);
		v2a.Add(p3 [2]);
		v2a.Add(p3 [3]);
		v1.Add(p1 ["123"] + p2 [v2a]);

		v2b.Add(p3 [1]);
		v2b.Add(p3 [2]);
		v1.Add(p1 ["12"] + p2 [v2b]);

		v2c.Add(p3 [1]);
		v1.Add(p1 ["1"] + p2 [v2c]);

		v1.Add(p1 [""]);

		v3 = v1.JoinProp(p2);			// inner join
			A(v3.GetSize() == 6);

			A(p1 (v3[0]) == (c4_String) "123");
			A(p1 (v3[1]) == (c4_String) "123");
			A(p1 (v3[2]) == (c4_String) "123");
			A(p1 (v3[3]) == (c4_String) "12");
			A(p1 (v3[4]) == (c4_String) "12");
			A(p1 (v3[5]) == (c4_String) "1");

			A(p3 (v3[0]) == 1);
			A(p3 (v3[1]) == 2);
			A(p3 (v3[2]) == 3);
			A(p3 (v3[3]) == 1);
			A(p3 (v3[4]) == 2);
			A(p3 (v3[5]) == 1);

		v3 = v1.JoinProp(p2, true); 	// outer join
			A(v3.GetSize() == 7);

			A(p1 (v3[0]) == (c4_String) "123");
			A(p1 (v3[1]) == (c4_String) "123");
			A(p1 (v3[2]) == (c4_String) "123");
			A(p1 (v3[3]) == (c4_String) "12");
			A(p1 (v3[4]) == (c4_String) "12");
			A(p1 (v3[5]) == (c4_String) "1");
			A(p1 (v3[6]) == (c4_String) "");

			A(p3 (v3[0]) == 1);
			A(p3 (v3[1]) == 2);
			A(p3 (v3[2]) == 3);
			A(p3 (v3[3]) == 1);
			A(p3 (v3[4]) == 2);
			A(p3 (v3[5]) == 1);
			A(p3 (v3[6]) == 0);
	} E;
}

/////////////////////////////////////////////////////////////////////////////
