#!./tclndbm

#
# open
#

proc open {name} {
    return [ndbm open $name rwc] ;
}


#
# create 1000 entries
#

proc create {db} {

    for {set i 0} {$i < 1000} {incr i} {
	ndbm store $db $i "This data for $i" ;
    }
}

 
#
# read all entries
#

proc read1 {db} {

    set key [ndbm firstkey $db] ;
    set i 0 ;

    while {$key != ""} {
	set data [ndbm fetch $db $key] ;
	incr i;
	set key [ndbm nextkey $db $key] ;
	
    }
}


#
# read all entries using ndbm list
#

proc read2 {db} {

    set keys [ndbm list $db] ;
    set i 0 ;

    foreach key $keys {
	set data [ndbm fetch $db $key] ;
	# puts stdout "$i $key - $data";
	incr i;
    }
}

#
# delete 10 percent of all entries
#

proc delete {db} {
    for {set i 0} {$i < 1000} {incr i 3} {
	ndbm delete $db $i ;
    }
}

#
# close
#

proc close {db} {
	ndbm close $db
}

##
## main
##

puts "open: \t\t[time {set db [open torture.ndbm]}]" ;
puts "create: \t[time {create $db}]" ;
puts "read1: \t\t[time {read1 $db}]" ;
puts "read2: \t\t[time {read2 $db}]" ;
puts "delete: \t[time {delete $db}]" ;
puts "close: \t\t[time {close $db}]" ;
