#
# $Header: /home/rockware/cvs-main/operator/tcl/opControl.tcl,v 1.31 1995/03/16 12:43:19 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
#  1. Control Window(s) Support function(s).

# *** later version should define each group as itcl_class !
# When the program erase a file it should send a message to any widow
# that should be updated.
# *** send update command to the selection owner.

itcl_class OpControl {
    inherit OpTopLevel

    constructor config {
        if {$from_create != 1} "puts {Control window can be created only by calling the create proc} ; $this delete"
        incr from_create
        set tmp_menus "$tl_menus $ctrl_menus"
        OpTopLevel::constructor \
            -name "Operator Main Control" \
            -title "Operator control" \
            -iconname Operator \
            -iconbitmap rocket \
            -pack_option 7 \
            -balloon_help "Operator Main Control Window" \
            -buttons $ctrl_buttons -menus $tmp_menus -menu_bar $ctrl_menubar

        bind $this <Destroy> "+after 100 {destroy .}"

        # in the work space there is the Scrolling Canvas and Active help entry and maybe more.
        frame $work_space.i
        ::pack $work_space.i -expand on -fill both
        OpSCanvas :: create $work_space.i
        set canvas $work_space.i.u.c
    }
    destructor {
    }
    method config config {}

    method add {type label cmd} {
        if {"$type" == {} || "$label" == {}} {
            puts "can't add type: '$type' title: '$label', at least one is empty !"
            return
        }
        if ![::info exists items($type)] {
            # Create a new colomn or row, in the canvas.
            set items($type) ok
            if {$grouping == "row"} {
                # new row
                set b [$canvas bbox all]
                if {$b == {}} {set b {0 0 0 0}}
                set new_y [expr [lindex $b 3] + 4]
                set items($type,Y) $new_y
                $canvas create icon 0 $new_y -text $type -bo 1 -tags "$type"
            } {
                # new col
                set b [$canvas bbox all]
                if {$b == {}} {set b {0 0 0 0}}
                set new_x [expr [lindex $b 2] + 4]
                set items($type,X) $new_x
                $canvas create icon $new_x 0 -text $type -bo 1 -tags "$type"
            }
        }
        set b [$canvas bbox $type]
        if {$b == {}} {set b {0 0 0 0}}
        if {$grouping == "row"} {
            set items($type,$label) [$canvas create icon [expr [lindex $b 2] + 4] [lindex $b 1] -text $label -tags "$type $label" -command $cmd -bo 1]
        } {
            set items($type,$label) [$canvas create icon [lindex $b 0] [expr [lindex $b 3] + 4] -text $label -tags "$type $label" -command $cmd -bo 1]
        }
        $canvas bind $items($type,$label) <Double-1> $cmd
        # set b [$canvas bbox all]
        # set b "[expr [lindex $b 0]-10] [expr [lindex $b 1]-10] [expr [lindex $b 2]+10] [expr [lindex $b 3]+10]"
        # $canvas configure -scrollregion $b
        OpSCanvas :: update $work_space.i
    }
    method remove {type label} {
        if [::info exists items($type,$label)] {
            $canvas delete $items($type,$label)
            unset items($type,$label)
            if {$grouping == "row"} {
                set x 0
                foreach i [$canvas find withtag $type] {
                    $canvas itemconfig $i -x $x
                    set x [expr [lindex [$canvas bbox $i] 2] + 4]
                }
            } {
                set y 0
                foreach i [$canvas find withtag $type] {
                    $canvas itemconfig $i -y $y
                    set y [expr [lindex [$canvas bbox $i] 3] + 4]
                }
            }
        }
        # set b [$canvas bbox all]
        # set b "[expr [lindex $b 0]-10] [expr [lindex $b 1]-10] [expr [lindex $b 2]+10] [expr [lindex $b 3]+10]"
        # $can configure -scrollregion $b
        OpSCanvas :: update $work_space.i
    }
    method label_update {type o_label n_label} {
        if [::info exists items($type,$o_label)] {
            $canvas itemconfig $items($type,$o_label) -text $n_label
            set items($type,$n_label) $items($type,$o_label)
            if {$o_label != $n_label} {
                unset items($type,$o_label)
            }
            if {$grouping == "row"} {
                set x 0
                foreach i [$canvas find withtag $type] {
                    $canvas itemconfig $i -x $x
                    set x [expr [lindex [$canvas bbox $i] 2] + 4]
                }
            } {
                set y 0
                foreach i [$canvas find withtag $type] {
                    $canvas itemconfig $i -y $y
                    set y [expr [lindex [$canvas bbox $i] 3] + 4]
                }
            }
        }
        OpSCanvas :: update $work_space.i
    }

    method type2icon {} {}  ; # return the iconbitmap name
    method help_on {} {}
    method help_off {} {}
    method help_push {w msg} {}
    method help_pop {w} {}
    method get_tl_menus {} {return $tl_menus}
    proc create {} {
        if {$from_create != 0} {puts {OpControl::creat: Can't create more then one control instance}; return}
        incr from_create
        OpControl .control
        set OPControl .contrl
    }
    # The grouping {row | col} define the direction of a group.
    public grouping row { # don't change. }
    protected ctrl_buttons {
        {Quit . {.confirmQuit on} {} {Quit from Operator} {Quit from Operator}}
        {View . {.fileSelect on -message {Please enter directory name for the new Directory View} -command {if {{%1$s}=={}} {OpDirView :: open ~} {OpDirView :: open %1$s}}}
        treasure {open Directory View} {Open directory View window}}
        {Tree . {.fileSelect on -message {Please enter directory name for the new Directory Tree} -command {if {{%1$s}=={}} {OpDirTree :: open ~} {OpDirTree :: open %1$s}}}
        tree {open directory Tree window} {Open directory Tree window}}
        {X-Term .
        {set swd [pwd] ; cd ~ ; OpXTerm :: new ; cd $swd}
        xterm {Open Xterm} {Create xterm windows at the current directory}}
    }
    protected ctrl_menus {
        {ctrl_file {
            {label -label Print -underline 0 -command {opDialogPrint [opSelectionGet]}}
            {separator}
            {command -label {Send Mail} -underline 0 -command {OpSendMail .send_mail}}
            {separator}
            {command -label Exit -underline 1 -command {.confirmQuit on}}}
        }
        {ctrl_edit {
            {command -label Copy  -underline 0 -command {opDialogCopy [opSelectionGet]}}}
        }
        {ctrl_opt {
            {label -label {Edit Options...} -underline 0 -command {OpCascadeOption :: edit}}
            {command -label {Directories} -underline 0 -command { opEntriesMenu .dirDialog Directories {{{Scripts:} HomeDir}}}}
            {command -label {Edit Files Actions} -underline 0 -command {opFilesActionsEdit}}
            {label -label {Edit key binging} -underline 0}
            {label -label {Colors} -underline 0}
            {command -label {Variables} -underline 0 -command opDialogGlobals}
            {separator}
            {label -label {Load Opt.} -underline 0}
            {label -label {Save Opt.} -underline 0}}
        }
    }
    protected ctrl_menubar {{File 0 ctrl_file} {Option 0 ctrl_opt} {Windows 0 tl_wins} {Help 0 tl_help right}}
    # the name of our canvas.
    protected canvas {}
    # items array
    # set items($typeA) {typeA_1 typeA_2 ...}
    # set items($typeB) {typeB_1 typeB_2 ...}
    # set items($type,$title) item_id
    # set items($type,X) - the common coordination for all the group items.
    # set items($type,Y)
    protected items
    common from_create 0
}
# End of opControl.tcl.
