#
# $Header: /home/rockware/cvs-main/operator/tcl/opTools.tcl,v 1.18 1995/03/16 12:43:22 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
# 14. General library functions.
#
# Print canvas on a matrix of pages.
# return the names of the files that were created.
# print on letter pages '275mm X 210mm'.
# The phy_ variables are set in portrait mode.
# The files are named according to file_name-xpage-ypage

proc opCanvasPrint {c fname {id 0} {xpages 1} {ypages 1} {rotate {}}} {
    if {"[winfo class $c]" != "Canvas"} return
    set phy_height 270
    set phy_width 205
    set b [$c bbox all]
    set b "[expr [lindex $b 0]-10] [expr [lindex $b 1]-10] [expr [lindex $b 2]+10] [expr [lindex $b 3]+10]"
    set xrange [expr [lindex $b 2] - [lindex $b 0]]
    set yrange [expr [lindex $b 3] - [lindex $b 1]]
    set dx [expr $xrange / $xpages]
    set dy [expr $yrange / $ypages]
    if {"$rotate" == {}} {
        if {$dx > $dy} {set rotate true} {set rotate false}
    }
    if {"$rotate" == "true"} {
        if [expr ($dy / $dx) > ($phy_width / $phy_height)] {
            set page_limit "-pageheight 205m"
        } {
            set page_limit "-pagewidth 270m"
        }
    } {
        if [expr ($dy / $dx) > ($phy_height / $phy_width)] {
            set page_limit "-pageheight 270m"
        } {
            set page_limit "-pagewidth 205m"
        }
    }
    set files {}
    for {set i 0} {$i < $ypages} {incr i} {
        for {set j 0} {$j < $xpages} {incr j} {
            if $id {
                $c create text [expr $j * $dx +10] [expr ($i + 1) * $dy - 20] \
                    -text "page [expr $j+1]/[expr $i+1] of $xpages/$ypages" \
                    -tag page-title -anchor nw
            }
            # find Fonts that can be translated to postscript. -font 7x14
            # *** add the starting point to the x/y.
            # upper left corner of the bbox
            set file $fname-$j-$i.ps
            lappend files $file
            # The update make sure that the canvas postscript file will contain
            # all the elements from the canvas.
            update
            eval $c postscript -file $file \
                -x [expr $j * $dx] \
                -y [expr $i * $dy] \
                -width $dx \
                -height $dy \
                $page_limit \
                -rotate $rotate
            if $id {$c delete page-title}
        }
    }
    return $files
}
proc opLabeledEntry {w lbl var width {orient horizontal}} {
    frame $w -relief flat
    bind $w <Enter> "focus $w.entry"
    label $w.label -text $lbl -bd 1 -relief flat
    if {$var != {}} {
        entry $w.entry -width $width -textvariable $var -relief sunken
    } {
        entry $w.entry -width $width -relief sunken
    }
    if {"$orient"=="vertical"} {
        pack $w -fill both -pady 2 -padx 2
        pack $w.label -side top
        pack $w.entry -side bottom
    } {
        pack $w -fill both -pady 2 -padx 2
        pack $w.label -side left
        pack $w.entry -side right
    }
}
proc opNameToFile {name {type any}} {
    if {$name == {}} {
        return {}
    }
    # Do the search by file type.
    if {$type == "prog" || $type == "any"} {
        global OPPath
        foreach d $OPPath {
            if [file isdirectory $d] \
                { if [file exists $d/$name]     {return $d/$name }}
        }
    }
    if {$type == "tcl" || $type == "any"} {
        global OPPathTcl
        foreach d $OPPathTcl {
            if [file isdirectory $d] \
                { if [file exists $d/$name]     {return $d/$name}}
        }
    }
    if {$type == "bitmap" || $type == "any"} {
        global OPPathBitmap
        foreach d $OPPathBitmap {
            if [file isdirectory $d] {
                foreach s {.xpm .xbm .gif {}} {
                    if [file exists $d/$name$s] {
                        return $d/$name$s
                    }
                }
            }
        }
    }
    if {$type == "data" || $type == "any"} {
        global OPPathData
        foreach d $OPPathData {
            if [file isdirectory $d] \
                { if [file exists $d/$name]     {return $d/$name}}
        }
    }
    # for debugging. ***
    # puts "opNameToFile: $name not found, search type $type"
    return {}
}

proc opGetXResource {rsrc class def} {
    set value [option get . $rsrc $class]
    if {$value == {}} {
        return $def
    } {
        return $value
    }    
}

proc opFileEdit f { global OPTextEditor ; exec $OPTextEditor $f & }


