#! /usr/local/bin/tclsh8.0
#
# List the available newsgroups.

source nntp.tcl

# Replace "news" with your news server's host name.

set NewsServer "news"

# Open the NNTP connection.

set nntpHandle [NNTP::Open $NewsServer]

# Get the list of available news groups.

set groupList [NNTP::GetGroupList $nntpHandle]

# Now we can close the connection.

NNTP::Close $nntpHandle

# This array translates post status into a human-readable form.

array set postInfo {
	y	Yes
	n	No
	m	Moderated
	Y	Yes
	N	No
	M	Moderated
}

# Find the length of the longest newsgroup name, and
# generate a sorted list of newsgroups.

set newsgroupList {}
set longest [string length "Newsgroup"]
foreach {grpName x y postStatus} $groupList {
    set l [string length $grpName]
    if {$l > $longest} {
	set longest $l
    }
    lappend newsgroupList [list $grpName $postInfo($postStatus)]
}

set newsgroupList [lsort -dictionary -index 0 $newsgroupList]

# Print out the results. First, print the column headings.

set printFormat [format "%%-%1ds   %%s" $longest]
puts [format $printFormat "Newsgroup" "Post Status"]
puts [format $printFormat "---------" "-----------"]
puts ""

# Print out the newsgroup list.

foreach grp $newsgroupList {
    puts [format $printFormat [lindex $grp 0] [lindex $grp 1]]
}

