#CTCP Handlers
package provide ctcp 1

proc handle_ctcp {orig msg longnick dest} {

#ctcp_message in the form
#level:Command:user:channel:action
	global ctcp_message
	global userlist
	global nick
	set from $longnick
	set list2 ""

	set msg [string trim $msg "\001 "]
	set return $msg
	set found 0	

	scan $msg "%s" command
	set command [string toupper $command]
	set param [string range $msg [string first $command $msg] end ]
        set param [string trimleft $param $command]
        set param [string trimleft $param " :="]

	set ircuser [string tolower $longnick]
	set level [get_level $ircuser]
	
	if [is_on_ignore $longnick "p"] {return}

	foreach ctcp $ctcp_message {
		set ctcplevel [lindex [split $ctcp ":"] 0]
		set ctcpcommand [lindex [split $ctcp ":"] 1]
		set ctcpuser [string tolower [lindex [split $ctcp ":"] 2]]
		set ctcpchannel [string tolower [lindex [split $ctcp ":"] 3]]
		set action [lindex [split $ctcp ":"] 4]
	
		if ![string match $ctcpuser $ircuser] {return}
		if ![string match $ctcpchannel $dest] {return}
	
		if [string match $ctcpuser $ircuser] { 
		if [expr $level >= $ctcplevel] { 

		if ![string compare $ctcpcommand $command] {
			set found 1
			set list [split $action " "]			
			
			foreach element $list {
				if ![string compare "#internal" $element] {
					ctcp_$ctcpcommand $orig $param $dest
					return 1 
				}
				set list2 [linsert $list2 end $element ]
			}
			set element [string trimleft  [join $list2 " "] " "]
			set element [string trimleft  $element " $ctcpcommand"]

			set comlist [split $element ";"]
			foreach x $comlist {
			set command $x
			substitute  $from " " $return
			fake_user_in $command
			}
			return 1
				
		}
		} 
		}





	}

	if !$found { send_to_window server "\[CTCP $command: Unknown CTCP command\]\n" }
}

proc handle_ctcp_reply {orig reply} {

	set reply [string trim $reply "\001"]
	set list [split $reply " "]
	set parm1 [string toupper [lindex $list 0] ]
	set parm2 [lindex $list 1]
	set parm3 [join [lrange $list 1 end] " "]
		
	
	if ![string compare $parm1 "PING"] {
		set ztime [clock seconds]
		if [sNull $parm2] { return }
			if [regexp " \[0-9\]+ " " $parm2 "] {
				set parm3 [expr $ztime - $parm2]
				send_to_window server "\[CTCP PING Reply from $orig\] $parm3 secs.\n"
			} else {
				send_to_window server "\[CTCP $parm1 Reply from $orig\] $parm3 -- TAINTED PING REPLY\n"
			}
		

	} else {
			send_to_window server "\[CTCP $parm1 Reply from $orig\] $parm3\n"
		}
}

proc init_ctcp_rec {} {
	
	global ctcp_message
	global rcdir

	set ctcp_message ""
	set f [open $rcdir/ctcprc r]
	

	while 1 {
	set l [gets $f]
		if [ eof $f ] {
			close $f
			return 1
		}
#		if [string compare "#" [string index $l 0] ] {
			set ctcp_message [linsert $ctcp_message end $l]
#		}

	}

}


proc ctcp_ACTION {orig param dest} {
	global actst

        set frommsg "* $orig"
 	if [winfo exists ".zipperwin[winman $dest]" ] {
                send_to_window $dest "$actst$frommsg $param\n"
        } else {
          winmannew $orig "$orig" "priv" "1 $orig"
          insert_chan_list [string tolower $orig]
          send_to_window $orig "$actst$frommsg $param\n"
	  set_chan_activity 1 $orig
          }                                         



}

proc ctcp_DCC {orig param dest} {
	global nick
	global longip
	global xip
	
	set list [split $param " "]
	set type [lindex $list 0]
	set longip [lindex $list 2]
	set dccport [lindex $list 3]

	switch -exact $type {

	"CHAT"		{
			  set i [tk_dialog .question$dccport "Incoming DCC Chat" "$orig is requesting a \
								   DCC Chat with you."  question 0 Accept Reject Ignore]
		 	  if $i<1 { 
			  	send_to_window server "DCC Chat from: $orig\n"
 			  	dccchat "get" $orig $dccport 0
			  } elseif $i>1 {
				fake_user_in "/echo Ignoring $orig"
				fake_user_in "/ignore $orig"
			   }
				
			}

	"SEND"		{
				decode_ip	
				set filename [lindex $list 1]
				set fsize [lindex $list 4]
			  set i [tk_dialog .question$dccport "Incoming File" "$orig is sending you\
								   $filename."  question 0 Accept Reject Rename Ignore]
		 	  if $i<1 { 
				send_to_window server "DCC Send from: $orig File: $filename  Size: $fsize\n"
				exec dccsend.tcl 0 $orig $filename $xip $dccport $fsize &
			  }
		 	  if [expr $i==2] { 
				set filename [choose_file $filename "~" "save"]
				send_to_window server "DCC Send from: $orig File: $filename  Size: $fsize\n"
				exec dccsend.tcl 0 $orig $filename $xip $dccport $fsize &
			  }
		 	  if [expr $i==3] { 
				fake_user_in "/echo Ignoring $orig"
				fake_user_in "/ignore $orig"
			  }
			}

	default		{send_to_window server "Unknown DCC command from $orig: $type\n" }
	}
}
