#!/bin/sh   
# the next line restarts using wish \
exec wish "$0" "$@" 

proc dotransfer {type host port file size} {
	global f

	set f [open "|zdcc $type $host $port $file $size"]
	fileevent $f readable "handlemessage $f $size"

}


proc handlemessage {f size} {

	set l [gets $f]
	if [eof $f] {
		close $f
		return 0
	}
	if ![string compare "DONE" [string range $l 0 3]] {
		.dccxfer.msgs configure -text "Transfer Complete."
		close $f
		return 0
	}
	if ![string compare "XMSG" [string range $l 0 3]] {
		set input [string range $l 5 end]
		.dccxfer.msgs configure -text $input
		return 0
	}
	if ![string compare "XTRN" [string range $l 0 3]] {
		set input [string range $l 5 end]
		set per [expr double($input)/double($size)*100]
		setWidth $per 
		return 0
	}

}


proc createwin {name nick} {
global f
global id
global event
wm withdraw .   
set w .dccxfer
catch {destroy $w}
toplevel $w
wm iconname $w "DCC:$name"
wm title $w "DCC:$name"
#positionWindow $w


label $w.stuff -text "DCC Transfer:$nick    $name" -width 40 -relief sunken
label $w.msgs -text "Waiting..." -width 40 -relief sunken
pack $w.stuff -side top
pack $w.msgs -side top
frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.close -text "X" -command { 	destroy .
					     	exit }
pack $w.buttons.close


frame $w.frame -borderwidth 10
pack $w.frame -side top -fill x

canvas $w.frame.canvas -width 250 -height 25 -bd 0 -highlightthickness 0
set id [$w.frame.canvas create rectangle 0 0 245 20 ]
set id [$w.frame.canvas create rectangle 0 0 1 1  -fill DeepSkyBlue3 ]
pack $w.frame.canvas -side top -expand yes -anchor s -fill x  -padx 15


}
proc setWidth {w} {
	global id
	set w [expr $w*2.45]	
	.dccxfer.frame.canvas coords $id 0 0 $w 20	
}



set type [lindex $argv 0]
set nick [lindex $argv 1]
set file [lindex $argv 2]
set host [lindex $argv 3]
set port [lindex $argv 4]
set size [lindex $argv 5]
set event 0
set id ""

if ![string compare "" $size] {
	set size 0
}
set f ""
createwin $file $nick
dotransfer $type $host $port $file $size
tkwait window .dccxfer
exit
