package provide setup 1.0

proc init_setup_window {} {
	
        global textfg
	global textbg
        global version
        global nick
        global altnick
        global username
        global realname
        global hostname
        global autorejoin
        global shortnick
        global server
        global port    
	global editor
	global device
	
	set w ".zippersetup"

	toplevel $w
	wm iconname $w "ZipperSetup"
	set font 8x13

	wm title $w "Zipper Setup Window"

	frame $w.buttons
	pack $w.buttons -side bottom
	frame $w.ent
	pack $w.ent -side right


	frame $w.nick
	frame $w.altnick
	frame $w.user
	frame $w.real
	frame $w.host
	frame $w.server
	frame $w.port
	frame $w.edit
	frame $w.fg
	frame $w.bg
	frame $w.dev

	pack $w.nick -side top
	pack $w.altnick -side top
	pack $w.user -side top
	pack $w.real -side top
	pack $w.host -side top
	pack $w.server -side top
	pack $w.port -side top
	pack $w.edit -side top
	pack $w.fg -side top
	pack $w.bg -side top
	pack $w.dev -side top

	label $w.nick.nicklabel -text "Nickname" 
	label $w.altnick.altnicklabel -text "AltNickname" 
	label $w.user.userlabel -text "Username" 
	label $w.real.reallabel -text "Realname"
	label $w.host.hostlabel -text "Hostname" 
	label $w.server.serverlabel -text "Server" 
	label $w.port.portlabel -text "Port" 
	label $w.edit.editlabel -text "Editor"
	label $w.fg.fglabel -text "Text Foreground" 
	label $w.bg.bglabel -text "Text Background"
	label $w.dev.devlabel -text "Network Device"

	
	pack $w.nick.nicklabel -side left
	pack $w.altnick.altnicklabel  -side left
	pack $w.user.userlabel -side left
	pack $w.real.reallabel  -side left
	pack $w.host.hostlabel  -side left
	pack $w.server.serverlabel  -side left
	pack $w.port.portlabel  -side left
	pack $w.edit.editlabel  -side left
	pack $w.fg.fglabel  -side left
	pack $w.bg.bglabel  -side left
	pack $w.dev.devlabel -side left

	entry $w.nick.nick  -bd 2 -relief sunken -width 10 -textvariable nick 
	entry $w.altnick.altnick  -bd 2 -relief sunken -width 10 -textvariable altnick 
	entry $w.user.user  -bd 2 -relief sunken -width 10 -textvariable username
	entry $w.real.real  -bd 2 -relief sunken -width 30 -textvariable realname 
	entry $w.host.host  -bd 2 -relief sunken -width 30 -textvariable hostname 
	entry $w.server.server  -bd 2 -relief sunken -width 30 -textvariable server 
	entry $w.port.port  -bd 2 -relief sunken -width 10 -textvariable port 
	entry $w.edit.edit  -bd 2 -relief sunken -width 20 -textvariable editor 
	entry $w.fg.fg  -bd 2 -relief sunken -width 3 -textvariable textfg
	entry $w.bg.bg  -bd 2 -relief sunken -width 3 -textvariable textbg
	entry $w.dev.dev  -bd 2 -relief sunken -width 5 -textvariable device

	pack $w.nick.nick -side right
	pack $w.altnick.altnick -side right
	pack $w.user.user -side right
	pack $w.real.real -side right
	pack $w.host.host -side right
	pack $w.server.server -side right
	pack $w.port.port -side right
	pack $w.edit.edit -side right
	pack $w.fg.fg -side right
	pack $w.bg.bg -side right
	pack $w.dev.dev -side right

	button $w.buttons.save -text "Done" -command {save_user_rc ; destroy .zippersetup ; return}
	button $w.buttons.load -text ""
	button $w.buttons.quit -text "Cancel" -command {destroy .zippersetup ; return}
	pack $w.buttons.save $w.buttons.load $w.buttons.quit -side left
}


proc save_user_rc {} {
	global rcdir
        global version
        global nick
        global altnick
        global username
        global realname
        global hostname
        global autorejoin
        global shortnick
        global server
        global port    
	global editor
	global textfg
	global textbg
	global device

	set f [open $rcdir/zipperrc w]
	puts $f "version $version"
	puts $f "nick $nick"
	puts $f "textfg $textfg"
	puts $f "textbg $textbg"
	puts $f "altnick $altnick"
	puts $f "username $username"
	puts $f "realname $realname"
	puts $f "hostname $hostname"
	puts $f "autorejoin $autorejoin"
	puts $f "shortnick $shortnick"
	puts $f "server $server"
	puts $f "port $port"
	puts $f "editor $editor"
	puts $f "device $device"
	close $f
}
